/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.SelectFileTierPartitionStatePolicy;
import kafka.tier.tools.SelectFileTierPartitionStatePolicyUtils;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRemoteLeaderFileTierPartitionStatePolicy
implements SelectFileTierPartitionStatePolicy {
    private static final Logger log = LoggerFactory.getLogger(SelectRemoteLeaderFileTierPartitionStatePolicy.class);
    private final String remoteRecoveryDir;
    private final String tierConfigFile;
    private final String adminConfigFile;
    private final String bootstrapServers;
    private final boolean skipReplicationFactorCheck;
    private final int replicationFactorOverride;
    private final String outputDir;

    public SelectRemoteLeaderFileTierPartitionStatePolicy(String remoteRecoveryDir, String tierConfigFile, String adminConfigFile, String bootstrapServers, boolean skipReplicationFactorCheck, int replicationFactorOverride, String outputDir) {
        this.remoteRecoveryDir = remoteRecoveryDir;
        this.tierConfigFile = tierConfigFile;
        this.adminConfigFile = adminConfigFile;
        this.bootstrapServers = bootstrapServers;
        this.skipReplicationFactorCheck = skipReplicationFactorCheck;
        this.replicationFactorOverride = replicationFactorOverride;
        this.outputDir = outputDir;
    }

    public static String getLeaderFTPS(List<PartitionUploadInfo> ftpsList) throws RuntimeException {
        ArrayList<String> leaders = new ArrayList<String>();
        for (PartitionUploadInfo ftps2 : ftpsList) {
            if (!ftps2.isLeader) continue;
            leaders.add(ftps2.objectStorePath);
        }
        if (leaders.isEmpty()) {
            throw new RuntimeException(String.format("No leader found for the topic partition. FTPS object store paths: %s", ftpsList.stream().map(ftps -> ftps.objectStorePath).collect(Collectors.joining(", "))));
        }
        if (leaders.size() > 1) {
            throw new RuntimeException(String.format("Multiple leaders found for the topic partition. Leader FTPS object store paths: %s", String.join((CharSequence)", ", leaders)));
        }
        return (String)leaders.get(0);
    }

    @Override
    public void run(Set<TopicIdPartition> topicPartitions) throws Exception {
        TierObjectStore objectStore;
        File dir = new File(this.outputDir);
        if (dir.mkdirs()) {
            log.info("Created output directory: {}", (Object)this.outputDir);
        }
        if (!dir.exists()) {
            throw new IOException("Failed to create output directory: " + this.outputDir);
        }
        if (topicPartitions.isEmpty()) {
            throw new IllegalArgumentException("No affected topic partitions found. Exiting... Please check the input and try again");
        }
        log.info("Running SelectRemoteLeaderFileTierPartitionStatePolicy tool on the topicPartitions {}", topicPartitions);
        try {
            objectStore = TierObjectStoreUtils.objectStore(this.tierConfigFile);
        }
        catch (IOException e) {
            log.error("Failed to create object store instance with config {}", (Object)this.tierConfigFile);
            throw new UncheckedIOException(e);
        }
        HashMap<TopicIdPartition, String> leaderFTPSs = new HashMap<TopicIdPartition, String>();
        String identifier = TierMetadataRecoveryUtils.getIdentifierFromRecoveryDir(this.remoteRecoveryDir);
        Map<TopicIdPartition, List<PartitionUploadInfo>> metadataList = SelectFileTierPartitionStatePolicyUtils.getRecoveryMetadata(objectStore, identifier, this.adminConfigFile, this.bootstrapServers);
        int numPartitions = topicPartitions.size();
        ArrayList<TopicIdPartition> failedPartitions = new ArrayList<TopicIdPartition>(Collections.emptyList());
        for (TopicIdPartition topicPartition : topicPartitions) {
            try {
                List<PartitionUploadInfo> ftpsList = metadataList.getOrDefault(topicPartition, Collections.emptyList());
                SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects(this.skipReplicationFactorCheck, this.replicationFactorOverride, ftpsList);
                String leaderFTPS = SelectRemoteLeaderFileTierPartitionStatePolicy.getLeaderFTPS(ftpsList);
                leaderFTPSs.put(topicPartition, leaderFTPS);
            }
            catch (Exception e) {
                failedPartitions.add(topicPartition);
                log.error("Failed to get the leader FTPS for topicPartition {}", (Object)topicPartition, (Object)e);
            }
        }
        SelectRemoteFileTierPartitionStateOutput output = new SelectRemoteFileTierPartitionStateOutput(1, leaderFTPSs);
        SelectFileTierPartitionStatePolicyUtils.writeSelectRemoteFTPSOutputToFile(output, numPartitions, failedPartitions, this.outputDir);
    }
}

