/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import kafka.tier.tools.GetTierRecoveryDataUploadResultCommand;
import kafka.tier.tools.InitiateTierRecoveryDataUploadCommand;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.SelectRemoteFurthestFileTierPartitionStateCommand;
import kafka.tier.tools.SelectRemoteLeaderFileTierPartitionStateCommand;
import kafka.tier.tools.TierTopicConsumerRewindCommand;
import kafka.tier.tools.TierTopicHeadDataLossDetectionCommand;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;

final class TierMetadataRecoveryTool {
    TierMetadataRecoveryTool() {
    }

    public static void main(String[] args) throws Exception {
        Exit.exit((int)TierMetadataRecoveryTool.execute(args));
    }

    static int execute(String ... args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser("kafka-tier-metadata-recovery").defaultHelp(true).description("This tool will allow us to run commands which aid in tier metadata recovery. Currently supported commands include rewind, upload, select, and data-loss-validator.");
        parser.addArgument(RecoveryUtils.makeArgument("admin.config")).dest("admin.config").required(false).type(String.class).action(Arguments.store()).help("path to admin client configs");
        parser.addArgument(RecoveryUtils.makeArgument("bootstrap-servers")).dest("bootstrap-servers").required(true).type(String.class).metavar("HOST1:PORT1[,HOST2:PORT2[...]]").action(Arguments.store()).help("Comma-separated list of broker urls (host:port) to connect to. This is required for all commands.");
        Subparsers subparsers = parser.addSubparsers().dest("command").help("sub-command help");
        TierTopicHeadDataLossDetectionCommand.addCommand(subparsers);
        TierTopicConsumerRewindCommand.addCommand(subparsers);
        InitiateTierRecoveryDataUploadCommand.addCommand(subparsers);
        GetTierRecoveryDataUploadResultCommand.addCommand(subparsers);
        SelectRemoteFurthestFileTierPartitionStateCommand.addCommand(subparsers);
        SelectRemoteLeaderFileTierPartitionStateCommand.addCommand(subparsers);
        try {
            Namespace namespace = parser.parseArgs(args);
            switch (namespace.getString("command")) {
                case "tier-topic-head-data-loss-detection-command": {
                    return TierTopicHeadDataLossDetectionCommand.execute(namespace);
                }
                case "tier-topic-consumer-rewind": {
                    return TierTopicConsumerRewindCommand.execute(namespace);
                }
                case "initiate-tier-recovery-data-upload": {
                    return InitiateTierRecoveryDataUploadCommand.execute(namespace);
                }
                case "get-tier-recovery-data-upload-result": {
                    return GetTierRecoveryDataUploadResultCommand.execute(namespace);
                }
                case "select-remote-furthest-ftps": {
                    return SelectRemoteFurthestFileTierPartitionStateCommand.execute(namespace);
                }
                case "select-leader-remote-ftps": {
                    return SelectRemoteLeaderFileTierPartitionStateCommand.execute(namespace);
                }
            }
            throw new IllegalArgumentException(String.format("unknown command: %s", namespace.getString("command")));
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return 1;
        }
        catch (Exception e) {
            System.err.println(e);
            return 1;
        }
    }
}

