/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierPartitionForceRestore;
import io.confluent.kafka.storage.tier.state.Header;
import io.confluent.kafka.storage.tier.state.TierPartitionStatus;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.server.KafkaConfig;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.objects.metadata.TierStateRestoreSnapshotMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.RestoreRawLocalInput;
import kafka.tier.tools.RestoreRawRemoteURIInput;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.tier.tools.TierPartitionStateRestoreRawInputGenerator;
import kafka.tier.tools.common.RestoreComparatorInfo;
import kafka.tier.tools.common.RestoreRawInputInfoLocal;
import kafka.tier.tools.common.RestoreRawInputInfoRemoteURI;
import kafka.tier.topic.TierTopic;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.MergedLogUtils;

public class TierPartitionStateRestoreTrigger {
    public static final String RESTORE_INPUT_COMPARATOR_CONFIG = "comparator.json";
    private static final String RESTORE_INPUT_COMPARATOR_CONFIG_ARG = RecoveryUtils.makeArgument("comparator.json");
    public static final String RESTORE_INPUT_COMPARATOR_DOC = "JSON input file generated by kafka.tier.tools.TierMetadataComparator and reviewed by an administrator. This file contains paths to partitions and replica TierPartitionState(s) to choose to restore.";
    public static final String RESTORE_OUTPUT_CONFIG = "output.json";
    public static final String RESTORE_OUTPUT_DOC = "Path for output file where recovery information will be emitted, including TierPartitionForceRestore metadata.";
    private static final String FENCE_RESULT_JSON_FILE_ARG = RecoveryUtils.makeArgument("fence.json");
    private static final String RESTORE_LOCAL_TIER_STATE_ROOT_DIR_ARG = RecoveryUtils.makeArgument("restore.tier.state.root.dir");
    private static final String RESTORE_REMOTE_TIER_STATE_URI_FILE_ARG = RecoveryUtils.makeArgument("restore.remote.tier.state.uris.file");

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(TierPartitionStateRestoreTrigger.class.getName()).defaultHelp(true).description("Provides a command to restore partition states using a TierPartitionForceRestore event.");
        parser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(RecoveryUtils.makeArgument(RESTORE_OUTPUT_CONFIG)).dest(RESTORE_OUTPUT_CONFIG).type(String.class).required(true).help(RESTORE_OUTPUT_DOC);
        ArgumentGroup comparatorInputGroup = parser.addArgumentGroup("Comparator input mode").description("Used to supply the output of comparator, as input to restore partition states.");
        comparatorInputGroup.addArgument(RESTORE_INPUT_COMPARATOR_CONFIG_ARG).dest(RESTORE_INPUT_COMPARATOR_CONFIG).type(String.class).help(RESTORE_INPUT_COMPARATOR_DOC);
        ArgumentGroup rawInputGroup = parser.addArgumentGroup("Raw input mode with local ftps file").description("Used to supply (1) the raw output of the fencing command and (2) target local tier partition state files, as input to restore partition states.");
        rawInputGroup.addArgument(FENCE_RESULT_JSON_FILE_ARG).dest("fence.json").type(String.class).help("The path to a JSON file containing the output of the successful fencing command.");
        MutuallyExclusiveGroup ftpsFileDestGroup = parser.addMutuallyExclusiveGroup().required(false);
        ftpsFileDestGroup.addArgument(RESTORE_LOCAL_TIER_STATE_ROOT_DIR_ARG).dest("restore.tier.state.root.dir").type(String.class).help("The path to the local root directory containing the tier partition state files to be restored. The files should be organized under the root directory as: /path/to/ftps_root_dir/<TOPIC>-<PARTITION>/<TIER-STATE-FILE>. There should be exactly one <TIER-STATE-FILE> under each <TOPIC-PARTITION> sub directory.");
        ftpsFileDestGroup.addArgument(RESTORE_REMOTE_TIER_STATE_URI_FILE_ARG).dest("restore.remote.tier.state.uris.file").type(String.class).help("The path to the file containing a map of topic partitions to its respective tier partition state file path in the remote object store");
        return parser;
    }

    static TierObjectStore getObjectStore(Time time, Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(time, backend, config);
    }

    private static List<RestoreComparatorInfo.RestoreComparatorInput> getRestoreComparatorInput(Path inputJsonFile) {
        if (Files.notExists(inputJsonFile, new LinkOption[0]) || !Files.isRegularFile(inputJsonFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Comparator input file does not exist: " + String.valueOf(inputJsonFile));
        }
        try {
            return RestoreComparatorInfo.RestoreComparatorInput.readJsonFromFile(inputJsonFile);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + String.valueOf(inputJsonFile), e);
        }
    }

    private static void validateInputPaths(boolean hasInputComparatorPath, boolean hasInputFenceResultPath, boolean hasRestoreTierStateRootDir, boolean hasRestoreTierStateRemoteURI, ArgumentParser parser) throws ArgumentParserException {
        String errorMsg = String.format("Either %s should be supplied OR both %s and (%s or %s) should be supplied.", RESTORE_INPUT_COMPARATOR_CONFIG_ARG, FENCE_RESULT_JSON_FILE_ARG, RESTORE_LOCAL_TIER_STATE_ROOT_DIR_ARG, RESTORE_REMOTE_TIER_STATE_URI_FILE_ARG);
        if (hasInputComparatorPath ? hasInputFenceResultPath || hasRestoreTierStateRootDir || hasRestoreTierStateRemoteURI : !hasInputFenceResultPath || !hasRestoreTierStateRootDir && !hasRestoreTierStateRemoteURI) {
            throw new ArgumentParserException(errorMsg, parser);
        }
    }

    private static void run(ArgumentParser parser, Namespace args) throws Exception {
        Properties props;
        RestoreRawLocalInput restoreRawInputLocal = new RestoreRawLocalInput();
        RestoreRawRemoteURIInput restoreRawInputRemoteURI = new RestoreRawRemoteURIInput();
        Time time = Time.SYSTEM;
        String propertiesConfFile = args.getString("tier.config").trim();
        try {
            ArrayList<String> allProps = new ArrayList<String>();
            allProps.addAll(TierObjectStoreUtils.OBJECT_STORE_REQUIRED_PROPERTIES);
            allProps.addAll(ProducerConfig.configNames());
            props = Utils.loadProps((String)propertiesConfFile, allProps);
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format("Can not load properties from file: '%s'", propertiesConfFile), e, parser);
        }
        String bootstrapServers = props.getProperty("bootstrap.servers", "").trim();
        if (bootstrapServers.isEmpty()) {
            throw new ArgumentParserException(String.format("The provided properties conf file: '%s' can not contain empty or absent bootstrap servers as value for the property: '%s'", propertiesConfFile, "bootstrap.servers"), parser);
        }
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        String inputComparatorPath = args.getString(RESTORE_INPUT_COMPARATOR_CONFIG);
        boolean hasInputComparatorPath = inputComparatorPath != null && inputComparatorPath.length() > 0;
        String inputFenceResultPath = args.getString("fence.json");
        boolean hasInputFenceResultPath = inputFenceResultPath != null && inputFenceResultPath.length() > 0;
        String restoreTierStateRootDir = args.getString("restore.tier.state.root.dir");
        boolean hasRestoreTierStateRootDir = restoreTierStateRootDir != null && restoreTierStateRootDir.length() > 0;
        String restoreTierStateRemoteURI = args.getString("restore.remote.tier.state.uris.file");
        boolean hasRestoreTierStateRemoteURI = restoreTierStateRemoteURI != null && restoreTierStateRemoteURI.length() > 0;
        TierPartitionStateRestoreTrigger.validateInputPaths(hasInputComparatorPath, hasInputFenceResultPath, hasRestoreTierStateRootDir, hasRestoreTierStateRemoteURI, parser);
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        String outputPath = args.getString(RESTORE_OUTPUT_CONFIG).trim();
        File outputFile = new File(outputPath);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputPath);
        }
        if (!outputFile.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputPath);
        }
        if (hasInputComparatorPath) {
            List<RestoreComparatorInfo.RestoreComparatorInput> input = TierPartitionStateRestoreTrigger.getRestoreComparatorInput(Paths.get(inputComparatorPath.trim(), new String[0]));
            TierPartitionStateRestoreTrigger.injectStateFromComparatorInput(time, props, tierTopicName, outputFile, input);
        } else if (hasRestoreTierStateRootDir) {
            List<RestoreRawInputInfoLocal> input = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInput(args);
            restoreRawInputLocal.injectStateFromRestoreInput(time, props, tierTopicName, outputFile, input);
        } else {
            List<RestoreRawInputInfoRemoteURI> input = TierPartitionStateRestoreRawInputGenerator.generateRestoreRawInputRemoteURI(args);
            restoreRawInputRemoteURI.injectStateFromRestoreInput(time, props, tierTopicName, outputFile, input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectStateFromComparatorInput(Time time, Properties props, String tierTopicName, File outputFile, List<RestoreComparatorInfo.RestoreComparatorInput> inputs) throws Exception {
        Producer<byte[], byte[]> producer = null;
        TierObjectStore objectStore = null;
        FileOutputStream fos = null;
        try {
            producer = RecoveryUtils.createTierTopicProducer(props, TierPartitionStateRestoreTrigger.class.getSimpleName());
            objectStore = TierPartitionStateRestoreTrigger.getObjectStore(time, props);
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            ArrayList<RestoreComparatorInfo.RestoreComparatorOutput> outputs = new ArrayList<RestoreComparatorInfo.RestoreComparatorOutput>();
            for (RestoreComparatorInfo.RestoreComparatorInput input : inputs) {
                if (!input.choice().validationSuccess()) {
                    System.out.println("Comparator did not produce a valid injection for " + String.valueOf(input));
                    continue;
                }
                File file = input.choice().path().toFile();
                Boolean restoreLogStartOffset = input.input().freezeMergedLogStartOffset;
                TierPartitionForceRestore restore = TierPartitionStateRestoreTrigger.injectState(tierTopicName, numTierTopicPartitions, producer, objectStore, file, restoreLogStartOffset);
                RestoreComparatorInfo.RestoreComparatorOutput output = new RestoreComparatorInfo.RestoreComparatorOutput(input, restore.toString());
                outputs.add(output);
            }
            fos = new FileOutputStream(outputFile);
            RestoreComparatorInfo.RestoreComparatorOutput.writeJsonToFile(outputs, fos);
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (objectStore != null) {
                objectStore.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static TierPartitionForceRestore injectState(String tierTopicName, int numTierTopicPartitions, Producer<byte[], byte[]> producer, TierObjectStore objectStore, File file, Boolean restoreLogStartOffset) throws Exception {
        TopicPartition topicPartition = MergedLogUtils.parseTopicPartitionName(file.getParentFile());
        try (CheckedFileIO fileChannel = CheckedFileIO.open(file.toPath(), StandardOpenOption.READ);){
            TierPartitionStatus expectedStatus;
            System.out.printf("Attempting recovery for %s @ %s%n", topicPartition, file);
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                throw new Exception("Header is not present for TierPartitionState being recovered");
            }
            Header header = headerOpt.get();
            TierPartitionStatus tierPartitionStatus = expectedStatus = restoreLogStartOffset != false ? TierPartitionStatus.FROZEN_LOG_START_OFFSET : TierPartitionStatus.ERROR;
            if (header.status() != expectedStatus) {
                throw new Exception(String.format("Header is not in the expected status: %s Header: %s", new Object[]{expectedStatus, header.toString()}));
            }
            UUID restoreUuid = UUID.randomUUID();
            String hash = TierPartitionStateRestoreTrigger.computeMd5(fileChannel);
            Algorithm checksumAlgorithm = ChecksumUtils.tierStateFileAlgorithm(file.toPath());
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), header.topicId(), topicPartition.partition());
            TierPartitionForceRestore restoreEvent = new TierPartitionForceRestore(topicIdPartition, restoreUuid, header.startOffset(), header.endOffset(), header.localMaterializedOffsetAndEpoch(), hash, restoreLogStartOffset, checksumAlgorithm.id);
            objectStore.putObject(new TierStateRestoreSnapshotMetadata(restoreEvent), file, ObjectType.TIER_STATE_SNAPSHOT);
            RecordMetadata metadata = RecoveryUtils.injectTierTopicEvent(producer, restoreEvent, tierTopicName, numTierTopicPartitions);
            System.out.printf("Emitted tier topic recovery event: %s for %s%n", metadata, header);
            TierPartitionForceRestore tierPartitionForceRestore = restoreEvent;
            return tierPartitionForceRestore;
        }
    }

    private static String computeMd5(CheckedFileIO fileChannel) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        if (fileChannel.size() == 0L) {
            throw new IllegalArgumentException("Empty FileChannel supplied to computeMd5.");
        }
        if (fileChannel.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File exceeds maximum size of 2147483647 vs " + fileChannel.size());
        }
        ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, (int)fileChannel.size()));
        for (long position = 0L; position < fileChannel.size(); position += (long)buffer.remaining()) {
            fileChannel.read(buffer, position);
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }
        return String.format("%032x", new BigInteger(1, digest.digest()));
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateRestoreTrigger.createArgParser();
            try {
                TierPartitionStateRestoreTrigger.run(parser, parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

