/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;
import kafka.tier.topic.recovery.ReconciledTierTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import org.apache.kafka.common.TopicPartition;

public class TierTopicHeadDataLossReportReconciler {
    public static ReconciledTierTopicHeadDataLossReport reconcileReportIncrementally(TierTopicHeadDataLossReport brokerReport, ReconciledTierTopicHeadDataLossReport existingReconciledReport) throws IOException {
        int brokerId = brokerReport.brokerId();
        if (existingReconciledReport.errorMessages().containsKey(brokerId)) {
            throw new IllegalArgumentException("Can't insert a duplicate entry for replicaId:" + brokerId + " into existing error messages");
        }
        if (existingReconciledReport.durationMs().containsKey(brokerId)) {
            throw new IllegalArgumentException("Can't insert a duplicate entry for replicaId:" + brokerId + " into existing durations map");
        }
        TierTopicHeadDataLossReport.CompletionStatus completionStatus = TierTopicHeadDataLossReportReconciler.reconcileCompletionStatus(existingReconciledReport.completionStatus(), brokerReport.completionStatus());
        TierTopicHeadDataLossReportReconciler.reconcileUserPartitions(brokerId, brokerReport.affectedUserTopicPartitions(), existingReconciledReport.affectedUserTopicPartitions());
        TierTopicHeadDataLossReportReconciler.reconcileTierTopicPartitions(brokerId, brokerReport.affectedTierTopicPartitions(), existingReconciledReport.affectedTierTopicPartitions());
        TierTopicHeadDataLossReportReconciler.reconcilePartitionInfo(brokerId, brokerReport.failedTierTopicPartitions(), existingReconciledReport.failedTierTopicPartitions());
        TierTopicHeadDataLossReportReconciler.reconcilePartitionInfo(brokerId, brokerReport.userPartitionsWithFencingFailures(), existingReconciledReport.userPartitionsWithFencingFailures());
        if (!brokerReport.errorMessages().isEmpty()) {
            existingReconciledReport.errorMessages().put(brokerId, brokerReport.errorMessages());
        }
        existingReconciledReport.durationMs().put(brokerId, brokerReport.durationMs());
        return ReconciledTierTopicHeadDataLossReport.createReport(completionStatus, existingReconciledReport.affectedUserTopicPartitions(), existingReconciledReport.affectedTierTopicPartitions(), existingReconciledReport.failedTierTopicPartitions(), existingReconciledReport.userPartitionsWithFencingFailures(), existingReconciledReport.errorMessages(), existingReconciledReport.durationMs());
    }

    private static TierTopicHeadDataLossReport.CompletionStatus reconcileCompletionStatus(TierTopicHeadDataLossReport.CompletionStatus existingReconciledStatus, TierTopicHeadDataLossReport.CompletionStatus brokerStatus) {
        if (brokerStatus == TierTopicHeadDataLossReport.CompletionStatus.FAILURE) {
            return TierTopicHeadDataLossReport.CompletionStatus.FAILURE;
        }
        return existingReconciledStatus;
    }

    private static void reconcileUserPartitions(int replicaId, Map<TopicIdPartition, AffectedUserTopicPartitionInfo> replicaAffectedUtps, Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> existingReconciledAffectedUtps) throws IOException {
        for (Map.Entry<TopicIdPartition, AffectedUserTopicPartitionInfo> entry : replicaAffectedUtps.entrySet()) {
            TopicIdPartition utp = entry.getKey();
            AffectedUserTopicPartitionInfo affectedPartitionInfo = entry.getValue();
            Map<Integer, AffectedUserTopicPartitionInfo> existingPerBrokerUtpInfo = existingReconciledAffectedUtps.get(utp);
            if (existingPerBrokerUtpInfo == null) {
                existingReconciledAffectedUtps.put(utp, new HashMap<Integer, AffectedUserTopicPartitionInfo>(Map.of(replicaId, affectedPartitionInfo)));
                continue;
            }
            AffectedUserTopicPartitionInfo item = existingPerBrokerUtpInfo.get(replicaId);
            if (item != null) {
                throw new IllegalArgumentException(String.format("For partition: %s, can't insert duplicate entry for replica ID: %s, an entry already exists with: %s", utp, replicaId, AffectedUserTopicPartitionInfo.getJsonPrettyString(item)));
            }
            existingPerBrokerUtpInfo.put(replicaId, affectedPartitionInfo);
        }
    }

    private static void reconcileTierTopicPartitions(int replicaId, Map<TopicPartition, AffectedTierTopicPartitionInfo> brokerAffectedTtps, Map<TopicPartition, ReconciledTierTopicPartitionInfo> existingReconciledAffectedTtps) {
        for (Map.Entry<TopicPartition, AffectedTierTopicPartitionInfo> entry : brokerAffectedTtps.entrySet()) {
            TopicPartition partition = entry.getKey();
            ReconciledTierTopicPartitionInfo existingInfo = existingReconciledAffectedTtps.get(partition);
            AffectedTierTopicPartitionInfo newInfo = brokerAffectedTtps.get(partition);
            if (existingInfo == null) {
                existingReconciledAffectedTtps.put(partition, new ReconciledTierTopicPartitionInfo(newInfo.maxLastMaterializedOffsetAndEpoch().offset(), newInfo.maxLastMaterializedPartition(), replicaId, newInfo.tierTopicEndOffsetAndEpoch(), newInfo.maxLastMaterializedPartition(), replicaId));
                continue;
            }
            long chosenMaxLastMaterializedOffset = existingInfo.maxLastMaterializedOffset();
            TopicIdPartition chosenMaxLastMaterializedUserPartition = existingInfo.maxLastMaterializedUserPartition();
            int chosenMaxLastMaterializedReplicaId = existingInfo.maxLastMaterializedReplicaId();
            if (newInfo.maxLastMaterializedOffsetAndEpoch().offset() > chosenMaxLastMaterializedOffset) {
                chosenMaxLastMaterializedOffset = newInfo.maxLastMaterializedOffsetAndEpoch().offset();
                chosenMaxLastMaterializedUserPartition = newInfo.maxLastMaterializedPartition();
                chosenMaxLastMaterializedReplicaId = replicaId;
            }
            OffsetAndEpoch chosenMinTierTopicEndOffsetAndEpoch = existingInfo.minTierTopicEndOffsetAndEpoch();
            TopicIdPartition chosenMinTierTopicEndOffsetAndEpochUserPartition = existingInfo.minTierTopicEndOffsetAndEpochUserPartition();
            int chosenMinTierTopicEndOffsetAndEpochReplicaId = existingInfo.minTierTopicEndOffsetAndEpochReplicaId();
            if (TierTopicHeadDataLossReportReconciler.isStrictlySmaller(newInfo.tierTopicEndOffsetAndEpoch(), chosenMinTierTopicEndOffsetAndEpoch)) {
                chosenMinTierTopicEndOffsetAndEpoch = newInfo.tierTopicEndOffsetAndEpoch();
                chosenMinTierTopicEndOffsetAndEpochUserPartition = newInfo.maxLastMaterializedPartition();
                chosenMinTierTopicEndOffsetAndEpochReplicaId = replicaId;
            }
            existingReconciledAffectedTtps.put(partition, new ReconciledTierTopicPartitionInfo(chosenMaxLastMaterializedOffset, chosenMaxLastMaterializedUserPartition, chosenMaxLastMaterializedReplicaId, chosenMinTierTopicEndOffsetAndEpoch, chosenMinTierTopicEndOffsetAndEpochUserPartition, chosenMinTierTopicEndOffsetAndEpochReplicaId));
        }
    }

    private static <ItemType> void reconcilePartitionInfo(int replicaId, Set<ItemType> perBrokerField, Map<ItemType, Set<Integer>> existingReconciledData) {
        for (ItemType utp : perBrokerField) {
            Set<Integer> brokers = existingReconciledData.get(utp);
            if (brokers == null) {
                brokers = new HashSet<Integer>();
            } else if (brokers.contains(replicaId)) {
                throw new IllegalArgumentException("Can't insert a duplicate entry for replica ID:" + replicaId);
            }
            brokers.add(replicaId);
            existingReconciledData.put(utp, brokers);
        }
    }

    private static boolean isStrictlySmaller(OffsetAndEpoch a, OffsetAndEpoch b) {
        int bEpoch;
        int aEpoch = a.epoch().orElse(-1);
        if (aEpoch == (bEpoch = b.epoch().orElse(-1).intValue())) {
            return a.offset() < b.offset();
        }
        return aEpoch < bEpoch;
    }
}

