/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopicUtils {
    private static final Logger log = LoggerFactory.getLogger(TierTopicUtils.class);
    private static final int DEFAULT_CREATION_MAX_ATTEMPTS = 90;
    private static final int DEFAULT_CREATION_RETRY_BACKOFF_MS = 10000;

    static IsValidRewind validateRewindOffsetByPolicy(OffsetAndEpoch rewindOffsetAndEpoch, OffsetAndEpoch localOffsetAndEpoch, OffsetAndEpoch flushedOffsetAndEpoch, TierTopicConsumerRewindPolicy policy) {
        if (localOffsetAndEpoch == null || flushedOffsetAndEpoch == null) {
            switch (policy) {
                case SKIP_MISSING_PARTITIONS: {
                    return IsValidRewind.SKIPPED;
                }
                case FAIL_ON_MISSING_PARTITIONS: {
                    return IsValidRewind.FAILED_MISSING;
                }
            }
        }
        if (rewindOffsetAndEpoch.offset() > flushedOffsetAndEpoch.offset() || rewindOffsetAndEpoch.offset() > localOffsetAndEpoch.offset()) {
            return IsValidRewind.FAILED_AHEAD;
        }
        return IsValidRewind.VALID;
    }

    public static String rewindPositionsAsString(Map<Integer, OffsetAndEpoch> partitionToPosition) {
        return partitionToPosition.entrySet().stream().map(entry -> String.format("tp=%s:(offset=%s,epoch=%s)", entry.getKey(), ((OffsetAndEpoch)entry.getValue()).offset(), ((OffsetAndEpoch)entry.getValue()).epoch())).collect(Collectors.joining(", "));
    }

    public static Producer<byte[], byte[]> getProducerWithRetries(Supplier<Producer<byte[], byte[]>> producerSupplier, Supplier<Boolean> shouldStopRetryingProducerCreation, Time time) {
        log.info("Attempting to create producer with retries");
        return TierTopicUtils.getWithRetries(producerSupplier, shouldStopRetryingProducerCreation, time, 90, 10000);
    }

    public static Consumer<byte[], byte[]> getConsumerWithRetries(Supplier<Consumer<byte[], byte[]>> consumerSupplier, Supplier<Boolean> shouldStopRetryingConsumerCreation, Time time) {
        log.info("Attempting to create consumer with retries");
        return TierTopicUtils.getWithRetries(consumerSupplier, shouldStopRetryingConsumerCreation, time, 90, 10000);
    }

    public static <T> T getWithRetries(Supplier<T> supplier, Supplier<Boolean> shouldStopRetryingCreation, Time time, int maxAttempts, int retryBackoffMs) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxRetries should be > 0, but received " + maxAttempts);
        }
        if (retryBackoffMs <= 0) {
            throw new IllegalArgumentException("retryBackoffMs should be > 0, but received " + retryBackoffMs);
        }
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                boolean isRetriable = e instanceof ConfigException;
                for (Throwable cause = e.getCause(); !isRetriable && cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                    if (!(cause instanceof ConfigException)) continue;
                    isRetriable = true;
                }
                if (!isRetriable) {
                    throw e;
                }
                String errorMsg = String.format("[%d/%d] Failed to construct from supplier due to a retriable error", attempt, maxAttempts);
                if (attempt == maxAttempts) {
                    log.error("{}, giving up permanently as retry limit of {} was reached", new Object[]{errorMsg, maxAttempts, e});
                    throw e;
                }
                if (shouldStopRetryingCreation.get().booleanValue()) {
                    log.error("{}, giving up permanently as shouldStopRetryingCreation is true", (Object)errorMsg, (Object)e);
                    throw e;
                }
                log.warn("{}, retrying...", (Object)errorMsg, (Object)e);
                time.sleep((long)retryBackoffMs);
                continue;
            }
        }
        throw new RuntimeException("Unexpected operation");
    }

    static enum IsValidRewind {
        VALID,
        FAILED_MISSING,
        FAILED_AHEAD,
        SKIPPED;

    }
}

