/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic.recovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ReconciledTierTopicPartitionInfo;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import org.apache.kafka.common.TopicPartition;

public class ReconciledTierTopicHeadDataLossReport {
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    public static final short VERSION_V1 = 1;
    public static final short VERSION = 1;
    private final TierTopicHeadDataLossReport.CompletionStatus completionStatus;
    private final short version;
    private final Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions;
    private final Map<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions;
    private final Map<TopicPartition, Set<Integer>> failedTierTopicPartitions;
    private final Map<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures;
    private final Map<Integer, List<String>> errorMessages;
    private final Map<Integer, Long> durationMs;
    private final String creationTimestamp;

    @JsonCreator
    public ReconciledTierTopicHeadDataLossReport(@JsonProperty(value="completion_status", required=true) TierTopicHeadDataLossReport.CompletionStatus completionStatus, @JsonProperty(value="version", required=true) short version, @JsonProperty(value="affected_user_topic_partitions", required=true) Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions, @JsonProperty(value="affected_tier_topic_partitions", required=true) Map<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions, @JsonProperty(value="failed_tier_topic_partitions", required=true) Map<TopicPartition, Set<Integer>> failedTierTopicPartitions, @JsonProperty(value="user_partitions_with_fencing_failures", required=true) Map<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures, @JsonProperty(value="error_messages", required=true) Map<Integer, List<String>> errorMessages, @JsonProperty(value="duration_ms", required=true) Map<Integer, Long> durationMs, @JsonProperty(value="creation_timestamp", required=true) String creationTimestamp) {
        switch (completionStatus) {
            case SUCCESS: {
                if (!ReconciledTierTopicHeadDataLossReport.hasFailures(failedTierTopicPartitions, userPartitionsWithFencingFailures, errorMessages)) break;
                throw new IllegalArgumentException(String.format("CompletionStatus:%s can't be supplied when there are errors", new Object[]{completionStatus}));
            }
            case FAILURE: {
                if (!errorMessages.isEmpty() && !failedTierTopicPartitions.isEmpty()) break;
                throw new IllegalArgumentException(String.format("CompletionStatus:%s can't be supplied without errors", new Object[]{completionStatus}));
            }
        }
        this.completionStatus = completionStatus;
        this.version = version;
        this.affectedUserTopicPartitions = affectedUserTopicPartitions;
        this.affectedTierTopicPartitions = affectedTierTopicPartitions;
        this.failedTierTopicPartitions = failedTierTopicPartitions;
        this.userPartitionsWithFencingFailures = userPartitionsWithFencingFailures;
        this.errorMessages = errorMessages;
        this.durationMs = durationMs;
        this.creationTimestamp = creationTimestamp;
    }

    public static ReconciledTierTopicHeadDataLossReport createReport(TierTopicHeadDataLossReport.CompletionStatus completionStatus, Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions, Map<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions, Map<TopicPartition, Set<Integer>> failedTierTopicPartitions, Map<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures, Map<Integer, List<String>> errorMessages, Map<Integer, Long> durationMs) {
        return new ReconciledTierTopicHeadDataLossReport(completionStatus, 1, affectedUserTopicPartitions, affectedTierTopicPartitions, failedTierTopicPartitions, userPartitionsWithFencingFailures, errorMessages, durationMs, TierTopicHeadDataLossReport.currentTimestamp());
    }

    public static ReconciledTierTopicHeadDataLossReport createEmptyReport() {
        return ReconciledTierTopicHeadDataLossReport.createReport(TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, new HashMap<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>>(), new HashMap<TopicPartition, ReconciledTierTopicPartitionInfo>(), new HashMap<TopicPartition, Set<Integer>>(), new HashMap<TopicIdPartition, Set<Integer>>(), new HashMap<Integer, List<String>>(), new HashMap<Integer, Long>());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReconciledTierTopicHeadDataLossReport that = (ReconciledTierTopicHeadDataLossReport)o;
        return this.checkEqualityExcludingCreationTime(that) && Objects.equals(this.creationTimestamp, that.creationTimestamp);
    }

    public boolean checkEqualityExcludingCreationTime(ReconciledTierTopicHeadDataLossReport that) {
        return this.completionStatus == that.completionStatus && this.version == that.version && this.checkEqualityOfPartitionAttributes(that) && Objects.equals(this.errorMessages, that.errorMessages) && Objects.equals(this.durationMs, that.durationMs);
    }

    private boolean checkEqualityOfPartitionAttributes(ReconciledTierTopicHeadDataLossReport that) {
        return Objects.equals(this.affectedUserTopicPartitions, that.affectedUserTopicPartitions) && Objects.equals(this.affectedTierTopicPartitions, that.affectedTierTopicPartitions) && Objects.equals(this.failedTierTopicPartitions, that.failedTierTopicPartitions) && Objects.equals(this.userPartitionsWithFencingFailures, that.userPartitionsWithFencingFailures);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.completionStatus, this.version, this.affectedUserTopicPartitions, this.affectedTierTopicPartitions, this.failedTierTopicPartitions, this.userPartitionsWithFencingFailures, this.errorMessages, this.durationMs, this.creationTimestamp});
    }

    public String toString() {
        try {
            return "ReconciledTierTopicHeadDataLossReport: " + ReconciledTierTopicHeadDataLossReport.getJsonPrettyString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonProperty(value="completion_status", required=true)
    public TierTopicHeadDataLossReport.CompletionStatus completionStatus() {
        return this.completionStatus;
    }

    @JsonProperty(value="version", required=true)
    public short version() {
        return this.version;
    }

    @JsonProperty(value="affected_user_topic_partitions", required=true)
    public Map<TopicIdPartition, Map<Integer, AffectedUserTopicPartitionInfo>> affectedUserTopicPartitions() {
        return this.affectedUserTopicPartitions;
    }

    @JsonProperty(value="affected_tier_topic_partitions", required=true)
    public Map<TopicPartition, ReconciledTierTopicPartitionInfo> affectedTierTopicPartitions() {
        return this.affectedTierTopicPartitions;
    }

    @JsonProperty(value="failed_tier_topic_partitions", required=true)
    public Map<TopicPartition, Set<Integer>> failedTierTopicPartitions() {
        return this.failedTierTopicPartitions;
    }

    @JsonProperty(value="user_partitions_with_fencing_failures", required=true)
    public Map<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures() {
        return this.userPartitionsWithFencingFailures;
    }

    @JsonProperty(value="error_messages", required=true)
    public Map<Integer, List<String>> errorMessages() {
        return this.errorMessages;
    }

    @JsonProperty(value="duration_ms", required=true)
    public Map<Integer, Long> durationMs() {
        return this.durationMs;
    }

    @JsonProperty(value="creation_timestamp", required=true)
    public String creationTimestamp() {
        return this.creationTimestamp;
    }

    private static boolean hasFailures(Map<TopicPartition, Set<Integer>> failedTierTopicPartitions, Map<TopicIdPartition, Set<Integer>> userPartitionsWithFencingFailures, Map<Integer, List<String>> errorMessages) {
        return !failedTierTopicPartitions.isEmpty() || !userPartitionsWithFencingFailures.isEmpty() || !errorMessages.isEmpty();
    }

    public static void writeJsonToFile(ReconciledTierTopicHeadDataLossReport info, OutputStream outputStream) throws IOException {
        JSON_SERDE.writeValue(outputStream, (Object)info);
    }

    public static String getJsonPrettyString(ReconciledTierTopicHeadDataLossReport report) throws JsonProcessingException {
        return JSON_SERDE.writerWithDefaultPrettyPrinter().writeValueAsString(report);
    }

    public static ReconciledTierTopicHeadDataLossReport readJsonFromFile(Path inputJsonPath) throws IOException {
        return JSON_SERDE.readValue(inputJsonPath.toFile(), new TypeReference<ReconciledTierTopicHeadDataLossReport>(){});
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(TopicIdPartition.class, new JsonSerializer<TopicIdPartition>(){

            @Override
            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicIdPartition.class, new JsonDeserializer<TopicIdPartition>(){

            @Override
            public TopicIdPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicIdPartition.fromString(p.getValueAsString());
            }
        });
        module.addSerializer(TopicPartition.class, new JsonSerializer<TopicPartition>(){

            @Override
            public void serialize(TopicPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicPartition.class, new JsonDeserializer<TopicPartition>(){

            @Override
            public TopicPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicPartition.fromString((String)p.getValueAsString());
            }
        });
        JSON_SERDE.registerModules(module, new Jdk8Module());
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

