/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic.recovery;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SelectRemoteFileTierPartitionStateOutput {
    public static final short VERSION_V1 = 1;
    public static final short VERSION = 1;
    private final short version;
    private final Map<TopicIdPartition, String> selectedFTPS;

    public SelectRemoteFileTierPartitionStateOutput(short version, Map<TopicIdPartition, String> selectedFTPS) {
        this.version = version;
        this.selectedFTPS = selectedFTPS;
    }

    public short version() {
        return this.version;
    }

    public Map<TopicIdPartition, String> selectedFTPS() {
        return this.selectedFTPS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectRemoteFileTierPartitionStateOutput that = (SelectRemoteFileTierPartitionStateOutput)o;
        return this.version == that.version && Objects.equals(this.selectedFTPS, that.selectedFTPS);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.selectedFTPS);
    }

    public static void writeToFile(SelectRemoteFileTierPartitionStateOutput output, File file) throws FileNotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(output.version()).append("\n");
        String remoteURIInfo = output.selectedFTPS().entrySet().stream().map(entry -> ((TopicIdPartition)entry.getKey()).toString() + " " + (String)entry.getValue()).collect(Collectors.joining("\n"));
        stringBuilder.append(remoteURIInfo);
        String fileContent = stringBuilder.toString();
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(fileContent);
        }
    }

    public static SelectRemoteFileTierPartitionStateOutput readFromFile(Path selectOutputFilePath) throws IOException {
        short selectFtpsOutputCurrentVersion;
        HashMap<TopicIdPartition, String> remoteURIsInfo = new HashMap<TopicIdPartition, String>();
        try (BufferedReader reader = Files.newBufferedReader(selectOutputFilePath);){
            String line;
            try {
                selectFtpsOutputCurrentVersion = Short.parseShort(reader.readLine());
                if (selectFtpsOutputCurrentVersion != 1) {
                    throw new IOException(String.format("Invalid version in select-remote-ftps output. Expected: %s but found: %s", (short)1, selectFtpsOutputCurrentVersion));
                }
            }
            catch (NumberFormatException e) {
                throw new IOException();
            }
            while ((line = reader.readLine()) != null) {
                String[] remoteURIInfo = line.trim().split(" ");
                String topicIdPartitionInfo = remoteURIInfo[0];
                String remoteURI = remoteURIInfo[1];
                remoteURIsInfo.put(TopicIdPartition.fromString(topicIdPartitionInfo.trim()), remoteURI);
            }
        }
        return new SelectRemoteFileTierPartitionStateOutput(selectFtpsOutputCurrentVersion, remoteURIsInfo);
    }
}

