/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeMap;
import kafka.server.KafkaConfig;
import kafka.tools.TerseFailure;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map;
import scala.collection.mutable.TreeSet;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StorageTool$
implements Logging {
    public static final StorageTool$ MODULE$ = new StorageTool$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        StorageTool$ storageTool$ = this;
        synchronized (storageTool$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        Integer exitCode = Predef$.MODULE$.int2Integer(0);
        Option message = None$.MODULE$;
        try {
            exitCode = Predef$.MODULE$.int2Integer(this.execute(args, System.out));
        }
        catch (FormatterException e) {
            exitCode = Predef$.MODULE$.int2Integer(1);
            message = new Some<String>(e.getMessage());
        }
        catch (TerseFailure e) {
            exitCode = Predef$.MODULE$.int2Integer(1);
            message = new Some<String>(e.getMessage());
        }
        message.foreach((Function1<String, Object> & Serializable)x$1 -> {
            System.err.println(x$1);
            return BoxedUnit.UNIT;
        });
        Exit.exit((int)Predef$.MODULE$.Integer2int(exitCode), (String)((String)message.orNull($less$colon$less$.MODULE$.refl())));
    }

    public int execute(String[] args, PrintStream printStream) {
        Namespace namespace;
        try {
            namespace = this.parseArguments(args);
        }
        catch (HelpScreenException helpScreenException) {
            return 0;
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            return 1;
        }
        Namespace namespace2 = namespace;
        String command = namespace2.getString("command");
        Option config = Option$.MODULE$.apply(namespace2.getString("config")).flatMap((Function1<String, Some> & Serializable)p -> new Some<KafkaConfig>(new KafkaConfig(Utils.loadProps((String)p))));
        String string = command;
        switch (string == null ? 0 : string.hashCode()) {
            case -1268779017: {
                if (!"format".equals(string)) break;
                this.runFormatCommand(namespace2, (KafkaConfig)config.get(), printStream);
                return 0;
            }
            case -1176328544: {
                if (!"feature-dependencies".equals(string)) break;
                this.runFeatureDependenciesCommand(namespace2, printStream, Feature.PRODUCTION_FEATURES);
                return 0;
            }
            case -745688443: {
                if (!"random-uuid".equals(string)) break;
                printStream.println(Uuid.randomUuid());
                return 0;
            }
            case 3237038: {
                if (!"info".equals(string)) break;
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                return this.infoCommand(printStream, ((KafkaConfig)config.get()).processRoles().nonEmpty(), directories);
            }
            case 1515700441: {
                if (!"version-mapping".equals(string)) break;
                this.runVersionMappingCommand(namespace2, printStream, Feature.PRODUCTION_FEATURES);
                return 0;
            }
        }
        throw new RuntimeException("Unknown command " + command);
    }

    public void runFormatCommand(Namespace namespace, KafkaConfig config, PrintStream printStream) {
        if (config.processRoles().isEmpty()) {
            throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
        }
        Formatter formatter = new Formatter().setPrintStream(printStream).setNodeId(config.nodeId()).setClusterId(namespace.getString("cluster_id")).setUnstableFeatureVersionsEnabled(Predef$.MODULE$.Boolean2boolean(config.unstableFeatureVersionsEnabled())).setIgnoreFormatted(Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("ignore_formatted"))).setControllerListenerName(config.controllerListenerNames().get(0)).setMetadataLogDirectory(config.metadataLogDir());
        Option$.MODULE$.apply(namespace.getString("release_version")).foreach((Function1<String, Formatter> & Serializable)releaseVersion -> formatter.setReleaseVersion(MetadataVersion.fromVersionString(releaseVersion)));
        Option$.MODULE$.apply(namespace.getList("feature")).foreach((Function1<java.util.List, Object> & Serializable)x$1 -> {
            StorageTool$.$anonfun$runFormatCommand$2(formatter, x$1);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply(namespace.getString("initial_controllers")).foreach((Function1<String, Formatter> & Serializable)v -> formatter.setInitialControllers(DynamicVoters.parse(v)));
        Object object = Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("standalone")) ? formatter.setInitialControllers(this.createStandaloneDynamicVoters(config)) : BoxedUnit.UNIT;
        if (Predef$.MODULE$.Boolean2boolean(namespace.getBoolean("no_initial_controllers"))) {
            v1 = formatter.setNoInitialControllersFlag(true);
        } else {
            if (config.processRoles().contains(ProcessRole.ControllerRole) && config.quorumConfig().voters().isEmpty() && formatter.initialVoters().isEmpty()) {
                throw new TerseFailure("Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.");
            }
            v1 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply(namespace.getList("add_scram")).foreach((Function1<java.util.List, Formatter> & Serializable)scramArgs -> formatter.setScramArguments((java.util.List<String>)scramArgs));
        this.configToLogDirectories(config).foreach((Function1<String, Formatter> & Serializable)x$2 -> formatter.addDirectory((String)x$2));
        formatter.run();
    }

    public void runVersionMappingCommand(Namespace namespace, PrintStream printStream, java.util.List<Feature> validFeatures) {
        String releaseVersion = (String)Option$.MODULE$.apply(namespace.getString("release_version")).getOrElse((Function0<String> & Serializable)() -> MetadataVersion.LATEST_PRODUCTION.toString());
        try {
            MetadataVersion metadataVersion = MetadataVersion.fromVersionString(releaseVersion);
            short metadataVersionLevel = metadataVersion.confluentFeatureLevel();
            printStream.print(StringOps$.MODULE$.format$extension("metadata.version=%d (%s)%n", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToShort(metadataVersionLevel), releaseVersion})));
            CollectionConverters$.MODULE$.ListHasAsScala(validFeatures).asScala().foreach((Function1<Feature, Object> & Serializable)feature -> {
                StorageTool$.$anonfun$runVersionMappingCommand$2(metadataVersion, printStream, feature);
                return BoxedUnit.UNIT;
            });
        }
        catch (IllegalArgumentException e) {
            throw new TerseFailure("Unknown release version '" + releaseVersion + "'. Supported versions are: " + MetadataVersion.MINIMUM_VERSION.version() + " to " + MetadataVersion.LATEST_PRODUCTION.version());
        }
    }

    public void runFeatureDependenciesCommand(Namespace namespace, PrintStream printStream, java.util.List<Feature> validFeatures) {
        List featureArgs = (List)Option$.MODULE$.apply(namespace.getList("feature")).map((Function1<java.util.List, List> & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toList()).getOrElse((Function0<List> & Serializable)() -> package$.MODULE$.List().empty());
        featureArgs.foreach((Function1<String, Object> & Serializable)featureArg -> {
            short s;
            Object object;
            String[] stringArray = featureArg.split("=");
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                throw new MatchError(stringArray);
            }
            String featureName = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String versionStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(featureName, versionStr);
            String featureName2 = tuple2._1();
            String versionStr2 = tuple2._2();
            try {
                s = StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(versionStr2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TerseFailure("Invalid version format: " + versionStr2 + " for feature " + featureName2);
            }
            short featureLevel = s;
            String string = featureName2;
            String string2 = "confluent.metadata.version";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                MetadataVersion metadataVersion;
                try {
                    metadataVersion = MetadataVersion.fromConfluentFeatureLevel(featureLevel);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TerseFailure("Unknown confluent.metadata.version " + featureLevel);
                }
                MetadataVersion metadataVersion2 = metadataVersion;
                return printStream.printf("%s=%d (%s) has no dependencies.%n", featureName2, BoxesRunTime.boxToShort(featureLevel), metadataVersion2.version());
            }
            String string3 = featureName2;
            String string4 = "metadata.version";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                MetadataVersion metadataVersion;
                try {
                    metadataVersion = MetadataVersion.fromApacheFeatureLevel(featureLevel);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TerseFailure("Unknown metadata.version " + featureLevel);
                }
                MetadataVersion metadataVersion3 = metadataVersion;
                return printStream.printf("%s=%d (%s) has no dependencies.%n", featureName2, BoxesRunTime.boxToShort(featureLevel), metadataVersion3.version());
            }
            Option option = CollectionConverters$.MODULE$.ListHasAsScala(validFeatures).asScala().find((Function1<Feature, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(StorageTool$.$anonfun$runFeatureDependenciesCommand$4(featureName2, x$5)));
            if (option instanceof Some) {
                FeatureVersion featureVersion;
                Some some = (Some)option;
                Feature feature = (Feature)((Object)((Object)some.value()));
                try {
                    featureVersion = feature.fromFeatureLevel(featureLevel, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TerseFailure("Feature level " + featureLevel + " is not supported for feature " + featureName2);
                }
                FeatureVersion featureVersion2 = featureVersion;
                Map<String, Short> dependencies = CollectionConverters$.MODULE$.MapHasAsScala(featureVersion2.dependencies()).asScala();
                if (dependencies.isEmpty()) {
                    return printStream.printf("%s=%d has no dependencies.%n", featureName2, BoxesRunTime.boxToShort(featureLevel));
                }
                printStream.printf("%s=%d requires:%n", featureName2, BoxesRunTime.boxToShort(featureLevel));
                dependencies.withFilter((Function1<Tuple2<String, Short>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(StorageTool$.$anonfun$runFeatureDependenciesCommand$5(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$6 -> {
                    StorageTool$.$anonfun$runFeatureDependenciesCommand$6(printStream, x$6);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            if (None$.MODULE$.equals(option)) {
                throw new TerseFailure("Unknown feature: " + featureName2);
            }
            throw new MatchError(option);
        });
    }

    public DynamicVoters createStandaloneDynamicVoters(KafkaConfig config) {
        if (!config.processRoles().contains(ProcessRole.ControllerRole)) {
            throw new TerseFailure("You can only use --standalone on a controller.");
        }
        if (config.effectiveAdvertisedControllerListeners().isEmpty()) {
            throw new RuntimeException("No controller listeners found.");
        }
        Endpoint listener = (Endpoint)config.effectiveAdvertisedControllerListeners().head();
        String host = listener.host() == null ? "localhost" : listener.host();
        return DynamicVoters.parse(config.nodeId() + "@" + host + ":" + listener.port() + ":" + Uuid.randomUuid());
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser("kafka-storage", true, "-", "@").description("The Kafka storage tool.");
        Subparsers subparsers = parser.addSubparsers().dest("command");
        this.addInfoParser(subparsers);
        this.addFormatParser(subparsers);
        this.addVersionMappingParser(subparsers);
        this.addFeatureDependenciesParser(subparsers);
        this.addRandomUuidParser(subparsers);
        return parser.parseArgs(args);
    }

    private void addInfoParser(Subparsers subparsers) {
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        this.addConfigArguments(infoParser);
    }

    private void addFormatParser(Subparsers subparsers) {
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        this.addConfigArguments(formatParser);
        formatParser.addArgument("--cluster-id", "-t").action(Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument("--add-scram", "-S").action(Arguments.append()).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A SCRAM_CREDENTIAL to add to the __cluster_metadata log e.g.\n              |'SCRAM-SHA-256=[name=alice,password=alice-secret]'\n              |'SCRAM-SHA-512=[name=alice,iterations=8192,salt=\"N3E=\",saltedpassword=\"YCE=\"]'")));
        formatParser.addArgument("--ignore-formatted", "-g").help("When this option is passed, the format command will skip over already formatted directories rather than failing.").action(Arguments.storeTrue());
        formatParser.addArgument("--release-version", "-r").action(Arguments.store()).help("The release version to use for the initial feature settings. The minimum is " + MetadataVersion.MINIMUM_VERSION + "; the default is " + MetadataVersion.LATEST_PRODUCTION);
        formatParser.addArgument("--feature", "-f").help("The setting to use for a specific feature, in feature=level format. For example: `kraft.version=1`.").action(Arguments.append());
        MutuallyExclusiveGroup reconfigurableQuorumOptions = formatParser.addMutuallyExclusiveGroup();
        reconfigurableQuorumOptions.addArgument("--standalone", "-s").help("Used to initialize a controller as a single-node dynamic quorum.").action(Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument("--no-initial-controllers", "-N").help("Used to initialize a server without a dynamic quorum topology.").action(Arguments.storeTrue());
        reconfigurableQuorumOptions.addArgument("--initial-controllers", "-I").help("Used to initialize a server with a specific dynamic quorum topology. The argument is a comma-separated list of id@hostname:port:directory. The same values must be used to format all nodes. For example:\n0@example.com:8082:JEXY6aqzQY-32P5TStzaFg,1@example.com:8083:MvDxzVmcRsaTz33bUuRU6A,2@example.com:8084:07R5amHmR32VDA6jHkGbTA\n").action(Arguments.store());
    }

    private void addVersionMappingParser(Subparsers subparsers) {
        Subparser versionMappingParser = subparsers.addParser("version-mapping").help("Look up the corresponding features for a given metadata version. Using the command with no --release-version  argument will return the mapping for the latest stable metadata version");
        versionMappingParser.addArgument("--release-version", "-r").action(Arguments.store()).help("The release version to use for the corresponding feature mapping. The minimum is " + MetadataVersion.MINIMUM_VERSION + "; the default is " + MetadataVersion.LATEST_PRODUCTION);
    }

    private void addFeatureDependenciesParser(Subparsers subparsers) {
        Subparser featureDependenciesParser = subparsers.addParser("feature-dependencies").help("Look up dependencies for a given feature version. If the feature is not known or the version not yet defined, an error is thrown. Multiple features can be specified.");
        featureDependenciesParser.addArgument("--feature", "-f").required(true).help("The features and their versions to look up dependencies for, in feature=version format. For example: `metadata.version=5`.").action(Arguments.append());
    }

    private void addRandomUuidParser(Subparsers subparsers) {
        subparsers.addParser("random-uuid").help("Print a random UUID.");
    }

    private void addConfigArguments(Subparser parser) {
        parser.addArgument("--config", "-c").action(Arguments.store()).required(true).help("The Kafka configuration file to use.");
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet<String> directories = new TreeSet<String>(Ordering.String$.MODULE$);
        directories.$plus$plus$eq(CollectionConverters$.MODULE$.ListHasAsScala(config.logDirs()).asScala());
        Option$.MODULE$.apply(config.metadataLogDir()).foreach((Function1<String, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(directories.add(elem)));
        return directories.toSeq();
    }

    public int infoCommand(PrintStream stream, boolean kraftMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef<None$> prevMetadata = ObjectRef.create(None$.MODULE$);
        ((IterableOnceOps)directories.sorted(Ordering.String$.MODULE$)).foreach((Function1<String, Object> & Serializable)directory -> {
            Growable<String> growable;
            block8: {
                Path directoryPath = Paths.get(directory, new String[0]);
                if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        return problems.$plus$eq(directoryPath + " does not exist");
                    }
                    return problems.$plus$eq(directoryPath + " is not a directory");
                }
                foundDirectories.$plus$eq(((Object)directoryPath).toString());
                Path metaPath = directoryPath.resolve("meta.properties");
                if (!Files.exists(metaPath, new LinkOption[0])) {
                    return problems.$plus$eq(directoryPath + " is not formatted.");
                }
                Properties properties = PropertiesUtils.readPropertiesFile(((Object)metaPath).toString());
                try {
                    MetaProperties curMetadata = new MetaProperties.Builder(properties).build();
                    if (((Option)prevMetadata$1.elem).isEmpty()) {
                        prevMetadata$1.elem = new Some<MetaProperties>(curMetadata);
                        growable = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).clusterId().equals(curMetadata.clusterId())) {
                        growable = problems.$plus$eq("Mismatched cluster IDs between storage directories.");
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).nodeId().equals(curMetadata.nodeId())) {
                        growable = problems.$plus$eq("Mismatched node IDs between storage directories.");
                        break block8;
                    }
                    growable = BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    growable = problems.$plus$eq("Error loading " + metaPath + ": " + e.getMessage());
                }
            }
            return growable;
        });
        ((Option)prevMetadata.elem).foreach((Function1<MetaProperties, Object> & Serializable)prev -> {
            if (kraftMode) {
                if (prev.version().equals((Object)MetaPropertiesVersion.V0)) {
                    return problems.$plus$eq("The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version().equals((Object)MetaPropertiesVersion.V1)) {
                return problems.$plus$eq("The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1<String, Object> & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1<MetaProperties, Object> & Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1<String, Object> & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public Tuple2<String, Short> parseNameAndLevel(String input) {
        Tuple2<String, Short> tuple2;
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": equals sign not found.");
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            tuple2 = new Tuple2<String, Short>(name, Predef$.MODULE$.short2Short(StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(levelString))));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't parse feature=level string " + input + ": unable to parse " + levelString + " as a short.");
        }
        return tuple2;
    }

    public scala.collection.immutable.Map<String, Short> featureNamesAndLevels(java.util.List<String> features) {
        ArrayBuffer scalaFeatures = new ArrayBuffer();
        features.forEach(x$7 -> scalaFeatures.$plus$eq(x$7));
        return ((IterableOnceOps)scalaFeatures.map((Function1<String, Tuple2> & Serializable)feature -> {
            Tuple2<String, Short> nameAndLevel = MODULE$.parseNameAndLevel((String)feature);
            return new Tuple2<String, Short>(nameAndLevel._1(), nameAndLevel._2());
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$runFormatCommand$2(Formatter formatter$1, java.util.List x$1) {
        MODULE$.featureNamesAndLevels(x$1).foreach((Function1<Tuple2, Formatter> & Serializable)kv -> formatter$1.setFeatureLevel((String)kv._1(), (Short)kv._2()));
    }

    public static final /* synthetic */ void $anonfun$runVersionMappingCommand$2(MetadataVersion metadataVersion$1, PrintStream printStream$1, Feature feature) {
        short featureLevel = feature.defaultLevel(metadataVersion$1);
        printStream$1.print(StringOps$.MODULE$.format$extension("%s=%d%n", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{feature.featureName(), BoxesRunTime.boxToShort(featureLevel)})));
    }

    public static final /* synthetic */ boolean $anonfun$runFeatureDependenciesCommand$4(String featureName$1, Feature x$5) {
        String string = x$5.featureName();
        String string2 = featureName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runFeatureDependenciesCommand$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$runFeatureDependenciesCommand$6(PrintStream printStream$2, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            String depFeature = (String)tuple2._1();
            Short depLevel = (Short)tuple2._2();
            String string = depFeature;
            String string2 = "confluent.metadata.version";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                MetadataVersion metadataVersion = MetadataVersion.fromConfluentFeatureLevel(Predef$.MODULE$.Short2short(depLevel));
                printStream$2.println("    " + depFeature + "=" + depLevel + " (" + metadataVersion.version() + ")");
                return;
            }
            String string3 = depFeature;
            String string4 = "metadata.version";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                MetadataVersion metadataVersion = MetadataVersion.fromApacheFeatureLevel(Predef$.MODULE$.Short2short(depLevel));
                printStream$2.println("    " + depFeature + "=" + depLevel + " (" + metadataVersion.version() + ")");
                return;
            }
            printStream$2.println("    " + depFeature + "=" + depLevel);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, MetaProperties prev) {
        TreeMap sortedOutput = new TreeMap();
        prev.toProperties().entrySet().forEach(e -> sortedOutput.put(e.getKey().toString(), e.getValue().toString()));
        stream$1.println("Found metadata: " + sortedOutput);
        stream$1.println("");
    }

    private StorageTool$() {
    }
}

