/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.Serializable;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.reflect.ClassTag;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Json$ {
    public static final Json$ MODULE$ = new Json$();
    private static final ObjectMapper mapper = new ObjectMapper();

    private ObjectMapper mapper() {
        return mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        return this.tryParseFull(input).toOption();
    }

    public <T> Either<JsonProcessingException, T> parseStringAs(String input, ClassTag<T> tag) {
        Either either;
        try {
            either = new Right(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            either = new Left(e);
        }
        return either;
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        Option option;
        try {
            option = Option$.MODULE$.apply(this.mapper().readTree(input)).map((Function1<JsonNode, JsonValue> & Serializable)x$1 -> JsonValue$.MODULE$.apply((JsonNode)x$1));
        }
        catch (JsonProcessingException jsonProcessingException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        Either either;
        try {
            either = new Right(this.mapper().readTree(input)).map((Function1<JsonNode, JsonValue> & Serializable)x$2 -> JsonValue$.MODULE$.apply((JsonNode)x$2));
        }
        catch (JsonProcessingException e) {
            either = new Left<JsonProcessingException, JsonValue>(e);
        }
        return either;
    }

    public <T> Either<JsonProcessingException, T> parseBytesAs(byte[] input, ClassTag<T> tag) {
        Either either;
        try {
            either = new Right(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            either = new Left(e);
        }
        return either;
    }

    public Either<JsonProcessingException, JsonValue> tryParseFull(String input) {
        Either either;
        if (input == null || input.isEmpty()) {
            return new Left<JsonProcessingException, JsonValue>(new JsonParseException(MissingNode.getInstance().traverse(), "The input string shouldn't be empty"));
        }
        try {
            either = new Right(this.mapper().readTree(input)).map((Function1<JsonNode, JsonValue> & Serializable)x$3 -> JsonValue$.MODULE$.apply((JsonNode)x$3));
        }
        catch (JsonProcessingException e) {
            either = new Left<JsonProcessingException, JsonValue>(e);
        }
        return either;
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
    }
}

