/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;

public class MultiTenantApis {
    private static final Set<ApiKeys> INTERNAL_ONLY_APIS = Set.of(ApiKeys.RESOLVE_OFFSET_RANGE, ApiKeys.LIST_TRANSACTIONS);
    private final boolean sbcApisEnabled;

    public MultiTenantApis(boolean areSbcApisEnabled) {
        this.sbcApisEnabled = areSbcApisEnabled;
    }

    public boolean isApiAllowed(ApiKeys api, short version, MultiTenantPrincipal principal) {
        if (!MultiTenantApis.isApiAllowed(api, principal)) {
            return false;
        }
        switch (api) {
            case PRODUCE: 
            case FETCH: 
            case LIST_OFFSETS: 
            case METADATA: 
            case OFFSET_COMMIT: 
            case OFFSET_FETCH: 
            case FIND_COORDINATOR: 
            case JOIN_GROUP: 
            case HEARTBEAT: 
            case LEAVE_GROUP: 
            case SYNC_GROUP: 
            case DESCRIBE_GROUPS: 
            case LIST_GROUPS: 
            case DELETE_GROUPS: 
            case SASL_HANDSHAKE: 
            case API_VERSIONS: 
            case CREATE_TOPICS: 
            case DELETE_TOPICS: 
            case DELETE_RECORDS: 
            case INIT_PRODUCER_ID: 
            case ADD_OFFSETS_TO_TXN: 
            case END_TXN: 
            case TXN_OFFSET_COMMIT: 
            case LIST_TRANSACTIONS: 
            case DESCRIBE_CONFIGS: 
            case ALTER_CONFIGS: 
            case INCREMENTAL_ALTER_CONFIGS: 
            case SASL_AUTHENTICATE: 
            case CREATE_ACLS: 
            case DESCRIBE_ACLS: 
            case DELETE_ACLS: 
            case CREATE_PARTITIONS: 
            case OFFSET_FOR_LEADER_EPOCH: 
            case REPLICA_STATUS: 
            case OFFSET_DELETE: 
            case LIST_CLUSTER_LINKS: 
            case LIST_MIRRORS: 
            case DESCRIBE_MIRRORS: 
            case INITIATE_REVERSE_CONNECTIONS: 
            case REVERSE_CONNECTION: 
            case DESCRIBE_CLUSTER: 
            case CREATE_CLUSTER_LINKS: 
            case DELETE_CLUSTER_LINKS: 
            case ALTER_MIRRORS: 
            case DESCRIBE_CLUSTER_LINKS: 
            case CONSUMER_GROUP_DESCRIBE: 
            case CONSUMER_GROUP_HEARTBEAT: 
            case GET_TELEMETRY_SUBSCRIPTIONS: 
            case PUSH_TELEMETRY: 
            case SHARE_FETCH: 
            case SHARE_ACKNOWLEDGE: 
            case SHARE_GROUP_HEARTBEAT: 
            case SHARE_GROUP_DESCRIBE: 
            case RESOLVE_OFFSET_RANGE: 
            case DESCRIBE_SWITCHOVER_STATUS: 
            case DESCRIBE_SHARE_GROUP_OFFSETS: 
            case ALTER_SHARE_GROUP_OFFSETS: 
            case DELETE_SHARE_GROUP_OFFSETS: 
            case STREAMS_GROUP_HEARTBEAT: 
            case STREAMS_GROUP_DESCRIBE: {
                return true;
            }
            case CONTROLLED_SHUTDOWN: 
            case LEADER_AND_ISR: 
            case UPDATE_METADATA: 
            case STOP_REPLICA: 
            case WRITE_TXN_MARKERS: 
            case ALTER_REPLICA_LOG_DIRS: 
            case DESCRIBE_LOG_DIRS: 
            case CREATE_DELEGATION_TOKEN: 
            case DESCRIBE_DELEGATION_TOKEN: 
            case RENEW_DELEGATION_TOKEN: 
            case EXPIRE_DELEGATION_TOKEN: 
            case ELECT_LEADERS: 
            case LIST_PARTITION_REASSIGNMENTS: 
            case ALTER_PARTITION_REASSIGNMENTS: 
            case DESCRIBE_CLIENT_QUOTAS: 
            case ALTER_CLIENT_QUOTAS: 
            case INITIATE_SHUTDOWN: 
            case ALTER_USER_SCRAM_CREDENTIALS: 
            case DESCRIBE_USER_SCRAM_CREDENTIALS: 
            case ALTER_PARTITION: 
            case UPDATE_FEATURES: 
            case DESCRIBE_PRODUCERS: 
            case ALTER_BROKER_HEALTH: 
            case DESCRIBE_BROKER_HEALTH: 
            case DESCRIBE_TRANSACTIONS: 
            case ALLOCATE_PRODUCER_IDS: 
            case REPORT_QUOTA_CONSUMPTION: 
            case PUBLISH_QUOTA_TARGET: 
            case CREATE_CELL: 
            case ALTER_CELL: 
            case DRAIN_CELL: 
            case DELETE_CELL: 
            case ASSIGN_BROKERS_TO_CELL: 
            case UN_ASSIGN_BROKERS_FROM_CELL: 
            case ASSIGN_TENANTS_TO_CELL: 
            case DELETE_TENANTS: 
            case DESCRIBE_CELLS: 
            case DESCRIBE_TENANTS: 
            case DESCRIBE_CELL_LOAD: 
            case ALTER_CELL_MIGRATION: 
            case DESCRIBE_CELL_MIGRATION: 
            case DESCRIBE_NETWORK: 
            case ENVELOPE: 
            case APPEND_RECORDS: 
            case DESCRIBE_TOPIC_PARTITIONS: 
            case LIST_CONFIG_RESOURCES: 
            case DESCRIBE_QUORUM: 
            case UNREGISTER_BROKER: 
            case WRITE_SHARE_GROUP_STATE: 
            case DELETE_SHARE_GROUP_STATE: 
            case INITIALIZE_SHARE_GROUP_STATE: 
            case READ_SHARE_GROUP_STATE_SUMMARY: 
            case READ_SHARE_GROUP_STATE: 
            case ADD_RAFT_VOTER: 
            case REMOVE_RAFT_VOTER: 
            case REPORT_CLUSTER_LINK_STATUS: {
                return false;
            }
            case REMOVE_BROKERS: 
            case DESCRIBE_BROKER_REMOVALS: 
            case DESCRIBE_BROKER_ADDITIONS: 
            case DESCRIBE_BALANCER_STATUS: 
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: 
            case ALTER_BROKER_REPLICA_EXCLUSIONS: 
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: 
            case TRIGGER_EVEN_CLUSTER_LOAD: 
            case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: {
                return this.sbcApisEnabled;
            }
            case ADD_PARTITIONS_TO_TXN: {
                return version < 4;
            }
        }
        throw new IllegalArgumentException("Unexpected api key " + String.valueOf(api));
    }

    private static boolean isApiAllowed(ApiKeys api, MultiTenantPrincipal principal) {
        if (INTERNAL_ONLY_APIS.contains(api)) {
            CallingResourceIdentityType applicationIdentity = CallingResourceIdentityType.fromPrincipal((MultiTenantPrincipal)principal);
            return applicationIdentity != CallingResourceIdentityType.DEFAULT;
        }
        return true;
    }
}

