/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TrafficNetworkIdValidationMode {
    NONE{

        @Override
        public boolean trafficAllowed(Optional<String> networkId, TrafficNetworkIdRoutes networkIdRoutes) {
            return true;
        }
    }
    ,
    STRICT{

        @Override
        public boolean trafficAllowed(Optional<String> networkId, TrafficNetworkIdRoutes networkIdRoutes) {
            return networkId.isPresent() && networkIdRoutes.allows(networkId.get());
        }
    };

    public static final String TRAFFIC_NETWORK_ID_VALIDATION_MODE_KEY = "traffic_network_id_validation_mode";
    private static final Logger log;

    public static TrafficNetworkIdValidationMode fromString(String text) {
        for (TrafficNetworkIdValidationMode mode : TrafficNetworkIdValidationMode.values()) {
            if (!mode.name().equalsIgnoreCase(text)) continue;
            return mode;
        }
        log.debug("Unknown NetworkID validation mode: {}. Set it to none", (Object)text);
        return NONE;
    }

    public static TrafficNetworkIdValidationMode fromConfigs(CCloudTrafficType trafficType, Supplier<String> jaasConfigEntryOption) {
        TrafficNetworkIdValidationMode networkIdValidationMode;
        if (trafficType != null && trafficType.shouldValidateTraffic()) {
            log.debug("Forcing networkId validation to STRICT as Proxy protocol2 header indicates traffic should be validated for trafficType={}", (Object)trafficType);
            networkIdValidationMode = STRICT;
        } else {
            networkIdValidationMode = TrafficNetworkIdValidationMode.fromString(jaasConfigEntryOption.get());
        }
        return networkIdValidationMode;
    }

    public abstract boolean trafficAllowed(Optional<String> var1, TrafficNetworkIdRoutes var2);

    static {
        log = LoggerFactory.getLogger(TrafficNetworkIdValidationMode.class);
    }
}

