/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValue;
import io.confluent.security.auth.store.data.IdentityProviderKey;
import io.confluent.security.auth.store.data.IdentityProviderValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.auth.store.data.TrustCacheUtils;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.jose4j.jwk.JsonWebKeySet;

public class MockTrustCache
implements TrustCache,
KeyValueStore<AuthKey, AuthValue> {
    private final Map<String, JsonWebKeySet> jsonWebKeys;
    private final Map<String, IdentityPool> identityPools = new ConcurrentHashMap<String, IdentityPool>();
    private final Map<String, Set<String>> orgToProvidersMapping;
    private final Map<String, IdentityProvider> identityProviders;
    private final Map<String, Set<String>> providerToPoolsMapping;

    public MockTrustCache() {
        this.jsonWebKeys = new ConcurrentHashMap<String, JsonWebKeySet>();
        this.identityProviders = new ConcurrentHashMap<String, IdentityProvider>();
        this.orgToProvidersMapping = new ConcurrentHashMap<String, Set<String>>();
        this.providerToPoolsMapping = new ConcurrentHashMap<String, Set<String>>();
    }

    public AuthValue get(AuthKey key) {
        switch (key.entryType()) {
            case IDENTITY_PROVIDER: {
                return TrustCacheUtils.getIdentityProvider(this.identityProviders, (IdentityProviderKey)((IdentityProviderKey)key));
            }
            case JWT_ISSUER: {
                return TrustCacheUtils.getJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)((JwtIssuerKey)key));
            }
            case IDENTITY_POOL: {
                return TrustCacheUtils.getIdentityPool(this.identityPools, (IdentityPoolKey)((IdentityPoolKey)key));
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public AuthValue put(AuthKey key, AuthValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (key.entryType() != value.entryType()) {
            throw new CorruptRecordException("Invalid record with key=" + String.valueOf(key) + ", value=" + String.valueOf(value));
        }
        switch (key.entryType()) {
            case IDENTITY_PROVIDER: {
                return TrustCacheUtils.updateIdentityProvider(this.identityProviders, this.orgToProvidersMapping, (IdentityProviderKey)((IdentityProviderKey)key), (IdentityProviderValue)((IdentityProviderValue)value));
            }
            case JWT_ISSUER: {
                return TrustCacheUtils.updateJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)((JwtIssuerKey)key), (JwtIssuerValue)((JwtIssuerValue)value));
            }
            case IDENTITY_POOL: {
                return TrustCacheUtils.updateIdentityPool(this.identityPools, this.providerToPoolsMapping, (IdentityPoolKey)((IdentityPoolKey)key), (IdentityPoolValue)((IdentityPoolValue)value));
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public AuthValue remove(AuthKey key) {
        switch (key.entryType()) {
            case IDENTITY_PROVIDER: {
                return TrustCacheUtils.removeIdentityProvider(this.identityProviders, this.orgToProvidersMapping, (IdentityProviderKey)((IdentityProviderKey)key));
            }
            case JWT_ISSUER: {
                return TrustCacheUtils.removeJwtIssuer(this.jsonWebKeys, (JwtIssuerKey)((JwtIssuerKey)key));
            }
            case IDENTITY_POOL: {
                return TrustCacheUtils.removeIdentityPool(this.identityPools, this.providerToPoolsMapping, (IdentityPoolKey)((IdentityPoolKey)key));
            }
        }
        throw new IllegalArgumentException("Unknown key type " + String.valueOf(key.entryType()));
    }

    public Map<? extends AuthKey, ? extends AuthValue> map(String entryType) {
        return null;
    }

    public void fail(int partition, String errorMessage) {
    }

    public MetadataStoreStatus status(int partition) {
        return null;
    }

    public Map<String, JsonWebKeySet> jsonWebKeySets() {
        return Collections.unmodifiableMap(this.jsonWebKeys);
    }

    public JsonWebKeySet jsonWebKeySet(String jwtIssuer) {
        return this.jsonWebKeys.get(jwtIssuer);
    }

    public IdentityPool identityPool(String poolId) {
        return this.identityPools.get(poolId);
    }

    public Map<String, IdentityPool> identityPools() {
        return Collections.unmodifiableMap(this.identityPools);
    }

    public RefreshTokenInfo refreshTokenInfo(String refreshTokenKey) {
        return null;
    }

    public Collection<IdentityPool> findIdentityPools(String providerId) {
        return TrustCacheUtils.findIdentityPools(this.identityPools, this.providerToPoolsMapping, (String)providerId);
    }

    public Collection<String> findIdentityProviderIds(String organizationId) {
        return TrustCacheUtils.findIdentityProviderIds(this.orgToProvidersMapping, (String)organizationId);
    }

    public IdentityProvider identityProvider(String providerid) {
        return this.identityProviders.get(providerid);
    }
}

