/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.PolicyViolationException;

public abstract class AbstractPolicyConfig
extends AbstractConfig {
    protected AbstractPolicyConfig(ConfigDef configDef, Map<String, ?> clientConfigs) {
        super(configDef, clientConfigs);
    }

    protected final void checkPolicyMax(Map<String, String> configs, String maxPolicyConfigProperty, String configProperty, long defaultValue) {
        long policyMax;
        String input;
        long configuredValue;
        if (configs.containsKey(configProperty) && (configuredValue = (input = configs.get(configProperty)) == null || input.isEmpty() ? defaultValue : Long.parseLong(input)) > (policyMax = this.parseLong(maxPolicyConfigProperty))) {
            throw new PolicyViolationException(String.format("Config property '%s' with value '%d' is larger than the maximum allowed value of of %d.", configProperty, configuredValue, policyMax));
        }
    }

    protected final void checkPolicyMin(Map<String, String> configs, String minPolicyConfigProperty, String configProperty, long defaultValue) {
        long policyMin;
        String input;
        long configuredValue;
        if (configs.containsKey(configProperty) && (configuredValue = (input = configs.get(configProperty)) == null || input.isEmpty() ? defaultValue : Long.parseLong(input)) < (policyMin = this.parseLong(minPolicyConfigProperty))) {
            throw new PolicyViolationException(String.format("Config property '%s' with value '%d' is lower than the minimum allowed value of %d.", configProperty, configuredValue, policyMin));
        }
    }

    protected final long parseLong(String policyConfigProperty) {
        return ((Number)this.get(policyConfigProperty)).longValue();
    }

    protected final List<String> parseList(Map<String, String> configs, String configName) {
        String configValue = configs.get(configName);
        if (configValue == null) {
            return null;
        }
        try {
            return (List)ConfigDef.parseType((String)configName, (Object)configValue, (ConfigDef.Type)ConfigDef.Type.LIST);
        }
        catch (ConfigException e) {
            throw new PolicyViolationException(e.getMessage());
        }
    }
}

