/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpEdPrivateKey;
import com.amazon.corretto.crypto.provider.EvpEdPublicKey;
import com.amazon.corretto.crypto.provider.Loader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

class EdGen
extends KeyPairGeneratorSpi {
    private final AmazonCorrettoCryptoProvider provider_;
    private final KeyFactory kf;

    private static native long generateEvpEdKey();

    EdGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        try {
            this.kf = KeyFactory.getInstance("EdDSA", "SunEC");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Error setting up KeyPairGenerator", generalSecurityException);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyPair generateKeyPair() {
        EvpEdPrivateKey evpEdPrivateKey = new EvpEdPrivateKey(EdGen.generateEvpEdKey());
        EvpEdPublicKey evpEdPublicKey = evpEdPrivateKey.getPublicKey();
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(evpEdPrivateKey.getEncoded());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(evpEdPublicKey.getEncoded());
            PrivateKey privateKey = this.kf.generatePrivate(pKCS8EncodedKeySpec);
            PublicKey publicKey = this.kf.generatePublic(x509EncodedKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Error generating key pair", generalSecurityException);
        }
    }
}

