/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.SelfTestResult;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class EvpHmac
extends MacSpi
implements Cloneable {
    private static long DO_NOT_INIT = -1L;
    private static long DO_NOT_REKEY = -2L;
    private static final int CONTEXT_SIZE = EvpHmac.getContextSize();
    private HmacState state;
    private InputBuffer<byte[], Void, RuntimeException> buffer;

    private static native int getContextSize();

    private static native void updateCtxArray(byte[] var0, byte[] var1, long var2, byte[] var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedUpdateCtxArray(byte[] byArray, byte[] byArray2, long l, byte[] byArray3, int n, int n2) {
        byte[] byArray4 = byArray;
        synchronized (byArray) {
            EvpHmac.updateCtxArray(byArray, byArray2, l, byArray3, n, n2);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    private static native void doFinal(byte[] var0, byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedDoFinal(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray;
        synchronized (byArray) {
            EvpHmac.doFinal(byArray, byArray2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static native void fastHmac(byte[] var0, byte[] var1, long var2, byte[] var4, int var5, int var6, byte[] var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedFastHmac(byte[] byArray, byte[] byArray2, long l, byte[] byArray3, int n, int n2, byte[] byArray4) {
        byte[] byArray5 = byArray;
        synchronized (byArray) {
            EvpHmac.fastHmac(byArray, byArray2, l, byArray3, n, n2, byArray4);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return;
        }
    }

    EvpHmac(long l, int n) {
        if (l == DO_NOT_INIT || l == DO_NOT_REKEY) {
            throw new AssertionError((Object)("Unexpected value for evpMd conflicting with reserved negative value: " + l));
        }
        this.state = new HmacState(l, n);
        this.buffer = new InputBuffer(1024);
        this.configureLambdas();
    }

    private void configureLambdas() {
        this.buffer.withInitialUpdater((byArray, n, n2) -> {
            this.assertInitialized();
            byte[] byArray2 = this.state.encoded_key;
            long l = DO_NOT_REKEY;
            if (this.state.needsRekey) {
                l = this.state.evpMd;
            }
            EvpHmac.synchronizedUpdateCtxArray(this.state.context, byArray2, l, byArray, n, n2);
            this.state.needsRekey = false;
            return null;
        }).withUpdater((void_, byArray, n, n2) -> {
            this.assertInitialized();
            EvpHmac.synchronizedUpdateCtxArray(this.state.context, null, DO_NOT_INIT, byArray, n, n2);
        }).withDoFinal(void_ -> {
            this.assertInitialized();
            byte[] byArray = new byte[this.state.digestLength];
            EvpHmac.synchronizedDoFinal(this.state.context, byArray);
            return byArray;
        }).withSinglePass((byArray, n, n2) -> {
            this.assertInitialized();
            byte[] byArray2 = new byte[this.state.digestLength];
            byte[] byArray3 = this.state.encoded_key;
            long l = DO_NOT_REKEY;
            if (this.state.needsRekey) {
                l = this.state.evpMd;
            }
            EvpHmac.synchronizedFastHmac(this.state.context, byArray3, l, byArray, n, n2, byArray2);
            this.state.needsRekey = false;
            return byArray2;
        });
    }

    @Override
    protected int engineGetMacLength() {
        return this.state.digestLength;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Params must be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Hmac uses expects a SecretKey");
        }
        this.state.setKey((SecretKey)key);
        this.engineReset();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.buffer.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.buffer.doFinal();
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    private void assertInitialized() {
        if (this.state.key == null) {
            throw new IllegalStateException("Mac not initialized");
        }
    }

    @Override
    public EvpHmac clone() throws CloneNotSupportedException {
        EvpHmac evpHmac = (EvpHmac)super.clone();
        evpHmac.state = evpHmac.state.clone();
        evpHmac.buffer = evpHmac.buffer.clone();
        evpHmac.configureLambdas();
        return evpHmac;
    }

    private static SelfTestResult runSelfTest(String string, Class<? extends MacSpi> clazz) {
        TestMacProvider testMacProvider = new TestMacProvider(string, clazz);
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap.put("HmacMD5", "md5");
        hashMap2.put("HmacMD5", 0);
        hashMap.put("HmacSHA1", "sha1");
        hashMap2.put("HmacSHA1", 0);
        hashMap.put("HmacSHA256", "sha2");
        hashMap2.put("HmacSHA256", 0);
        hashMap.put("HmacSHA384", "sha2");
        hashMap2.put("HmacSHA384", 1);
        hashMap.put("HmacSHA512", "sha2");
        hashMap2.put("HmacSHA512", 2);
        Scanner scanner = new Scanner(Loader.getTestData("hmac.txt"), StandardCharsets.US_ASCII.name());
        try {
            Object object;
            Mac mac = Mac.getInstance(string, testMacProvider);
            while (scanner.hasNext()) {
                ++n;
                object = scanner.next();
                SecretKeySpec secretKeySpec = new SecretKeySpec(Utils.decodeHex(scanner.next()), string);
                byte[] byArray = Utils.decodeHex(scanner.next());
                String[] stringArray = scanner.nextLine().trim().split("\\s+");
                if (!((String)object).equals(hashMap.get(string))) continue;
                Utils.testMac(mac, secretKeySpec, byArray, Utils.decodeHex(stringArray[(Integer)hashMap2.get(string)]));
            }
            object = new SelfTestResult(SelfTestStatus.PASSED);
            scanner.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                Logger.getLogger("AmazonCorrettoCryptoProvider").severe(string + " failed self-test " + n);
                return new SelfTestResult(throwable3);
            }
        }
    }

    static /* synthetic */ int access$400() {
        return CONTEXT_SIZE;
    }

    private static final class HmacState
    implements Cloneable {
        private SecretKey key;
        private final long evpMd;
        private final int digestLength;
        private byte[] context = new byte[EvpHmac.access$400()];
        private byte[] encoded_key;
        boolean needsRekey = true;

        private HmacState(long l, int n) {
            this.evpMd = l;
            this.digestLength = n;
        }

        private void setKey(SecretKey secretKey) throws InvalidKeyException {
            if (Objects.equals(this.key, secretKey)) {
                return;
            }
            if (!"RAW".equalsIgnoreCase(secretKey.getFormat())) {
                throw new InvalidKeyException("Key must support RAW encoding");
            }
            byte[] byArray = secretKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key encoding must not be null");
            }
            this.encoded_key = byArray;
            this.key = secretKey;
            this.needsRekey = true;
        }

        public HmacState clone() {
            try {
                HmacState hmacState = (HmacState)super.clone();
                hmacState.context = (byte[])hmacState.context.clone();
                return hmacState;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }
    }

    private static class TestMacProvider
    extends Provider {
        private final String macName;
        private final Class<? extends MacSpi> spi;

        protected TestMacProvider(String string, Class<? extends MacSpi> clazz) {
            super("test provider", 0.0, "internal self-test provider for " + string);
            this.macName = string;
            this.spi = clazz;
        }

        @Override
        public synchronized Provider.Service getService(String string, String string2) {
            if (string.equals("Mac") && string2.equals(this.macName)) {
                return new Provider.Service(this, string, string2, this.spi.getName(), Collections.emptyList(), Collections.emptyMap()){

                    @Override
                    public Object newInstance(Object object) {
                        try {
                            return spi.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)exception);
                        }
                    }
                };
            }
            return super.getService(string, string2);
        }
    }

    static class SHA512
    extends EvpHmac {
        private static final long evpMd = Utils.getEvpMdFromName("sha512");
        private static final int digestLength = Utils.getDigestLength(evpMd);
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("HmacSHA512", SHA512::runSelfTest);

        public SHA512() {
            super(evpMd, digestLength);
        }

        public static SelfTestResult runSelfTest() {
            return EvpHmac.runSelfTest("HmacSHA512", SHA512.class);
        }
    }

    static class SHA384
    extends EvpHmac {
        private static final long evpMd = Utils.getEvpMdFromName("sha384");
        private static final int digestLength = Utils.getDigestLength(evpMd);
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("HmacSHA384", SHA384::runSelfTest);

        public SHA384() {
            super(evpMd, digestLength);
        }

        public static SelfTestResult runSelfTest() {
            return EvpHmac.runSelfTest("HmacSHA384", SHA384.class);
        }
    }

    static class SHA256
    extends EvpHmac {
        private static final long evpMd = Utils.getEvpMdFromName("sha256");
        private static final int digestLength = Utils.getDigestLength(evpMd);
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("HmacSHA256", SHA256::runSelfTest);

        public SHA256() {
            super(evpMd, digestLength);
        }

        public static SelfTestResult runSelfTest() {
            return EvpHmac.runSelfTest("HmacSHA256", SHA256.class);
        }
    }

    static class SHA1
    extends EvpHmac {
        private static final long evpMd = Utils.getEvpMdFromName("sha1");
        private static final int digestLength = Utils.getDigestLength(evpMd);
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("HmacSHA1", SHA1::runSelfTest);

        public SHA1() {
            super(evpMd, digestLength);
        }

        public static SelfTestResult runSelfTest() {
            return EvpHmac.runSelfTest("HmacSHA1", SHA1.class);
        }
    }

    static class MD5
    extends EvpHmac {
        private static final long evpMd = Utils.getEvpMdFromName("md5");
        private static final int digestLength = Utils.getDigestLength(evpMd);
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("HmacMD5", MD5::runSelfTest);

        public MD5() {
            super(evpMd, digestLength);
        }

        public static SelfTestResult runSelfTest() {
            return EvpHmac.runSelfTest("HmacMD5", MD5.class);
        }
    }
}

