/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.HkdfSpec;
import com.amazon.corretto.crypto.provider.KdfSpi;
import com.amazon.corretto.crypto.provider.Utils;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class HkdfSecretKeyFactorySpi
extends KdfSpi {
    private final int digestCode;
    private final int digestLength;
    static final Map<String, HkdfSecretKeyFactorySpi> INSTANCES = HkdfSecretKeyFactorySpi.getInstances();
    private static final String HKDF = "Hkdf";
    private static final String WITH = "With";
    static final String HKDF_WITH_SHA1 = "HkdfWithHmacSHA1";
    static final String HKDF_WITH_SHA256 = "HkdfWithHmacSHA256";
    static final String HKDF_WITH_SHA384 = "HkdfWithHmacSHA384";
    static final String HKDF_WITH_SHA512 = "HkdfWithHmacSHA512";

    private HkdfSecretKeyFactorySpi(int n, int n2) {
        this.digestCode = n;
        this.digestLength = n2;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] byArray;
        if (!(keySpec instanceof HkdfSpec)) {
            throw new InvalidKeySpecException("KeySpec must be an instance of HkdfSpec");
        }
        HkdfSpec hkdfSpec = (HkdfSpec)keySpec;
        switch (hkdfSpec.mode) {
            case 1: {
                this.checkExpandLength(hkdfSpec.desiredLength);
                byArray = new byte[hkdfSpec.desiredLength];
                HkdfSecretKeyFactorySpi.hkdf(byArray, byArray.length, this.digestCode, hkdfSpec.secretOrPrk, hkdfSpec.secretOrPrk.length, hkdfSpec.salt, hkdfSpec.salt.length, hkdfSpec.info, hkdfSpec.info.length);
                break;
            }
            case 2: {
                byArray = new byte[this.digestLength];
                HkdfSecretKeyFactorySpi.hkdfExtract(byArray, byArray.length, this.digestCode, hkdfSpec.secretOrPrk, hkdfSpec.secretOrPrk.length, hkdfSpec.salt, hkdfSpec.salt.length);
                break;
            }
            case 3: {
                this.checkExpandLength(hkdfSpec.desiredLength);
                byArray = new byte[hkdfSpec.desiredLength];
                HkdfSecretKeyFactorySpi.hkdfExpand(byArray, byArray.length, this.digestCode, hkdfSpec.secretOrPrk, hkdfSpec.secretOrPrk.length, hkdfSpec.info, hkdfSpec.info.length);
                break;
            }
            default: {
                throw new AssertionError((Object)"This should not be reachable, since the constructor of HkdfSpec ensures the value is one of the above choices.");
            }
        }
        return new SecretKeySpec(byArray, hkdfSpec.algorithmName);
    }

    private void checkExpandLength(long l) {
        long l2 = (long)this.digestLength * 255L;
        if (l >= l2) {
            throw new IllegalArgumentException("Desired output length is too large.");
        }
    }

    private static native void hkdf(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    private static native void hkdfExtract(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void hkdfExpand(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static Map<String, HkdfSecretKeyFactorySpi> getInstances() {
        HashMap<String, HkdfSecretKeyFactorySpi> hashMap = new HashMap<String, HkdfSecretKeyFactorySpi>();
        hashMap.put(HkdfSecretKeyFactorySpi.getSpiFactoryForAlgName(HKDF_WITH_SHA1), new HkdfSecretKeyFactorySpi(1, Utils.getDigestLength("sha1")));
        hashMap.put(HkdfSecretKeyFactorySpi.getSpiFactoryForAlgName(HKDF_WITH_SHA256), new HkdfSecretKeyFactorySpi(2, Utils.getDigestLength("sha256")));
        hashMap.put(HkdfSecretKeyFactorySpi.getSpiFactoryForAlgName(HKDF_WITH_SHA384), new HkdfSecretKeyFactorySpi(3, Utils.getDigestLength("sha384")));
        hashMap.put(HkdfSecretKeyFactorySpi.getSpiFactoryForAlgName(HKDF_WITH_SHA512), new HkdfSecretKeyFactorySpi(4, Utils.getDigestLength("sha512")));
        return Collections.unmodifiableMap(hashMap);
    }

    static String getSpiFactoryForAlgName(String string) {
        return string.toUpperCase();
    }
}

