/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpMlDsaPrivateKey;
import com.amazon.corretto.crypto.provider.EvpMlDsaPublicKey;
import com.amazon.corretto.crypto.provider.Loader;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

class MlDsaGen
extends KeyPairGeneratorSpi {
    private final AmazonCorrettoCryptoProvider provider_;
    private int level_ = -1;

    private static native long generateEvpMlDsaKey(int var0);

    private MlDsaGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, Integer n) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.level_ = n;
    }

    MlDsaGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        this(amazonCorrettoCryptoProvider, null);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.level_ < 0) {
            throw new IllegalStateException("Key type not set");
        }
        long l = MlDsaGen.generateEvpMlDsaKey(this.level_);
        EvpMlDsaPrivateKey evpMlDsaPrivateKey = new EvpMlDsaPrivateKey(l);
        EvpMlDsaPublicKey evpMlDsaPublicKey = evpMlDsaPrivateKey.getPublicKey();
        return new KeyPair(evpMlDsaPublicKey, evpMlDsaPrivateKey);
    }

    public static final class MlDsaGen87
    extends MlDsaGen {
        public MlDsaGen87(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, 5);
        }
    }

    public static final class MlDsaGen65
    extends MlDsaGen {
        public MlDsaGen65(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, 3);
        }
    }

    public static final class MlDsaGen44
    extends MlDsaGen {
        public MlDsaGen44(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, 2);
        }
    }
}

