/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.LibCryptoRng;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class SecretKeyGenerator
extends KeyGeneratorSpi {
    private final Supplier<SecureRandom> defaultSecureRandomSupplier;
    private final SecretKeyProperties secretKeyProperties;
    private Optional<SecureRandom> secureRandom;
    private int keySize;

    SecretKeyGenerator(Supplier<SecureRandom> supplier, SecretKeyProperties secretKeyProperties) {
        this.defaultSecureRandomSupplier = supplier;
        this.secretKeyProperties = secretKeyProperties;
        this.secureRandom = Optional.empty();
        this.keySize = secretKeyProperties.defaultKeySize();
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.secureRandom = Optional.ofNullable(secureRandom);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("SecretKeyGenerator does not support initialization with AlgorithmParameterSpec.");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        this.secretKeyProperties.checkKeySizeIsValid(n);
        this.keySize = n;
        this.secureRandom = Optional.ofNullable(secureRandom);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        byte[] byArray = new byte[this.keySize / 8];
        SecureRandom secureRandom = this.secureRandom.orElseGet(this.defaultSecureRandomSupplier);
        secureRandom.nextBytes(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.secretKeyProperties.getName());
        Arrays.fill(byArray, (byte)0);
        return secretKeySpec;
    }

    static KeyGeneratorSpi createAesKeyGeneratorSpi() {
        return new SecretKeyGenerator(DefaultSecureRandomSupplier.INSTANCE, AesSecretKeyProperties.INSTANCE);
    }

    private static interface SecretKeyProperties {
        public String getName();

        public int defaultKeySize();

        public void checkKeySizeIsValid(int var1);
    }

    static final class DefaultSecureRandomSupplier
    implements Supplier<SecureRandom> {
        public static final DefaultSecureRandomSupplier INSTANCE = new DefaultSecureRandomSupplier();

        private DefaultSecureRandomSupplier() {
        }

        @Override
        public SecureRandom get() {
            return new LibCryptoRng();
        }
    }

    static final class AesSecretKeyProperties
    implements SecretKeyProperties {
        public static final AesSecretKeyProperties INSTANCE = new AesSecretKeyProperties();
        private static final String NAME = "AES";
        private static final Set<Integer> AES_VALID_KEY_SIZES = AesSecretKeyProperties.aesValidKeySizes();

        private AesSecretKeyProperties() {
        }

        private static Set<Integer> aesValidKeySizes() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(128);
            hashSet.add(192);
            hashSet.add(256);
            return hashSet;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public int defaultKeySize() {
            try {
                return Math.min(256, Cipher.getMaxAllowedKeyLength(NAME));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AssertionError("This is an impossible case.", noSuchAlgorithmException);
            }
        }

        @Override
        public void checkKeySizeIsValid(int n) {
            if (!AES_VALID_KEY_SIZES.contains(n)) {
                throw new InvalidParameterException("Wrong keysize: must be equal to 128, 192 or 256");
            }
        }
    }
}

