/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.crn;

import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.ConfluentServerCrnAuthority;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfluentCloudCrnAuthority
extends ConfluentServerCrnAuthority {
    public static final String AUTHORITY_NAME = "confluent.cloud";
    public static final String PATH_TYPE_SEPARATOR = "=";

    public ConfluentCloudCrnAuthority() {
        this(10000);
    }

    public ConfluentCloudCrnAuthority(int initialCapacity) {
        super(AUTHORITY_NAME, initialCapacity);
    }

    @Override
    protected String resolvePathElement(ConfluentResourceName.Element element) throws CrnSyntaxException {
        switch (element.resourceType()) {
            case "parent": 
            case "organization": 
            case "environment": 
            case "cloud-cluster": 
            case "identity-provider": {
                return element.resourceType() + PATH_TYPE_SEPARATOR + element.encodedResourceName();
            }
        }
        throw new CrnSyntaxException(element.toString(), String.format("Path element must be %s, %s, %s, %s or %s", "parent", "organization", "environment", "cloud-cluster", "identity-provider"));
    }

    @Override
    protected void parsePathElements(List<String> path, ConfluentResourceName.Builder builder) throws CrnSyntaxException {
        block14: for (String pathElement : path) {
            String[] parts = pathElement.split(PATH_TYPE_SEPARATOR);
            if (parts.length != 2 || parts[1].isEmpty()) {
                throw new CrnSyntaxException(pathElement, String.format("Expected type%sname", PATH_TYPE_SEPARATOR));
            }
            switch (parts[0]) {
                case "parent": {
                    builder.addElement("parent", parts[1]);
                    continue block14;
                }
                case "organization": {
                    builder.addElement("organization", parts[1]);
                    continue block14;
                }
                case "environment": {
                    builder.addElement("environment", parts[1]);
                    continue block14;
                }
                case "cloud-cluster": {
                    builder.addElement("cloud-cluster", parts[1]);
                    continue block14;
                }
                case "identity-provider": {
                    builder.addElement("identity-provider", parts[1]);
                    continue block14;
                }
            }
            throw new CrnSyntaxException(pathElement, String.format("Path element must be %s, %s, %s, %s or %s", "parent", "organization", "environment", "cloud-cluster", "identity-provider"));
        }
    }

    @Override
    public ConfluentResourceName canonicalCrn(Scope scope, ResourcePattern resourcePattern) throws CrnSyntaxException {
        ConfluentResourceName crn = super.canonicalCrn(scope, resourcePattern);
        if (scope.path().isEmpty()) {
            return crn;
        }
        if (!((String)scope.path().get(0)).startsWith("organization=") && !((String)scope.path().get(0)).startsWith("parent=")) {
            throw new CrnSyntaxException(scope.path().toString(), "Missing Organization or a Parent");
        }
        if (!(scope.clusters().isEmpty() || scope.path().size() >= 2 && ((String)scope.path().get(1)).startsWith("environment="))) {
            throw new CrnSyntaxException(scope.path().toString(), "Missing Environment");
        }
        if (scope.path().size() == 3 && !((String)scope.path().get(2)).startsWith("cloud-cluster=")) {
            throw new CrnSyntaxException(scope.path().toString(), "Missing Cloud Cluster");
        }
        if (scope.path().size() > 3) {
            throw new CrnSyntaxException(scope.path().toString(), "Extraneous path element");
        }
        List elements = crn.elements();
        for (int i = 0; i < elements.size() - 1; ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                if (!((ConfluentResourceName.Element)elements.get(i)).resourceType().equals(((ConfluentResourceName.Element)elements.get(j)).resourceType())) continue;
                throw new CrnSyntaxException(crn.toString(), "Duplicate element: " + ((ConfluentResourceName.Element)elements.get(j)).resourceType());
            }
        }
        return crn;
    }

    @Override
    protected void addClusters(ConfluentResourceName.Builder builder, Scope scope) throws CrnSyntaxException {
        Map clusters = scope.clusters();
        ArrayList exceptions = new ArrayList();
        clusters.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            try {
                String clusterType = (String)CLUSTER_TYPE_BY_KEY.get(e.getKey());
                if (clusterType != null) {
                    builder.addElement(clusterType, (String)e.getValue());
                } else {
                    exceptions.add(new CrnSyntaxException((String)e.getKey(), "Unknown cluster type"));
                }
            }
            catch (CrnSyntaxException exception) {
                exceptions.add(exception);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new CrnSyntaxException("", exceptions);
        }
    }
}

