/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit;

import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnAuthority;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.security.audit.AuthenticationInfo;
import io.confluent.security.audit.AuthorizationInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class AuditLogOAuthUtils {
    public static final String IDENTITY_POOL_ID_KEY = "identityPoolId";
    private static final String ORGANIZATION_ID_TYPE = "organization";
    private static final String IDENTITY_PROVIDER_TYPE = "identity-provider";
    private static final String IDENTITY_TYPE = "identity";
    private static final String NOT_AVAILABLE = "NA";

    public static void setIdentityInformation(AuthenticationInfo.Builder authenticationBuilder, KafkaPrincipal eventPrincipal, KafkaPrincipal originalPrincipal, CrnAuthority crnAuthority) {
        KafkaPrincipal kafkaPrincipal = originalPrincipal != null ? originalPrincipal : eventPrincipal;
        AuditLogOAuthUtils.maybeFetchIdentityInfo(kafkaPrincipal, IdentityMetadata::maybeGetPoolId).map(p -> "User:" + p).ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authenticationBuilder).setPrincipal(arg_0));
        AuditLogOAuthUtils.setIdentityField(authenticationBuilder, kafkaPrincipal, crnAuthority.name());
    }

    public static <T> Optional<T> maybeFetchIdentityInfo(KafkaPrincipal kafkaPrincipal, Function<IdentityMetadata, Optional<T>> supplier) {
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            return ((MultiTenantPrincipal)kafkaPrincipal).maybeGetIdentityMetadata().flatMap(supplier);
        }
        return Optional.empty();
    }

    public static void setIdentityField(AuthenticationInfo.Builder authenticationBuilder, KafkaPrincipal principal, String crnName) {
        Optional<String> externalIdentityId = AuditLogOAuthUtils.externalIdentityId(principal);
        if (externalIdentityId.isPresent()) {
            authenticationBuilder.setIdentity(externalIdentityId.get());
        } else {
            authenticationBuilder.setIdentity(AuditLogOAuthUtils.maybeGetIdentityCRN(principal, crnName).map(ConfluentResourceName::toString).orElse(""));
        }
    }

    public static Optional<String> externalIdentityId(KafkaPrincipal principal) {
        Optional identityMetadata;
        if (principal instanceof ConfluentPrincipal && (identityMetadata = ((ConfluentPrincipal)principal).maybeGetIdentityMetadata()).isPresent()) {
            return Optional.ofNullable(((IdentityMetadata)identityMetadata.get()).externalIdentityId());
        }
        return Optional.empty();
    }

    public static Optional<ConfluentResourceName> maybeGetIdentityCRN(KafkaPrincipal principal, String authName) {
        if (!(principal instanceof MultiTenantPrincipal)) {
            return Optional.empty();
        }
        MultiTenantPrincipal mtp = (MultiTenantPrincipal)principal;
        ConfluentResourceName.Builder crnBuilder = ConfluentResourceName.newBuilder();
        crnBuilder.setAuthority(authName);
        String orgId = mtp.tenantMetadata().organizationId;
        AuditLogOAuthUtils.addElement(crnBuilder, ORGANIZATION_ID_TYPE, orgId == null ? NOT_AVAILABLE : orgId);
        AuditLogOAuthUtils.addElement(crnBuilder, IDENTITY_PROVIDER_TYPE, mtp.maybeGetIdentityMetadata().flatMap(IdentityMetadata::maybeGetProviderId).orElse(NOT_AVAILABLE));
        AuditLogOAuthUtils.addElement(crnBuilder, IDENTITY_TYPE, mtp.maybeGetIdentityMetadata().flatMap(IdentityMetadata::maybeGetIdentity).orElse(NOT_AVAILABLE));
        try {
            ConfluentResourceName rsrcName = crnBuilder.build();
            return Optional.of(rsrcName);
        }
        catch (CrnSyntaxException cse) {
            cse.printStackTrace();
            return Optional.empty();
        }
    }

    public static void setIdentityInformation(AuthenticationInfo.Builder authenticationBuilder, AuthenticationException authenticationException, CrnAuthority crnAuthority) {
        Optional.ofNullable(authenticationException).filter(e -> e.errorInfo().saslExtensions().containsKey(IDENTITY_POOL_ID_KEY)).map(e -> "User:" + (String)e.errorInfo().saslExtensions().get(IDENTITY_POOL_ID_KEY)).ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authenticationBuilder).setPrincipal(arg_0));
        Optional.ofNullable(authenticationException).flatMap(e -> AuditLogOAuthUtils.maybeGetIdentityCRN(e, crnAuthority.name())).map(ConfluentResourceName::toString).ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authenticationBuilder).setIdentity(arg_0));
    }

    public static void setAssignedPrincipal(AuthorizationInfo.Builder authorizationBuilder, KafkaPrincipal principal) {
        if (AuditLogOAuthUtils.multiplePrincipal(principal)) {
            List assignedPrincipals = ((ConfluentPrincipal)principal).authorizationIds();
            authorizationBuilder.addAllAssignedPrincipals((Iterable)assignedPrincipals);
        }
    }

    public static boolean multiplePrincipal(KafkaPrincipal principal) {
        if (principal instanceof ConfluentPrincipal) {
            return ((ConfluentPrincipal)principal).authorizationIds().size() > 1;
        }
        return false;
    }

    private static Optional<ConfluentResourceName> maybeGetIdentityCRN(AuthenticationException exception, String authName) {
        ConfluentResourceName.Builder crnBuilder = ConfluentResourceName.newBuilder();
        crnBuilder.setAuthority(authName);
        AuditLogOAuthUtils.addElement(crnBuilder, ORGANIZATION_ID_TYPE, Optional.of(exception).filter(e -> e.errorInfo().data().containsKey("organizationId")).map(e -> (String)e.errorInfo().data().get("organizationId")).orElse(NOT_AVAILABLE));
        AuditLogOAuthUtils.addElement(crnBuilder, IDENTITY_PROVIDER_TYPE, Optional.of(exception).filter(e -> e.errorInfo().data().containsKey("providerId")).map(e -> (String)e.errorInfo().data().get("providerId")).orElse(NOT_AVAILABLE));
        AuditLogOAuthUtils.addElement(crnBuilder, IDENTITY_TYPE, Optional.of(exception).filter(e -> e.errorInfo().data().containsKey(IDENTITY_TYPE)).map(e -> (String)e.errorInfo().data().get(IDENTITY_TYPE)).orElse(NOT_AVAILABLE));
        try {
            ConfluentResourceName rsrcName = crnBuilder.build();
            return Optional.of(rsrcName);
        }
        catch (CrnSyntaxException cse) {
            cse.printStackTrace();
            return Optional.empty();
        }
    }

    private static void addElement(ConfluentResourceName.Builder crnBuilder, String type, String name) {
        try {
            crnBuilder.addElement(type, name);
        }
        catch (CrnSyntaxException cse) {
            cse.printStackTrace();
        }
    }
}

