/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.ConfluentServerCrnAuthority;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.auth.ConfluentSaslServer;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.AuthenticationInfo;
import io.confluent.protobuf.events.auditlog.v2.AuthorizationInfo;
import io.confluent.protobuf.events.auditlog.v2.CloudScope;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Principal;
import io.confluent.protobuf.events.auditlog.v2.Request;
import io.confluent.protobuf.events.auditlog.v2.RequestMetadata;
import io.confluent.protobuf.events.auditlog.v2.ResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AclAuthorizationInfo;
import io.confluent.security.audit.Address;
import io.confluent.security.audit.AuditLogEntry;
import io.confluent.security.audit.AuditLogOAuthUtils;
import io.confluent.security.audit.AuthenticationInfo;
import io.confluent.security.audit.AuthenticationMetadata;
import io.confluent.security.audit.AuthorizationInfo;
import io.confluent.security.audit.AuthorizationScope;
import io.confluent.security.audit.RbacAuthorizationInfo;
import io.confluent.security.audit.Result;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import io.confluent.security.rbac.RbacAccessRule;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.KafkaRequestEvent;

public class AuditLogUtils {
    public static final String AUTHENTICATION_FAILED_EVENT_USER = "None:UNKNOWN_USER";
    public static final String AUTHENTICATION_EVENT_NAME = "kafka.Authentication";
    public static final String TOPIC_MISSING_IN_REQUEST = "TOPIC_MISSING_IN_REQUEST";
    private static final String CLIENT_SOFTWARE = "CLIENT_SOFTWARE";
    private static final String CLIENT_SOFTWARE_VERSION = "CLIENT_SOFTWARE_VERSION";
    private static final String TLS_VERSION = "TLS_VERSION";
    private static final String CIPHER_SUITE = "CIPHER_SUITE";

    private static void addAuthorizationInfo(AuthorizationInfo.Builder authorizationBuilder, AuthorizePolicy authorizePolicy, KafkaPrincipal principal) {
        boolean setActingPrincipal = AuditLogOAuthUtils.multiplePrincipal(principal);
        switch (authorizePolicy.policyType()) {
            case NO_MATCHING_RULE: 
            case DENY_ON_NO_RULE: 
            case ALLOW_ON_NO_RULE: {
                break;
            }
            case BROKER_USER: 
            case SUPER_USER: 
            case SUPER_GROUP: {
                authorizationBuilder.setSuperUserAuthorization(true);
                break;
            }
            case ALLOW_ACL: 
            case DENY_ACL: {
                AccessControlEntry entry = ((AclAccessRule)authorizePolicy).aclBinding().entry();
                authorizationBuilder.setAclAuthorization(AclAuthorizationInfo.newBuilder().setHost(entry.host()).setPermissionType(entry.permissionType().toString()).setActingPrincipal(setActingPrincipal ? entry.principal() : ""));
                break;
            }
            case ALLOW_ROLE: {
                Scope scope = ((RbacAccessRule)authorizePolicy).scope();
                RbacAccessRule accessRule = (RbacAccessRule)authorizePolicy;
                authorizationBuilder.setRbacAuthorization(RbacAuthorizationInfo.newBuilder().setRole(((RbacAccessRule)authorizePolicy).role()).setScope(AuthorizationScope.newBuilder().addAllOuterScope((Iterable)scope.path()).putAllClusters(scope.clusters())).setActingPrincipal(setActingPrincipal ? accessRule.principal().toString() : ""));
            }
        }
    }

    public static AuditLogEntry authorizationEvent(ConfluentAuthorizationEvent authorizationEvent, ConfluentServerCrnAuthority crnAuthority) throws CrnSyntaxException {
        return AuditLogUtils.authorizationEvent(authorizationEvent, null, crnAuthority, false);
    }

    public static AuditLogEntry authorizationEvent(ConfluentAuthorizationEvent authorizationEvent, KafkaPrincipal originalPrincipal, ConfluentServerCrnAuthority crnAuthority, boolean omitClientAddress) throws CrnSyntaxException {
        String source = crnAuthority.canonicalCrn(authorizationEvent.sourceScope()).toString();
        String subject = crnAuthority.canonicalCrn(authorizationEvent.action().scope(), authorizationEvent.action().resourcePattern()).toString();
        AuditLogEntry.Builder builder = AuditLogEntry.newBuilder().setServiceName(source).setMethodName(AuditLogUtils.methodName(authorizationEvent)).setResourceName(subject);
        String principal = authorizationEvent.requestContext().principal().getPrincipalType() + ":" + authorizationEvent.requestContext().principal().getName();
        AuthenticationInfo.Builder authenticationBuilder = AuthenticationInfo.newBuilder().setPrincipal(principal);
        AuditLogOAuthUtils.setIdentityInformation(authenticationBuilder, authorizationEvent.requestContext().principal(), originalPrincipal, crnAuthority);
        Optional<String> userResourceId = Optional.ofNullable((String)authorizationEvent.data().get("principal-resource-id"));
        userResourceId.ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authenticationBuilder).setPrincipalResourceId(arg_0));
        builder.setAuthenticationInfo(authenticationBuilder);
        AuthorizationInfo.Builder authorizationBuilder = AuthorizationInfo.newBuilder().setGranted(authorizationEvent.authorizeResult() == AuthorizeResult.ALLOWED).setOperation(authorizationEvent.action().operation().name()).setResourceType(authorizationEvent.action().resourcePattern().resourceType().toString()).setResourceName(authorizationEvent.action().resourcePattern().name()).setPatternType(authorizationEvent.action().resourcePattern().patternType().toString());
        AuditLogUtils.addAuthorizationInfo(authorizationBuilder, authorizationEvent.authorizePolicy(), originalPrincipal);
        AuditLogOAuthUtils.setAssignedPrincipal(authorizationBuilder, originalPrincipal);
        builder.setAuthorizationInfo(authorizationBuilder);
        Struct.Builder requestBuilder = Struct.newBuilder().putFields("correlation_id", Value.newBuilder().setStringValue(String.valueOf(authorizationEvent.requestContext().correlationId())).build());
        if (authorizationEvent.requestContext().clientId() != null) {
            requestBuilder.putFields("client_id", Value.newBuilder().setStringValue(authorizationEvent.requestContext().clientId()).build());
        }
        builder.setRequest(requestBuilder.build());
        Struct.Builder requestMetadataBuilder = Struct.newBuilder();
        if (authorizationEvent.requestContext().clientAddress() != null) {
            Address address = Address.newBuilder().setIp(authorizationEvent.requestContext().clientAddress().getHostAddress()).setInternal(omitClientAddress).build();
            builder.addClientAddress(address);
        }
        if (authorizationEvent.requestContext().listenerName() != null) {
            requestMetadataBuilder.putFields("request_listener_name", Value.newBuilder().setStringValue(authorizationEvent.requestContext().listenerName()).build());
        }
        if (authorizationEvent.requestContext().requestId() != null) {
            requestMetadataBuilder.putFields("request_id", Value.newBuilder().setStringValue(authorizationEvent.requestContext().requestId()).build());
        } else if (authorizationEvent.requestContext() != null && authorizationEvent.requestContext().kafkaRequestId() != -1L) {
            requestMetadataBuilder.putFields("request_id", Value.newBuilder().setStringValue(Long.toString(authorizationEvent.requestContext().kafkaRequestId())).build());
        }
        if (authorizationEvent.requestContext() != null && authorizationEvent.requestContext().sessionId() != -1L) {
            requestMetadataBuilder.putFields("connection_id", Value.newBuilder().setStringValue(Long.toString(authorizationEvent.requestContext().sessionId())).build());
        }
        builder.setRequestMetadata(requestMetadataBuilder.build());
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String methodName(ConfluentAuthorizationEvent authorizationEvent) {
        String requestName;
        int requestType = authorizationEvent.requestContext().requestType();
        if (requestType < 0) {
            if (!"mds".equals(authorizationEvent.requestContext().requestSource())) throw new RuntimeException("Got unexpected requestType not from MDS: " + requestType);
            requestName = AuditLogRouterUtils.RequestNameOverrides.MDS_AUTHORIZE.name;
            return authorizationEvent.requestContext().requestSource() + "." + requestName;
        } else {
            ApiKeys requestKey = ApiKeys.forId((int)requestType);
            requestName = requestKey == ApiKeys.FETCH ? ("ClusterAction".equals(authorizationEvent.action().operation().name()) ? AuditLogRouterUtils.RequestNameOverrides.KAFKA_FETCH_FOLLOWER.name : AuditLogRouterUtils.RequestNameOverrides.KAFKA_FETCH_CONSUMER.name) : requestKey.name;
        }
        return authorizationEvent.requestContext().requestSource() + "." + requestName;
    }

    public static ConfluentResourceName.Element resourceNameElement(AuditLogEntry entry) throws CrnSyntaxException {
        return ConfluentResourceName.fromString((String)entry.getResourceName()).lastResourceElement();
    }

    public static AuditLogEntry authenticationEvent(ConfluentAuthenticationEvent authenticationEvent, ConfluentServerCrnAuthority crnAuthority) throws CrnSyntaxException {
        return AuditLogUtils.authenticationEvent(authenticationEvent, null, crnAuthority, false);
    }

    public static AuditLogEntry authenticationEvent(ConfluentAuthenticationEvent authenticationEvent, KafkaPrincipal originalPrincipal, ConfluentServerCrnAuthority crnAuthority, boolean omitClientAddress) throws CrnSyntaxException {
        String networkId;
        String source = crnAuthority.canonicalCrn(authenticationEvent.getScope()).toString();
        AuditLogEntry.Builder builder = AuditLogEntry.newBuilder().setServiceName(source).setMethodName(AUTHENTICATION_EVENT_NAME).setResourceName(source);
        AuthenticationInfo.Builder authenticationBuilder = AuthenticationInfo.newBuilder();
        if (authenticationEvent.principal().isPresent()) {
            KafkaPrincipal principal = (KafkaPrincipal)authenticationEvent.principal().get();
            authenticationBuilder.setPrincipal(principal.getPrincipalType() + ":" + principal.getName());
            AuditLogOAuthUtils.setIdentityInformation(authenticationBuilder, principal, originalPrincipal, crnAuthority);
            Optional<String> userResourceId = Optional.ofNullable((String)authenticationEvent.data().get("principal-resource-id"));
            userResourceId.ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authenticationBuilder).setPrincipalResourceId(arg_0));
        } else {
            authenticationBuilder.setPrincipal(AUTHENTICATION_FAILED_EVENT_USER);
            if (authenticationEvent.authenticationException().isPresent()) {
                AuditLogOAuthUtils.setIdentityInformation(authenticationBuilder, (AuthenticationException)authenticationEvent.authenticationException().get(), crnAuthority);
            }
        }
        AuthenticationMetadata.Builder metadataBuilder = authenticationBuilder.getMetadataBuilder();
        metadataBuilder.setIdentifier(AuditLogUtils.getIdentifier((AuthenticationEvent)authenticationEvent));
        metadataBuilder.setMechanism(AuditLogUtils.getMechanism(authenticationEvent.authenticationContext()));
        metadataBuilder.setTlsVersion(AuditLogUtils.getTlsVersion((AuthenticationEvent)authenticationEvent));
        metadataBuilder.setCipherSuite(AuditLogUtils.getCipherSuite((AuthenticationEvent)authenticationEvent));
        metadataBuilder.setClientLibrary(AuditLogUtils.getClientSoftware(authenticationEvent));
        metadataBuilder.setClientLibraryVersion(AuditLogUtils.getClientSoftwareVersion(authenticationEvent));
        authenticationBuilder.setMetadata(metadataBuilder.build());
        builder.setAuthenticationInfo(authenticationBuilder);
        Result.Builder resultBuilder = Result.newBuilder();
        resultBuilder.setStatus(authenticationEvent.status().name());
        if (authenticationEvent.status() != AuditEventStatus.SUCCESS) {
            authenticationEvent.authenticationException().ifPresent(e -> resultBuilder.setMessage(e.errorMessage()));
        }
        builder.setResult(resultBuilder.build());
        Struct.Builder requestMetadataBuilder = Struct.newBuilder();
        if (authenticationEvent.authenticationContext().clientAddress() != null) {
            Address address = Address.newBuilder().setIp(authenticationEvent.authenticationContext().clientAddress().getHostAddress()).setInternal(omitClientAddress).build();
            builder.addClientAddress(address);
        }
        if (authenticationEvent.authenticationContext() != null && authenticationEvent.authenticationContext().listenerName() != null) {
            requestMetadataBuilder.putFields("request_listener_name", Value.newBuilder().setStringValue(authenticationEvent.authenticationContext().listenerName()).build());
        }
        if (authenticationEvent.authenticationContext() != null && authenticationEvent.authenticationContext().sessionId() != -1L) {
            requestMetadataBuilder.putFields("connection_id", Value.newBuilder().setStringValue(Long.toString(authenticationEvent.authenticationContext().sessionId())).build());
        }
        if ((networkId = AuditLogUtils.networkId((AuthenticationEvent)authenticationEvent)) != null && !networkId.isEmpty()) {
            requestMetadataBuilder.putFields("network_id", Value.newBuilder().setStringValue(networkId).build());
        }
        builder.setRequestMetadata(requestMetadataBuilder.build());
        String remoteLogicalClusterId = AuditLogUtils.remoteLogicalClusterId((AuthenticationEvent)authenticationEvent);
        if (remoteLogicalClusterId != null && !remoteLogicalClusterId.isEmpty()) {
            Struct.Builder requestBuilder = Struct.newBuilder().putFields("remote_logical_cluster_id", Value.newBuilder().setStringValue(remoteLogicalClusterId).build());
            builder.setRequest(requestBuilder.build());
        }
        return builder.build();
    }

    private static String getClientSoftwareVersion(ConfluentAuthenticationEvent event) {
        if (event.data() == null || !event.data().containsKey(CLIENT_SOFTWARE_VERSION)) {
            return "";
        }
        return (String)event.data().get(CLIENT_SOFTWARE_VERSION);
    }

    private static String getClientSoftware(ConfluentAuthenticationEvent event) {
        if (event.data() == null || !event.data().containsKey(CLIENT_SOFTWARE)) {
            return "";
        }
        return (String)event.data().get(CLIENT_SOFTWARE);
    }

    private static String getCipherSuite(AuthenticationEvent event) {
        if (event.data() == null || !event.data().containsKey(CIPHER_SUITE)) {
            return "";
        }
        return (String)event.data().get(CIPHER_SUITE);
    }

    private static String getTlsVersion(AuthenticationEvent event) {
        if (event.data() == null || !event.data().containsKey(TLS_VERSION)) {
            return "";
        }
        return (String)event.data().get(TLS_VERSION);
    }

    private static String getMechanism(AuthenticationContext context) {
        if (context instanceof PlaintextAuthenticationContext || context instanceof SslAuthenticationContext) {
            return context.securityProtocol().name;
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            return saslServer == null ? context.securityProtocol().name : context.securityProtocol().name + "/" + saslServer.getMechanismName();
        }
        return "";
    }

    private static String getIdentifier(AuthenticationEvent event) {
        AuthenticationContext context = event.authenticationContext();
        if (context instanceof SslAuthenticationContext) {
            return AuditLogUtils.sslPeerPrincipal((SslAuthenticationContext)context);
        }
        if (context instanceof SaslAuthenticationContext) {
            return AuditLogUtils.saslIdentifier(event);
        }
        return "";
    }

    private static String networkId(AuthenticationEvent event) {
        ConfluentSaslServer server = AuditLogUtils.confluentSaslServer(event);
        if (server == null) {
            return "";
        }
        return server.networkId().orElse("");
    }

    private static String remoteLogicalClusterId(AuthenticationEvent event) {
        ConfluentSaslServer server = AuditLogUtils.confluentSaslServer(event);
        if (server == null) {
            return "";
        }
        return server.clientLogicalClusterId().orElse("");
    }

    private static ConfluentSaslServer confluentSaslServer(AuthenticationEvent event) {
        SaslAuthenticationContext saslAuthenticationContext;
        SaslServer saslServer;
        AuthenticationContext context = event.authenticationContext();
        if (context instanceof SaslAuthenticationContext && (saslServer = (saslAuthenticationContext = (SaslAuthenticationContext)event.authenticationContext()).server()) instanceof ConfluentSaslServer) {
            return (ConfluentSaslServer)saslServer;
        }
        return null;
    }

    private static String saslIdentifier(AuthenticationEvent authenticationEvent) {
        SaslAuthenticationContext context = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Optional exceptionOptional = authenticationEvent.authenticationException();
        if (exceptionOptional.isPresent()) {
            AuthenticationErrorInfo errorInfo = ((AuthenticationException)exceptionOptional.get()).errorInfo();
            return errorInfo.identifier();
        }
        SaslServer saslServer = context.server();
        if (saslServer instanceof PlainSaslServer) {
            PlainSaslServer server = (PlainSaslServer)saslServer;
            return server.userIdentifier();
        }
        return saslServer != null ? saslServer.getAuthorizationID() : "";
    }

    private static String sslPeerPrincipal(SslAuthenticationContext context) {
        try {
            SSLSession sslSession = context.session();
            return sslSession.getPeerPrincipal().getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static AuditLog auditLog(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions, boolean hasAuthorizationFailure, boolean validateOnly, Struct requestData, Result.Status status, Struct resultData, List<TypedCloudResourceRef> typedCloudResourceRefList, String resourceCrn) throws CrnSyntaxException {
        String source = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        Principal principal = AuditLogUtils.v2SchemaPrincipal(requestEvent);
        RequestMetadata requestMetadata = AuditLogUtils.v2RequestMetadata(requestEvent, extractorOptions);
        Optional<String> externalIdentityId = AuditLogOAuthUtils.externalIdentityId(requestEvent.requestContext().principal());
        AuthenticationInfo.Builder authInfo = io.confluent.protobuf.events.auditlog.v2.AuthenticationInfo.newBuilder().setPrincipal(principal).setExposure(AuditLogUtils.exposure(requestEvent)).setResult(AuthenticationInfo.Result.SUCCESS);
        if (externalIdentityId.isPresent()) {
            authInfo.setIdentity(externalIdentityId.get());
        } else {
            AuditLogOAuthUtils.maybeGetIdentityCRN(requestEvent.requestContext().principal(), extractorOptions.crnAuthority().name()).map(ConfluentResourceName::toString).ifPresent(arg_0 -> ((AuthenticationInfo.Builder)authInfo).setIdentity(arg_0));
        }
        AuditLog.Builder auditLogBuilder = AuditLog.newBuilder().setServiceName(source).setMethodName(AuditLogUtils.methodName(requestEvent)).setAuthenticationInfo(authInfo.build()).setAuthorizationInfo(io.confluent.protobuf.events.auditlog.v2.AuthorizationInfo.newBuilder().setResult(hasAuthorizationFailure ? AuthorizationInfo.Result.DENY : AuthorizationInfo.Result.ALLOW).setDryRun(validateOnly).build()).setRequestMetadata(requestMetadata).setRequest(Request.newBuilder().setAccessType(Request.AccessType.MODIFICATION).setData(requestData).build()).setResult(io.confluent.protobuf.events.auditlog.v2.Result.newBuilder().setStatus(status).setData(resultData).build()).setResourceName(resourceCrn);
        Optional<FullyQualifiedCloudResourceRef> cloudResourceRef = AuditLogUtils.cloudResourceRef(typedCloudResourceRefList);
        cloudResourceRef.ifPresent(fullyQualifiedCloudResourceRef -> auditLogBuilder.addCloudResources(fullyQualifiedCloudResourceRef));
        return auditLogBuilder.build();
    }

    public static String requestCrn(ConfluentServerCrnAuthority crnAuthority, KafkaRequestEvent requestEvent) throws CrnSyntaxException {
        if (requestEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            return crnAuthority.canonicalCrn(((MultiTenantPrincipal)requestEvent.requestContext().principal()).tenantMetadata().scope()).toString();
        }
        return requestEvent.requestSourceCrn();
    }

    public static String methodName(KafkaRequestEvent kafkaRequestEvent) {
        ApiKeys requestKey = ApiKeys.forId((int)kafkaRequestEvent.requestContext().requestType());
        return "kafka." + requestKey.name;
    }

    public static String requestResourceCrn(ConfluentServerCrnAuthority crnAuthority, KafkaRequestEvent requestEvent, ResourcePattern resourcePattern) throws CrnSyntaxException {
        if (requestEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            return crnAuthority.canonicalCrn(((MultiTenantPrincipal)requestEvent.requestContext().principal()).tenantMetadata().scope(), resourcePattern).toString();
        }
        return requestEvent.requestSourceCrn();
    }

    public static Principal v2SchemaPrincipal(KafkaRequestEvent requestEvent) {
        if (requestEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)requestEvent.requestContext().principal();
            TenantMetadata tenantMetadata = multiTenantPrincipal.tenantMetadata();
            String userId = tenantMetadata.userResourceId == null ? multiTenantPrincipal.user() : tenantMetadata.userResourceId;
            String poolId = AuditLogOAuthUtils.maybeFetchIdentityInfo((KafkaPrincipal)multiTenantPrincipal, IdentityMetadata::maybeGetPoolId).filter(pid -> pid.startsWith("pool-")).orElse(null);
            if (poolId != null) {
                return Principal.newBuilder().setIdentityPool(ResourceRef.newBuilder().setResourceId(poolId)).build();
            }
            if (tenantMetadata.isServiceAccount) {
                return Principal.newBuilder().setConfluentServiceAccount(ResourceRef.newBuilder().setResourceId(userId).build()).build();
            }
            return Principal.newBuilder().setConfluentUser(ResourceRef.newBuilder().setResourceId(userId).build()).build();
        }
        return Principal.newBuilder().setConfluentUser(ResourceRef.newBuilder().setResourceId(requestEvent.requestContext().principal().toString()).build()).build();
    }

    private static AuthenticationInfo.Exposure exposure(KafkaRequestEvent requestEvent) {
        if (requestEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            TenantMetadata tenantMetadata = ((MultiTenantPrincipal)requestEvent.requestContext().principal()).tenantMetadata();
            if (tenantMetadata.isHealthcheckTenant) {
                return AuthenticationInfo.Exposure.INTERNAL;
            }
            return AuthenticationInfo.Exposure.CUSTOMER;
        }
        return AuthenticationInfo.Exposure.INTERNAL;
    }

    public static boolean hasAuthorizationFailure(short errorCode) {
        return Errors.CLUSTER_AUTHORIZATION_FAILED.code() == errorCode || Errors.TOPIC_AUTHORIZATION_FAILED.code() == errorCode || Errors.GROUP_AUTHORIZATION_FAILED.code() == errorCode || Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED.code() == errorCode;
    }

    public static RequestMetadata v2RequestMetadata(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) {
        RequestMetadata.Builder builder = RequestMetadata.newBuilder();
        if (requestEvent.requestContext().kafkaRequestId() != -1L) {
            builder.addRequestId(Long.toString(requestEvent.requestContext().kafkaRequestId()));
        }
        if (requestEvent.requestContext().sessionId() != -1L) {
            builder.setConnectionId(Long.toString(requestEvent.requestContext().sessionId()));
        }
        if (requestEvent.requestContext().clientId() != null) {
            builder.setClientId(requestEvent.requestContext().clientId());
        }
        if (requestEvent.requestContext().clientAddress() != null) {
            builder.addClientAddress(RequestMetadata.Address.newBuilder().setInternal(extractorOptions.omitClientAddress()).setIp(requestEvent.requestContext().clientAddress().getHostAddress()).build());
        }
        if (requestEvent.requestContext().listenerName() != null) {
            builder.setRequestListenerName(requestEvent.requestContext().listenerName());
        }
        return builder.build();
    }

    public static Optional<FullyQualifiedCloudResourceRef> cloudResourceRef(List<TypedCloudResourceRef> typedCloudResourceRefList) {
        if (typedCloudResourceRefList.isEmpty()) {
            return Optional.empty();
        }
        if (typedCloudResourceRefList.size() == 1) {
            FullyQualifiedCloudResourceRef cloudResourceRef = FullyQualifiedCloudResourceRef.newBuilder().setResource(typedCloudResourceRefList.get(0)).build();
            return Optional.of(cloudResourceRef);
        }
        FullyQualifiedCloudResourceRef.Builder cloudResourceRefBuilder = FullyQualifiedCloudResourceRef.newBuilder();
        CloudScope.Builder cloudScopeBuilder = CloudScope.newBuilder();
        for (int i = 0; i < typedCloudResourceRefList.size() - 1; ++i) {
            cloudScopeBuilder.addResources(typedCloudResourceRefList.get(i));
        }
        cloudResourceRefBuilder.setScope(cloudScopeBuilder.build());
        cloudResourceRefBuilder.setResource(typedCloudResourceRefList.get(typedCloudResourceRefList.size() - 1));
        return Optional.of(cloudResourceRefBuilder.build());
    }

    public static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent) {
        LinkedList<TypedCloudResourceRef> typedCloudResourceRefList = new LinkedList<TypedCloudResourceRef>();
        if (requestEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            TenantMetadata tenantMetadata = ((MultiTenantPrincipal)requestEvent.requestContext().principal()).tenantMetadata();
            if (tenantMetadata.organizationId == null || tenantMetadata.environmentId == null) {
                return typedCloudResourceRefList;
            }
            typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.ORGANIZATION).setResourceId(tenantMetadata.organizationId).build());
            typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.ENVIRONMENT).setResourceId(tenantMetadata.environmentId).build());
            typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.CLOUD_CLUSTER).setResourceId(tenantMetadata.clusterId).build());
            typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.KAFKA_CLUSTER).setResourceId(tenantMetadata.clusterId).build());
        }
        return typedCloudResourceRefList;
    }
}

