/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestDataJsonConverter;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterConfigsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(AlterConfigsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        AlterConfigsRequestData alterConfigsRequestData = AlterConfigsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        AlterConfigsResponseData alterConfigsResponseData = AlterConfigsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean hasAuthorizationFailure = AlterConfigsRequestAuditExtractor.hasAuthorizationFailure(alterConfigsResponseData);
        boolean validateOnly = alterConfigsRequestData.validateOnly();
        Struct requestData = AlterConfigsRequestAuditExtractor.requestData(alterConfigsRequestData, requestEvent);
        Result.Status status = AlterConfigsRequestAuditExtractor.status(alterConfigsResponseData);
        Struct resultData = AlterConfigsRequestAuditExtractor.resultData(alterConfigsResponseData, requestEvent);
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        String resourceCrn = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
        extractedAuditLogs.add(auditLog);
        return extractedAuditLogs;
    }

    private static boolean hasAuthorizationFailure(AlterConfigsResponseData alterConfigsResponseData) {
        return alterConfigsResponseData.responses().stream().anyMatch(alterConfigsResourceResponse -> AuditLogUtils.hasAuthorizationFailure(alterConfigsResourceResponse.errorCode()));
    }

    private static Struct requestData(AlterConfigsRequestData alterConfigsRequestData, KafkaRequestEvent requestEvent) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)AlterConfigsRequestDataJsonConverter.write((AlterConfigsRequestData)alterConfigsRequestData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        for (JsonNode resource : jsonNode.get("resources")) {
            ((ObjectNode)resource).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)resource.get("resourceType").shortValue())).name()));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(AlterConfigsResponseData alterConfigsResponseData) {
        if (alterConfigsResponseData.responses().stream().anyMatch(alterConfigsResourceResponse -> alterConfigsResourceResponse.errorCode() != Errors.NONE.code())) {
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }

    private static Struct resultData(AlterConfigsResponseData alterConfigsResponseData, KafkaRequestEvent requestEvent) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)AlterConfigsResponseDataJsonConverter.write((AlterConfigsResponseData)alterConfigsResponseData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("throttleTimeMs");
        for (JsonNode response : jsonNode.get("responses")) {
            ((ObjectNode)response).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)response.get("resourceType").shortValue())).name()));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

