/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsRequestDataJsonConverter;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateAclsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAclsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(CreateAclsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        CreateAclsRequestData createAclsRequestData = CreateAclsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        CreateAclsResponseData createAclsResponseData = CreateAclsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean hasAuthorizationFailure = CreateAclsRequestAuditExtractor.hasAuthorizationFailure(createAclsResponseData);
        Struct requestData = CreateAclsRequestAuditExtractor.requestData(createAclsRequestData, requestEvent);
        Result.Status status = CreateAclsRequestAuditExtractor.status(createAclsResponseData);
        Struct resultData = CreateAclsRequestAuditExtractor.resultData(createAclsResponseData, requestEvent);
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        String resourceCrn = AuditLogUtils.requestCrn(extractorOptions.crnAuthority(), requestEvent);
        AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
        extractedAuditLogs.add(auditLog);
        return extractedAuditLogs;
    }

    private static boolean hasAuthorizationFailure(CreateAclsResponseData createAclsResponseData) {
        return createAclsResponseData.results().stream().anyMatch(aclCreationResult -> AuditLogUtils.hasAuthorizationFailure(aclCreationResult.errorCode()));
    }

    private static Struct requestData(CreateAclsRequestData createAclsRequestData, KafkaRequestEvent requestEvent) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)CreateAclsRequestDataJsonConverter.write((CreateAclsRequestData)createAclsRequestData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        for (JsonNode creation : jsonNode.get("creations")) {
            ((ObjectNode)creation).set("resourceType", (JsonNode)new TextNode(ResourceType.fromCode((byte)((byte)creation.get("resourceType").shortValue())).name()));
            ((ObjectNode)creation).set("resourcePatternType", (JsonNode)new TextNode(PatternType.fromCode((byte)((byte)creation.get("resourcePatternType").shortValue())).name()));
            ((ObjectNode)creation).set("operation", (JsonNode)new TextNode(AclOperation.fromCode((byte)((byte)creation.get("operation").shortValue())).name()));
            ((ObjectNode)creation).set("permissionType", (JsonNode)new TextNode(AclPermissionType.fromCode((byte)((byte)creation.get("permissionType").shortValue())).name()));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(CreateAclsResponseData createAclsResponseData) {
        if (createAclsResponseData.results().stream().anyMatch(aclCreationResult -> aclCreationResult.errorCode() != Errors.NONE.code())) {
            return Result.Status.FAILURE;
        }
        return Result.Status.SUCCESS;
    }

    private static Struct resultData(CreateAclsResponseData createAclsResponseData, KafkaRequestEvent requestEvent) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)CreateAclsResponseDataJsonConverter.write((CreateAclsResponseData)createAclsResponseData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("throttleTimeMs");
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

