/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestDataJsonConverter;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTopicsRequestAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(DeleteTopicsRequestAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        DeleteTopicsRequestData deleteTopicsRequestData = DeleteTopicsRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        DeleteTopicsResponseData deleteTopicsResponseData = DeleteTopicsResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        if (!deleteTopicsRequestData.topicNames().isEmpty()) {
            for (String topicName : deleteTopicsRequestData.topicNames()) {
                DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult = deleteTopicsResponseData.responses().find(topicName);
                extractedAuditLogs.add(DeleteTopicsRequestAuditExtractor.extractAuditLog(requestEvent, extractorOptions, topicName, deletableTopicResult, false));
            }
        } else {
            for (DeleteTopicsRequestData.DeleteTopicState topic : deleteTopicsRequestData.topics()) {
                String topicName = Uuid.ZERO_UUID.equals((Object)topic.topicId()) ? topic.name() : topic.topicId().toString();
                DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult = DeleteTopicsRequestAuditExtractor.deletableTopicResult(deleteTopicsResponseData, topic);
                extractedAuditLogs.add(DeleteTopicsRequestAuditExtractor.extractAuditLog(requestEvent, extractorOptions, topicName, deletableTopicResult, !Uuid.ZERO_UUID.equals((Object)topic.topicId())));
            }
        }
        return extractedAuditLogs;
    }

    private static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult(DeleteTopicsResponseData deleteTopicsResponseData, DeleteTopicsRequestData.DeleteTopicState topicState) {
        if (!Uuid.ZERO_UUID.equals((Object)topicState.topicId())) {
            for (DeleteTopicsResponseData.DeletableTopicResult result : deleteTopicsResponseData.responses()) {
                if (!topicState.topicId().equals((Object)result.topicId())) continue;
                return result;
            }
        } else {
            for (DeleteTopicsResponseData.DeletableTopicResult result : deleteTopicsResponseData.responses()) {
                if (!topicState.name().equals(result.name())) continue;
                return result;
            }
        }
        throw new IllegalStateException("Missing deletableTopicResult result for topic " + String.valueOf(topicState));
    }

    private static AuditLog extractAuditLog(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions, String topicName, DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult, boolean isTopicId) throws Exception {
        Struct requestData = DeleteTopicsRequestAuditExtractor.requestData(topicName, isTopicId);
        if (topicName == null || topicName.isEmpty()) {
            topicName = "TOPIC_MISSING_IN_REQUEST";
            deletableTopicResult.setName("TOPIC_MISSING_IN_REQUEST");
        }
        ResourcePattern resourcePattern = new ResourcePattern("Topic", topicName, PatternType.LITERAL);
        boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(deletableTopicResult.errorCode());
        Result.Status status = DeleteTopicsRequestAuditExtractor.status(deletableTopicResult);
        Struct resultData = DeleteTopicsRequestAuditExtractor.resultData(deletableTopicResult);
        List<TypedCloudResourceRef> typedCloudResourceRefList = DeleteTopicsRequestAuditExtractor.typedCloudResourceRefList(requestEvent, topicName);
        String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
        return AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.TOPIC).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(String topicName, boolean isTopicId) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        if (isTopicId) {
            jsonNode.set("topicId", (JsonNode)new TextNode(topicName));
        } else {
            jsonNode.set("name", (JsonNode)new TextNode(topicName));
        }
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult) {
        if (deletableTopicResult.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(deletableTopicResult.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(deletableTopicResult.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)deletableTopicResult.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

