/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.router;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.confluent.security.audit.AuditLogEntry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogRouterUtils {
    private static final Logger log = LoggerFactory.getLogger(AuditLogRouterUtils.class);
    @Deprecated
    public static final String OTHER_CATEGORY = "other";
    public static final String UNAUDITED = "unaudited";
    public static final String MANAGEMENT_CATEGORY = "management";
    public static final String PRODUCE_CATEGORY = "produce";
    public static final String CONSUME_CATEGORY = "consume";
    public static final String INTERBROKER_CATEGORY = "interbroker";
    public static final String AUTHORIZE_CATEGORY = "authorize";
    public static final String DESCRIBE_CATEGORY = "describe";
    public static final String HEARTBEAT_CATEGORY = "heartbeat";
    public static final String AUTHENTICATION_CATEGORY = "authentication";
    public static final Set<String> DEFAULT_ENABLED_CATEGORIES = Set.of("authorize", "management", "authentication");
    public static final Map<String, String> METHOD_CATEGORIES;
    public static final Set<String> CATEGORIES;

    private static Map.Entry<String, String> entry(ApiKeys k, String category) {
        return Maps.immutableEntry((Object)("kafka." + k.name), (Object)category);
    }

    private static Map.Entry<String, String> entry(RequestNameOverrides override) {
        return Maps.immutableEntry((Object)(override.prefix + override.name), (Object)override.category);
    }

    public static String category(AuditLogEntry entry) {
        return AuditLogRouterUtils.category(entry.getMethodName());
    }

    public static String category(String methodName) {
        return METHOD_CATEGORIES.getOrDefault(methodName, UNAUDITED);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApiKeys apiKey : ApiKeys.brokerApis()) {
            builder.put(AuditLogRouterUtils.entry(apiKey, switch (apiKey) {
                case ApiKeys.ADD_RAFT_VOTER, ApiKeys.ALTER_CLIENT_QUOTAS, ApiKeys.ALTER_CONFIGS, ApiKeys.ALTER_MIRRORS, ApiKeys.ALTER_PARTITION_REASSIGNMENTS, ApiKeys.ALTER_REPLICA_LOG_DIRS, ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, ApiKeys.ALTER_PARTITION, ApiKeys.CREATE_ACLS, ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.CREATE_PARTITIONS, ApiKeys.CREATE_TOPICS, ApiKeys.DELETE_ACLS, ApiKeys.DELETE_CLUSTER_LINKS, ApiKeys.DELETE_GROUPS, ApiKeys.DELETE_SHARE_GROUP_STATE, ApiKeys.DELETE_RECORDS, ApiKeys.DELETE_TOPICS, ApiKeys.ELECT_LEADERS, ApiKeys.INCREMENTAL_ALTER_CONFIGS, ApiKeys.INITIATE_SHUTDOWN, ApiKeys.INITIALIZE_SHARE_GROUP_STATE, ApiKeys.OFFSET_DELETE, ApiKeys.REMOVE_BROKERS, ApiKeys.ALTER_BROKER_HEALTH, ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS, ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD, ApiKeys.DESCRIBE_CELL_LOAD, ApiKeys.CREATE_CELL, ApiKeys.ALTER_CELL, ApiKeys.DRAIN_CELL, ApiKeys.DELETE_CELL, ApiKeys.ASSIGN_BROKERS_TO_CELL, ApiKeys.UN_ASSIGN_BROKERS_FROM_CELL, ApiKeys.ASSIGN_TENANTS_TO_CELL, ApiKeys.DELETE_TENANTS, ApiKeys.DESCRIBE_CELLS, ApiKeys.DESCRIBE_TENANTS, ApiKeys.ALTER_CELL_MIGRATION, ApiKeys.DESCRIBE_CELL_MIGRATION, ApiKeys.DESCRIBE_NETWORK, ApiKeys.READ_SHARE_GROUP_STATE, ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY, ApiKeys.WRITE_SHARE_GROUP_STATE, ApiKeys.REMOVE_RAFT_VOTER, ApiKeys.REPORT_CLUSTER_LINK_STATUS, ApiKeys.UNREGISTER_BROKER, ApiKeys.ALTER_SHARE_GROUP_OFFSETS, ApiKeys.DELETE_SHARE_GROUP_OFFSETS, ApiKeys.UPDATE_FEATURES -> MANAGEMENT_CATEGORY;
                case ApiKeys.ADD_PARTITIONS_TO_TXN, ApiKeys.END_TXN, ApiKeys.INIT_PRODUCER_ID, ApiKeys.PRODUCE -> PRODUCE_CATEGORY;
                case ApiKeys.ADD_OFFSETS_TO_TXN, ApiKeys.JOIN_GROUP, ApiKeys.LEAVE_GROUP, ApiKeys.LIST_OFFSETS, ApiKeys.OFFSET_COMMIT, ApiKeys.OFFSET_FETCH, ApiKeys.SHARE_FETCH, ApiKeys.SHARE_ACKNOWLEDGE, ApiKeys.SYNC_GROUP, ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.RESOLVE_OFFSET_RANGE -> CONSUME_CATEGORY;
                case ApiKeys.CONTROLLED_SHUTDOWN, ApiKeys.LEADER_AND_ISR, ApiKeys.STOP_REPLICA, ApiKeys.UPDATE_METADATA, ApiKeys.ALLOCATE_PRODUCER_IDS, ApiKeys.WRITE_TXN_MARKERS, ApiKeys.REPORT_QUOTA_CONSUMPTION, ApiKeys.PUBLISH_QUOTA_TARGET, ApiKeys.APPEND_RECORDS, ApiKeys.ENVELOPE -> INTERBROKER_CATEGORY;
                case ApiKeys.INITIATE_REVERSE_CONNECTIONS, ApiKeys.REVERSE_CONNECTION -> INTERBROKER_CATEGORY;
                case ApiKeys.DESCRIBE_ACLS, ApiKeys.DESCRIBE_BROKER_REMOVALS, ApiKeys.DESCRIBE_BROKER_ADDITIONS, ApiKeys.DESCRIBE_BROKER_REPLICA_EXCLUSIONS, ApiKeys.DESCRIBE_BALANCER_STATUS, ApiKeys.DESCRIBE_EVEN_CLUSTER_LOAD_STATUS, ApiKeys.DESCRIBE_CLIENT_QUOTAS, ApiKeys.DESCRIBE_CONFIGS, ApiKeys.DESCRIBE_CLUSTER, ApiKeys.DESCRIBE_CLUSTER_LINKS, ApiKeys.DESCRIBE_GROUPS, ApiKeys.DESCRIBE_LOG_DIRS, ApiKeys.DESCRIBE_MIRRORS, ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS, ApiKeys.DESCRIBE_SWITCHOVER_STATUS, ApiKeys.DESCRIBE_TOPIC_PARTITIONS, ApiKeys.DESCRIBE_USER_SCRAM_CREDENTIALS, ApiKeys.DESCRIBE_QUORUM, ApiKeys.FIND_COORDINATOR, ApiKeys.LIST_CLUSTER_LINKS, ApiKeys.LIST_GROUPS, ApiKeys.LIST_MIRRORS, ApiKeys.LIST_PARTITION_REASSIGNMENTS, ApiKeys.METADATA, ApiKeys.OFFSET_FOR_LEADER_EPOCH, ApiKeys.DESCRIBE_PRODUCERS, ApiKeys.DESCRIBE_BROKER_HEALTH, ApiKeys.DESCRIBE_TRANSACTIONS, ApiKeys.LIST_TRANSACTIONS, ApiKeys.REPLICA_STATUS, ApiKeys.COMPUTE_EVEN_CLUSTER_LOAD_PLAN, ApiKeys.CONSUMER_GROUP_DESCRIBE, ApiKeys.SHARE_GROUP_DESCRIBE, ApiKeys.STREAMS_GROUP_DESCRIBE, ApiKeys.LIST_CONFIG_RESOURCES -> DESCRIBE_CATEGORY;
                case ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.SHARE_GROUP_HEARTBEAT, ApiKeys.STREAMS_GROUP_HEARTBEAT, ApiKeys.HEARTBEAT -> HEARTBEAT_CATEGORY;
                case ApiKeys.API_VERSIONS, ApiKeys.CREATE_DELEGATION_TOKEN, ApiKeys.DESCRIBE_DELEGATION_TOKEN, ApiKeys.EXPIRE_DELEGATION_TOKEN, ApiKeys.FETCH, ApiKeys.RENEW_DELEGATION_TOKEN, ApiKeys.SASL_AUTHENTICATE, ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS, ApiKeys.PUSH_TELEMETRY, ApiKeys.SASL_HANDSHAKE -> UNAUDITED;
                default -> {
                    UnsupportedOperationException e = new UnsupportedOperationException(apiKey.name);
                    log.error("BUG: AuditLogCategoryResultRouter needs to be updated!", (Throwable)e);
                    throw e;
                }
            }));
        }
        builder.put((Object)"kafka.Authentication", (Object)AUTHENTICATION_CATEGORY);
        for (RequestNameOverrides override : RequestNameOverrides.values()) {
            builder.put(AuditLogRouterUtils.entry(override));
        }
        METHOD_CATEGORIES = builder.build();
        CATEGORIES = new HashSet<String>(METHOD_CATEGORIES.values());
    }

    public static enum RequestNameOverrides {
        MDS_AUTHORIZE("mds", "Authorize", "authorize"),
        KAFKA_FETCH_CONSUMER("kafka", "FetchConsumer", "consume"),
        KAFKA_FETCH_FOLLOWER("kafka", "FetchFollower", "interbroker");

        public final String prefix;
        public final String name;
        public final String category;

        private RequestNameOverrides(String context, String name, String category) {
            this.prefix = context + ".";
            this.name = name;
            this.category = category;
        }
    }
}

