/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;

class ConnectorMetadata {
    private final String name;
    private final ConnectorType type;
    private final Map<String, String> maskedConfigs;
    private final ConnectorStateInfo connectorStateInfo;
    private final List<String> topics;
    private final String metadataKafkaClusterId;
    private final String dataKafkaClusterId;
    private final String connectClusterId;
    private final int tasksMax;
    private final String valueConverter;
    private final long epochMs;
    private final boolean isDeleted;

    ConnectorMetadata(String name, ConnectorType type, Map<String, String> maskedConfigs, ConnectorStateInfo connectorStateInfo, List<String> topics, String metadataKafkaClusterId, String dataKafkaClusterId, String connectClusterId, int tasksMax, String valueConverter, long epochMs, boolean isDeleted) {
        this.name = name;
        this.type = type;
        this.maskedConfigs = maskedConfigs;
        this.connectorStateInfo = connectorStateInfo;
        this.topics = topics;
        this.metadataKafkaClusterId = metadataKafkaClusterId;
        this.dataKafkaClusterId = dataKafkaClusterId;
        this.connectClusterId = connectClusterId;
        this.tasksMax = tasksMax;
        this.valueConverter = valueConverter;
        this.epochMs = epochMs;
        this.isDeleted = isDeleted;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.isDeleted() ? null : this.type.name();
    }

    public Map<String, String> configs() {
        return this.isDeleted() ? Collections.emptyMap() : this.maskedConfigs;
    }

    public ConnectorStateInfo.ConnectorState getConnectorState() {
        return this.isDeleted() ? null : this.connectorStateInfo.connector();
    }

    public String getConnectorErrorTrace() {
        return this.isDeleted() ? null : this.connectorStateInfo.connector().trace();
    }

    public List<ConnectorStateInfo.TaskState> getTaskStatuses() {
        return this.isDeleted() ? Collections.emptyList() : this.connectorStateInfo.tasks();
    }

    public String getTaskTrace(int taskId) {
        return this.isDeleted() ? null : this.connectorStateInfo.tasks().get(taskId).trace();
    }

    public String getClassName() {
        return this.isDeleted() ? null : this.maskedConfigs.get("connector.class");
    }

    public List<String> getTopics() {
        return this.isDeleted() ? Collections.emptyList() : this.topics;
    }

    public String getMetadataKafkaClusterId() {
        return this.metadataKafkaClusterId;
    }

    public String getDataKafkaClusterId() {
        return this.dataKafkaClusterId;
    }

    public String getConnectClusterId() {
        return this.connectClusterId;
    }

    public long getEpochMs() {
        return this.epochMs;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public int getTasksMax() {
        return this.tasksMax;
    }

    public String getValueConverter() {
        return this.valueConverter;
    }
}

