/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class EmitterConfig
extends AbstractConfig {
    public static final String PREFIX = "confluent.connect.metadata.events.";
    public static final String ENABLE_CONFIG = "enabled";
    public static final String ENABLE_DOC = "Enable the event emitter.";
    public static final boolean ENABLE_DEFAULT = false;
    public static final String MODE = "mode";
    public static final String MODE_DOC = "The mode of the event emitter. One of 'snapshot_only', 'incremental_only', or 'snapshot_and_incremental' (default).";
    public static final String MODE_DEFAULT = "snapshot_and_incremental";
    public static final String SNAPSHOT_INTERVAL = "snapshot.interval.seconds";
    public static final String SNAPSHOT_INTERVAL_DOC = "Interval between snapshot events in seconds.";
    public static final Integer SNAPSHOT_INTERVAL_DEFAULT = 300;
    public static final String EVENT_INTERVAL = "event.interval.seconds";
    public static final String EVENT_INTERVAL_DOC = "Minimum interval between events in seconds.";
    public static final Integer EVENT_INTERVAL_DEFAULT = 1;
    private static final ConfigDef BASE_EMITTER_CONFIG_DEF = new ConfigDef().define("enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Enable the event emitter.").define("snapshot.interval.seconds", ConfigDef.Type.LONG, (Object)SNAPSHOT_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, "Interval between snapshot events in seconds.").define("event.interval.seconds", ConfigDef.Type.LONG, (Object)EVENT_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, "Minimum interval between events in seconds.").define("mode", ConfigDef.Type.STRING, (Object)"snapshot_and_incremental", ConfigDef.Importance.HIGH, "The mode of the event emitter. One of 'snapshot_only', 'incremental_only', or 'snapshot_and_incremental' (default).");

    protected EmitterConfig(Map<String, ?> originals) {
        super(BASE_EMITTER_CONFIG_DEF, originals);
    }

    protected EmitterConfig(ConfigDef configDef, Map<String, ?> originals) {
        super(EmitterConfig.includeBaseConfigs(configDef), originals);
    }

    private static ConfigDef includeBaseConfigs(ConfigDef configDef) {
        for (String key : BASE_EMITTER_CONFIG_DEF.names()) {
            configDef.define((ConfigDef.ConfigKey)BASE_EMITTER_CONFIG_DEF.configKeys().get(key));
        }
        return configDef;
    }

    public boolean snapshotEnabled() {
        return EmitterMode.valueOf(this.getString(MODE).toUpperCase()).isSnapshotEnabled() && this.isEnabled();
    }

    public boolean incrementalEnabled() {
        return EmitterMode.valueOf(this.getString(MODE).toUpperCase()).isIncrementalEnabled() && this.isEnabled();
    }

    public Long snapshotInterval() {
        return this.getLong(SNAPSHOT_INTERVAL);
    }

    public Long eventInterval() {
        return this.getLong(EVENT_INTERVAL);
    }

    private boolean isEnabled() {
        return this.getBoolean(ENABLE_CONFIG);
    }

    public static enum EmitterMode {
        SNAPSHOT_ONLY,
        INCREMENTAL_ONLY,
        SNAPSHOT_AND_INCREMENTAL;


        boolean isSnapshotEnabled() {
            return this == SNAPSHOT_ONLY || this == SNAPSHOT_AND_INCREMENTAL;
        }

        boolean isIncrementalEnabled() {
            return this == INCREMENTAL_ONLY || this == SNAPSHOT_AND_INCREMENTAL;
        }
    }
}

