/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.runtime.isolation.PluginDiscoveryMode;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginScanner;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.ReflectionScanner;
import org.apache.kafka.connect.runtime.isolation.ServiceLoaderScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyLoadScanner
extends PluginScanner {
    private static final Logger log = LoggerFactory.getLogger(LazyLoadScanner.class);
    ConcurrentMap<String, PluginSource> lazyLoadPluginSources;
    PluginScanner parentScanner;

    public LazyLoadScanner(ConcurrentMap<String, PluginSource> lazyLoadPluginSources, PluginDiscoveryMode mode) {
        this.lazyLoadPluginSources = lazyLoadPluginSources;
        this.parentScanner = mode.reflectivelyScan() ? new ReflectionScanner() : new ServiceLoaderScanner();
    }

    public PluginScanResult discoverPlugins(String name) {
        PluginSource pluginSource = (PluginSource)this.lazyLoadPluginSources.get(name);
        if (pluginSource == null) {
            log.debug("Plugin {} not part of the lazyLoadManifest file", (Object)name);
            return new PluginScanResult(Collections.emptyList());
        }
        log.info("Lazy Loading the plugin {} and other packaged plugins from {}", (Object)name, (Object)pluginSource.location());
        return this.parentScanner.discoverPlugins(Collections.singleton(pluginSource));
    }

    public PluginSource pluginSource(String name) {
        return this.lazyLoadPluginSources.getOrDefault(name, null);
    }

    @Override
    protected PluginScanResult scanPlugins(PluginSource source) {
        return this.parentScanner.scanPlugins(source);
    }
}

