/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.keys.KeyAsyncClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.azure.security.keyvault.keys.implementation.models.KeyCreateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyImportParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.azure.security.keyvault.keys.implementation.models.KeyReleaseParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyRestoreParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyUpdateParameters;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Function;

@ServiceClient(builder=KeyClientBuilder.class, serviceInterfaces={KeyClientImpl.KeyClientService.class})
public final class KeyClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyClient.class);
    private final KeyClientImpl implClient;
    private final String vaultUrl;
    private final KeyServiceVersion serviceVersion;

    KeyClient(KeyClientImpl implClient, String vaultUrl, KeyServiceVersion serviceVersion) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
        this.serviceVersion = serviceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    public CryptographyClient getCryptographyClient(String keyName) {
        return this.getCryptographyClient(keyName, null);
    }

    public CryptographyClient getCryptographyClient(String keyName, String keyVersion) {
        return KeyVaultKeysUtils.getCryptographyClientBuilder(keyName, keyVersion, this.vaultUrl, this.getHttpPipeline(), this.serviceVersion).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(String name, KeyType keyType) {
        return (KeyVaultKey)this.createKeyWithResponse(new CreateKeyOptions(name, keyType), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(CreateKeyOptions createKeyOptions) {
        return (KeyVaultKey)this.createKeyWithResponse(createKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        if (createKeyOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'createKeyOptions' cannot be null."));
        }
        KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createKeyOptions.getKeyType()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createKeyOptions)).setKeyOps(createKeyOptions.getKeyOperations()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createKeyOptions.getReleasePolicy())).setTags(createKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createKeyOptions.getReleasePolicy()));
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(createKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), new RequestOptions().setContext(context)), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return (KeyVaultKey)this.createRsaKeyWithResponse(createRsaKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        if (createRsaKeyOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'createRsaKeyOptions' cannot be null."));
        }
        KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createRsaKeyOptions.getKeyType()).setKeySize(createRsaKeyOptions.getKeySize()).setPublicExponent(createRsaKeyOptions.getPublicExponent()).setKeyOps(createRsaKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createRsaKeyOptions)).setTags(createRsaKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createRsaKeyOptions.getReleasePolicy()));
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(createRsaKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), new RequestOptions().setContext(context)), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return (KeyVaultKey)this.createEcKeyWithResponse(createEcKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        if (createEcKeyOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'createEcKeyOptions' cannot be null."));
        }
        KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createEcKeyOptions.getKeyType()).setKeyOps(createEcKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createEcKeyOptions)).setTags(createEcKeyOptions.getTags()).setCurve(createEcKeyOptions.getCurveName()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createEcKeyOptions.getReleasePolicy()));
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(createEcKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), new RequestOptions().setContext(context)), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return (KeyVaultKey)this.createOctKeyWithResponse(createOctKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        if (createOctKeyOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'createOctKeyOptions' cannot be null."));
        }
        KeyCreateParameters keyCreateParameters = new KeyCreateParameters(createOctKeyOptions.getKeyType()).setKeySize(createOctKeyOptions.getKeySize()).setKeyOps(createOctKeyOptions.getKeyOperations()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(createOctKeyOptions)).setTags(createOctKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createOctKeyOptions.getReleasePolicy()));
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(createOctKeyOptions.getName(), BinaryData.fromObject((Object)keyCreateParameters), new RequestOptions().setContext(context)), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(String name, JsonWebKey keyMaterial) {
        return (KeyVaultKey)this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(ImportKeyOptions importKeyOptions) {
        return (KeyVaultKey)this.importKeyWithResponse(importKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        if (importKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new RuntimeException("'importKeyOptions' cannot be null."));
        }
        KeyImportParameters keyImportParameters = new KeyImportParameters(KeyVaultKeysModelsUtils.mapJsonWebKey(importKeyOptions.getKey())).setHsm(importKeyOptions.isHardwareProtected()).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(importKeyOptions)).setTags(importKeyOptions.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(importKeyOptions.getReleasePolicy()));
        Response<BinaryData> response = this.implClient.importKeyWithResponse(importKeyOptions.getName(), BinaryData.fromObject((Object)keyImportParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name, String version) {
        return (KeyVaultKey)this.getKeyWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(String name, String version, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.getKeyWithResponse(name, version, new RequestOptions().setContext(context)), KeyAsyncClient::mapGetKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name) {
        return (KeyVaultKey)this.getKeyWithResponse(name, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return (KeyVaultKey)this.updateKeyPropertiesWithResponse(keyProperties, Context.NONE, keyOperations).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        if (keyProperties == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'keyProperties' cannot be null."));
        }
        KeyUpdateParameters keyUpdateParameters = new KeyUpdateParameters().setKeyOps(keyOperations == null ? null : Arrays.asList(keyOperations)).setKeyAttributes(KeyVaultKeysModelsUtils.createKeyAttributes(keyProperties)).setTags(keyProperties.getTags()).setReleasePolicy(KeyVaultKeysModelsUtils.mapKeyReleasePolicy(keyProperties.getReleasePolicy()));
        Response<BinaryData> response = this.implClient.updateKeyWithResponse(keyProperties.getName(), keyProperties.getVersion(), BinaryData.fromObject((Object)keyUpdateParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedKey, Void> beginDeleteKey(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private Function<PollingContext<DeletedKey>, PollResponse<DeletedKey>> deleteActivationOperation(String name) {
        return pollingContext -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)this.implClient.deleteKeyWithResponse(name, KeyVaultKeysUtils.EMPTY_OPTIONS).getValue()).toObject(DeletedKeyBundle.class)));
    }

    private Function<PollingContext<DeletedKey>, PollResponse<DeletedKey>> deletePollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)this.implClient.getDeletedKeyWithResponse(name, KeyVaultKeysUtils.EMPTY_OPTIONS).getValue()).toObject(DeletedKeyBundle.class)));
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()));
            }
            catch (RuntimeException e) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKey getDeletedKey(String name) {
        return (DeletedKey)this.getDeletedKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKey> getDeletedKeyWithResponse(String name, Context context) {
        Response<BinaryData> response = this.implClient.getDeletedKeyWithResponse(name, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)((BinaryData)response.getValue()).toObject(DeletedKeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedKey(String name) {
        this.purgeDeletedKeyWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String name, Context context) {
        return this.implClient.purgeDeletedKeyWithResponse(name, new RequestOptions().setContext(context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private Function<PollingContext<KeyVaultKey>, PollResponse<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)this.implClient.recoverDeletedKeyWithResponse(name, KeyVaultKeysUtils.EMPTY_OPTIONS).getValue()).toObject(KeyBundle.class)));
    }

    private Function<PollingContext<KeyVaultKey>, PollResponse<KeyVaultKey>> recoverPollOperation(String keyName) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)this.implClient.getKeyWithResponse(keyName, null, KeyVaultKeysUtils.EMPTY_OPTIONS).getValue()).toObject(KeyBundle.class)));
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()));
            }
            catch (RuntimeException e) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupKey(String name) {
        return (byte[])this.backupKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupKeyWithResponse(String name, Context context) {
        Response<BinaryData> response = this.implClient.backupKeyWithResponse(name, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)((BackupKeyResult)((BinaryData)response.getValue()).toObject(BackupKeyResult.class)).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey restoreKeyBackup(byte[] backup) {
        return (KeyVaultKey)this.restoreKeyBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        KeyRestoreParameters keyRestoreParameters = new KeyRestoreParameters(backup);
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.restoreKeyWithResponse(BinaryData.fromObject((Object)keyRestoreParameters), new RequestOptions().setContext(context)), KeyAsyncClient::mapRestoreKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys() {
        return this.listPropertiesOfKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys(Context context) {
        return this.implClient.getKeys(new RequestOptions().setContext(context)).mapPage(binaryData -> KeyVaultKeysModelsUtils.createKeyProperties((KeyItem)binaryData.toObject(KeyItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys() {
        return this.listDeletedKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys(Context context) {
        return this.implClient.getDeletedKeys(new RequestOptions().setContext(context)).mapPage(binaryData -> KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyItem)binaryData.toObject(DeletedKeyItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name) {
        return this.listPropertiesOfKeyVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return this.implClient.getKeyVersions(name, new RequestOptions().setContext(context)).mapPage(binaryData -> KeyVaultKeysModelsUtils.createKeyProperties((KeyItem)binaryData.toObject(KeyItem.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] getRandomBytes(int count) {
        return (byte[])this.getRandomBytesWithResponse(count, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> getRandomBytesWithResponse(int count, Context context) {
        GetRandomBytesRequest getRandomBytesRequest = new GetRandomBytesRequest(count);
        Response<BinaryData> response = this.implClient.getRandomBytesWithResponse(BinaryData.fromObject((Object)getRandomBytesRequest), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)((RandomBytes)((BinaryData)response.getValue()).toObject(RandomBytes.class)).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String targetAttestationToken) {
        return (ReleaseKeyResult)this.releaseKeyWithResponse(name, null, targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String version, String targetAttestationToken) {
        return (ReleaseKeyResult)this.releaseKeyWithResponse(name, version, targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReleaseKeyResult> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name) || CoreUtils.isNullOrEmpty((CharSequence)targetAttestationToken)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' or 'targetAttestationToken' cannot be null or empty."));
        }
        String nonce = releaseKeyOptions == null ? null : releaseKeyOptions.getNonce();
        KeyExportEncryptionAlgorithm algorithm = releaseKeyOptions == null ? null : releaseKeyOptions.getAlgorithm();
        KeyReleaseParameters keyReleaseParameters = new KeyReleaseParameters(targetAttestationToken).setEnc(algorithm).setNonce(nonce);
        Response<BinaryData> response = this.implClient.releaseWithResponse(name, version, BinaryData.fromObject((Object)keyReleaseParameters), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)((ReleaseKeyResult)((BinaryData)response.getValue()).toObject(ReleaseKeyResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey rotateKey(String name) {
        return (KeyVaultKey)this.rotateKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> rotateKeyWithResponse(String name, Context context) {
        Response<BinaryData> response = this.implClient.rotateKeyWithResponse(name, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy getKeyRotationPolicy(String keyName) {
        return (KeyRotationPolicy)this.getKeyRotationPolicyWithResponse(keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String keyName, Context context) {
        Response<BinaryData> response = this.implClient.getKeyRotationPolicyWithResponse(keyName, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy updateKeyRotationPolicy(String keyName, KeyRotationPolicy keyRotationPolicy) {
        return (KeyRotationPolicy)this.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        Response<BinaryData> response = this.implClient.updateKeyRotationPolicyWithResponse(keyName, BinaryData.fromObject((Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicy(keyRotationPolicy)), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)((BinaryData)response.getValue()).toObject(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKeyAttestation(String name) {
        return (KeyVaultKey)this.getKeyAttestationWithResponse(name, "", Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyAttestationWithResponse(String name, String version, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.getKeyAttestationWithResponse(name, version, new RequestOptions().setContext(context)), KeyAsyncClient::mapGetKeyException);
        return new SimpleResponse(response, (Object)KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)((BinaryData)response.getValue()).toObject(KeyBundle.class)));
    }
}

