/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HighestOffsetCommitRateGroupsLogger
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HighestOffsetCommitRateGroupsLogger.class);
    private final GroupCoordinatorConfig config;
    private final Scheduler scheduler = new KafkaScheduler(1, true, "highest-offset-commit-rate-group-logger-", true);
    private final Map<String, AtomicLong> offsetCommitCounts = new ConcurrentHashMap<String, AtomicLong>();
    private final PriorityQueue<GroupIdAndRate> minHeap = new PriorityQueue((a, b) -> Double.compare(a.offsetCommitRate, b.offsetCommitRate));

    public HighestOffsetCommitRateGroupsLogger(GroupCoordinatorConfig config) {
        this.config = config;
        this.scheduler.startup();
        this.scheduler.schedule("log-highest-offset-commit-rates", () -> this.logHighestOffsetCommitRateGroups(config.groupHighestOffsetCommitRatesLogCount()), (long)config.groupHighestOffsetCommitRatesLogIntervalMs(), (long)config.groupHighestOffsetCommitRatesLogIntervalMs());
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (InterruptedException e) {
            log.debug("HighestOffsetCommitRateGroupsLogger.shutdown(): interrupted waiting for scheduler to shut down.");
        }
    }

    public void onOffsetCommit(String groupId) {
        this.offsetCommitCounts.computeIfAbsent(groupId, k -> new AtomicLong()).incrementAndGet();
    }

    public void onTransactionalOffsetCommit(String groupId) {
        this.offsetCommitCounts.computeIfAbsent(groupId, k -> new AtomicLong()).incrementAndGet();
    }

    private List<GroupIdAndRate> getHighestOffsetCommitRateGroups(int limit) {
        double elapsedTime = (double)this.config.groupHighestOffsetCommitRatesLogIntervalMs() / 1000.0;
        this.offsetCommitCounts.forEach((groupId, offsetCommitCount) -> {
            double offsetCommitRate = (double)offsetCommitCount.getAndSet(0L) / elapsedTime;
            if (offsetCommitRate <= 0.0) {
                this.offsetCommitCounts.remove(groupId);
                return;
            }
            if (this.minHeap.size() < limit || offsetCommitRate > this.minHeap.peek().offsetCommitRate) {
                this.minHeap.add(new GroupIdAndRate((String)groupId, offsetCommitRate));
            }
            if (this.minHeap.size() > limit) {
                this.minHeap.poll();
            }
        });
        ArrayList<GroupIdAndRate> groups = new ArrayList<GroupIdAndRate>(this.minHeap.size());
        while (!this.minHeap.isEmpty()) {
            groups.add(this.minHeap.poll());
        }
        return groups;
    }

    public String logHighestOffsetCommitRateGroups(int limit) {
        List<GroupIdAndRate> groups = this.getHighestOffsetCommitRateGroups(limit);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Top %d groups with highest offset commit rate:", groups.size()));
        for (int i = groups.size() - 1; i >= 0; --i) {
            GroupIdAndRate groupIdAndRate = groups.get(i);
            String groupId = groupIdAndRate.groupId;
            double offsetCommitRate = groupIdAndRate.offsetCommitRate;
            stringBuilder.append(String.format("\n  %8.2f/s %s", offsetCommitRate, groupId));
        }
        String logMessage = stringBuilder.toString();
        log.info(logMessage);
        return logMessage;
    }

    private static final class GroupIdAndRate {
        public final String groupId;
        public final double offsetCommitRate;

        public GroupIdAndRate(String groupId, double offsetCommitRate) {
            this.groupId = groupId;
            this.offsetCommitRate = offsetCommitRate;
        }
    }
}

