/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.crn;

import io.confluent.crn.CrnSyntaxException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentResourceName
implements Comparable<ConfluentResourceName> {
    private static final Logger log = LoggerFactory.getLogger(ConfluentResourceName.class);
    private static final String SCHEME = "crn";
    private static final String SCHEME_PART = "crn://";
    private static final String PATH_DELIMITER = "/";
    private static final String ELEMENT_JOINER = "=";
    private static final String WILDCARD_CHARACTER = "*";
    private static final Pattern RESOURCE_TYPE_PATTERN = Pattern.compile("[a-z0-9-]*");
    public static final String DEFAULT_AUTHORITY = "";
    private String authority;
    private List<Element> nameElements;
    private String stringForm;

    private ConfluentResourceName(String authority, List<Element> elements) {
        this(authority, elements, null);
    }

    private ConfluentResourceName(String authority, List<Element> elements, String stringForm) {
        this.authority = authority == null || authority.isEmpty() ? DEFAULT_AUTHORITY : authority;
        this.nameElements = Collections.unmodifiableList(elements);
        this.stringForm = stringForm;
    }

    public String authority() {
        return this.authority;
    }

    public List<Element> elements() {
        return Collections.unmodifiableList(this.nameElements);
    }

    public Element lastResourceElement() {
        List<Element> elements = this.elements();
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(elements.size() - 1);
    }

    public String resourceType() {
        return this.lastResourceElement().resourceType();
    }

    public boolean matches(ConfluentResourceName that) {
        if (!this.authority.isEmpty() && !this.authority.equals(that.authority)) {
            return false;
        }
        if (this.elements().size() != that.elements().size()) {
            return false;
        }
        for (int i = this.elements().size() - 1; i >= 0; --i) {
            if (this.elements().get(i).matches(that.elements().get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.stringForm == null) {
            this.stringForm = SCHEME_PART + this.authority + PATH_DELIMITER + this.nameElements.stream().map(Element::toString).collect(Collectors.joining(PATH_DELIMITER));
        }
        return this.stringForm;
    }

    @Override
    public int compareTo(ConfluentResourceName that) {
        if (!this.authority.equals(that.authority)) {
            return this.authority.compareTo(that.authority);
        }
        int shorter = Math.min(this.elements().size(), that.elements().size());
        for (int i = 0; i < shorter; ++i) {
            int elementComparison = this.elements().get(i).compareTo(that.elements().get(i));
            if (elementComparison == 0) continue;
            return elementComparison;
        }
        return this.elements().size() - that.elements().size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentResourceName that = (ConfluentResourceName)o;
        return Objects.equals(this.authority, that.authority) && Objects.equals(this.nameElements, that.nameElements);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.nameElements);
    }

    public ConfluentResourceName allWildcards() {
        Builder builder = ConfluentResourceName.newBuilder();
        builder.setAuthority(DEFAULT_AUTHORITY);
        try {
            for (Element e : this.nameElements) {
                builder.addElementWithWildcard(e.resourceType, DEFAULT_AUTHORITY);
            }
            return builder.build();
        }
        catch (CrnSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ConfluentResourceName fromString(String crn) throws CrnSyntaxException {
        if (!crn.startsWith(SCHEME_PART)) {
            throw new CrnSyntaxException(crn, "Scheme is not crn");
        }
        String rest = crn.substring(SCHEME_PART.length());
        String[] parts = rest.split(PATH_DELIMITER);
        Builder builder = ConfluentResourceName.newBuilder();
        builder.setStringForm(crn);
        builder.setAuthority(parts[0]);
        ArrayList<CrnSyntaxException> exceptions = new ArrayList<CrnSyntaxException>();
        List<Element> elements = Arrays.stream(parts).skip(1L).flatMap(element -> {
            String[] split = element.split(ELEMENT_JOINER);
            if (split.length != 2) {
                exceptions.add(new CrnSyntaxException(crn, "Invalid element: " + element));
                return Stream.empty();
            }
            try {
                return Stream.of(new Element(split[0], split[1]));
            }
            catch (CrnSyntaxException e) {
                exceptions.add(e);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (CrnSyntaxException)exceptions.get(0);
            }
            throw new CrnSyntaxException(crn, exceptions);
        }
        builder.addAllElements(elements);
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Element
    implements Comparable<Element> {
        private String resourceType;
        private String encodedResourceName;

        public Element(String resourceType, String encodedResourceName) throws CrnSyntaxException {
            if (resourceType.isEmpty()) {
                throw new CrnSyntaxException(resourceType, "resourceType cannot be empty");
            }
            Matcher matcher = RESOURCE_TYPE_PATTERN.matcher(resourceType);
            if (!matcher.matches()) {
                throw new CrnSyntaxException(resourceType, "resourceType may only contain lowercase ASCII letters and hyphen (a-z, -)");
            }
            this.resourceType = resourceType;
            this.encodedResourceName = encodedResourceName;
        }

        public String encodedResourceName() {
            return this.encodedResourceName;
        }

        public String resourceType() {
            return this.resourceType;
        }

        private boolean isPrefix() {
            return this.encodedResourceName.endsWith(ConfluentResourceName.WILDCARD_CHARACTER);
        }

        private String resourceNameWithoutWildcard() {
            if (this.isPrefix()) {
                return this.encodedResourceName.substring(0, this.encodedResourceName.length() - 1);
            }
            return this.encodedResourceName;
        }

        public boolean matches(Element that) {
            if (!this.resourceType.equals(that.resourceType)) {
                return false;
            }
            if (this.isPrefix()) {
                return that.encodedResourceName.startsWith(this.resourceNameWithoutWildcard());
            }
            return this.encodedResourceName.equals(that.encodedResourceName);
        }

        public String toString() {
            return this.resourceType + ConfluentResourceName.ELEMENT_JOINER + this.encodedResourceName;
        }

        @Override
        public int compareTo(Element that) {
            if (!this.resourceType.equals(that.resourceType)) {
                return this.resourceType.compareTo(that.resourceType);
            }
            int match = this.resourceNameWithoutWildcard().compareTo(that.resourceNameWithoutWildcard());
            if (match == 0) {
                if (this.isPrefix()) {
                    if (that.isPrefix()) {
                        return 0;
                    }
                    return -1;
                }
                if (that.isPrefix()) {
                    return 1;
                }
                return 0;
            }
            return match;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element that = (Element)o;
            return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.encodedResourceName, that.encodedResourceName);
        }

        public int hashCode() {
            return Objects.hash(this.resourceType, this.encodedResourceName);
        }
    }

    public static final class Builder {
        private String authority = null;
        private ArrayList<Element> elements = new ArrayList();
        private String stringForm = null;

        private Builder() {
        }

        public Builder setAuthority(String authority) {
            this.authority = authority;
            return this;
        }

        private void setStringForm(String stringForm) {
            this.stringForm = stringForm;
        }

        public Builder addElement(String resourceType, String unencodedResourceName) throws CrnSyntaxException {
            try {
                String encodedResourceName = URLEncoder.encode(unencodedResourceName, StandardCharsets.UTF_8.name()).replace(ConfluentResourceName.WILDCARD_CHARACTER, "%2A");
                this.elements.add(new Element(resourceType, encodedResourceName));
                return this;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder addElementWithWildcard(String resourceType, String unencodedResourceName) throws CrnSyntaxException {
            try {
                String encodedResourceName = URLEncoder.encode(unencodedResourceName, StandardCharsets.UTF_8.name()).replace(ConfluentResourceName.WILDCARD_CHARACTER, "%2A") + ConfluentResourceName.WILDCARD_CHARACTER;
                this.elements.add(new Element(resourceType, encodedResourceName));
                return this;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder addAllElements(List<Element> elements) {
            this.elements.addAll(elements);
            return this;
        }

        public ConfluentResourceName build() throws CrnSyntaxException {
            return new ConfluentResourceName(this.authority, this.elements, this.stringForm);
        }
    }
}

