/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.svid.x509svid.X509Svid;
import io.spiffe.svid.x509svid.X509SvidSource;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import lombok.NonNull;

public final class SpiffeKeyManager
extends X509ExtendedKeyManager {
    private final X509SvidSource x509SvidSource;

    public SpiffeKeyManager(@NonNull X509SvidSource x509SvidSource) {
        if (x509SvidSource == null) {
            throw new NullPointerException("x509SvidSource is marked non-null but is null");
        }
        this.x509SvidSource = x509SvidSource;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (!Objects.equals(alias, "spiffe")) {
            return new X509Certificate[0];
        }
        X509Svid x509Svid = this.x509SvidSource.getX509Svid();
        return x509Svid.getChainArray();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        if (!Objects.equals(alias, "spiffe")) {
            return null;
        }
        X509Svid x509Svid = this.x509SvidSource.getX509Svid();
        return x509Svid.getPrivateKey();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.getAlias(keyTypes);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        return this.getAlias(keyTypes);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        return this.getAlias(keyType);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.getAlias(keyType);
    }

    private String getAlias(String ... keyTypes) {
        X509Svid x509Svid = this.x509SvidSource.getX509Svid();
        String privateKeyAlgorithm = x509Svid.getPrivateKey().getAlgorithm();
        if (Arrays.asList(keyTypes).contains(privateKeyAlgorithm)) {
            return "spiffe";
        }
        return null;
    }

    private String[] getAliases(String keyType) {
        String alias = this.getAlias(keyType);
        return new String[]{alias};
    }
}

