/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class JacksonSerde {
    private static final Map<DataFormat, ObjectMapper> MAPPERS = new ConcurrentHashMap<DataFormat, ObjectMapper>();

    public static ObjectMapper jsonMapper() {
        return JacksonSerde.objectMapper(DataFormat.JSON);
    }

    public static ObjectMapper objectMapper(DataFormat dataFormat) {
        return JacksonSerde.mapper(dataFormat);
    }

    public static ObjectMapper mapper(DataFormat dataFormat) {
        return MAPPERS.computeIfAbsent(dataFormat, k -> JacksonSerde.configureObjectMapper(new ObjectMapper(dataFormat.factory())));
    }

    private static ObjectMapper configureObjectMapper(ObjectMapper objectMapper) {
        return objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).registerModule((Module)new Jdk8Module()).registerModule((Module)JacksonSerde.authenticationModule());
    }

    public static SimpleModule authenticationModule() {
        SimpleModule authenticationModule = new SimpleModule();
        authenticationModule.addSerializer(JsonWebKey.class, (JsonSerializer)new JwkJsonSerializer(JsonWebKey.class));
        authenticationModule.addDeserializer(JsonWebKey.class, (JsonDeserializer)new JwkJsonDeserializer(JsonWebKey.class));
        authenticationModule.addDeserializer(JsonWebKeySet.class, (JsonDeserializer)new JwksJsonDeserializer(JsonWebKeySet.class));
        return authenticationModule;
    }

    public static enum DataFormat {
        JSON(new JsonFactory()),
        YAML((JsonFactory)new YAMLFactory());

        private final JsonFactory factory;

        private DataFormat(JsonFactory factory) {
            this.factory = factory;
        }

        private JsonFactory factory() {
            return this.factory;
        }
    }

    public static class JwkJsonSerializer
    extends StdSerializer<JsonWebKey> {
        public JwkJsonSerializer(Class<JsonWebKey> t) {
            super(t);
        }

        public void serialize(JsonWebKey jsonWebKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)jsonWebKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC));
        }
    }

    public static class JwkJsonDeserializer
    extends StdDeserializer<JsonWebKey> {
        public JwkJsonDeserializer(Class<JsonWebKey> t) {
            super(t);
        }

        public JsonWebKey deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                Map params = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
                return JsonWebKey.Factory.newJwk((Map)params);
            }
            catch (JoseException e) {
                throw new JsonParseException(jsonParser, "Unable to parse Json Web Key", (Throwable)e);
            }
        }
    }

    public static class JwksJsonDeserializer
    extends StdDeserializer<JsonWebKeySet> {
        public JwksJsonDeserializer(Class<JsonWebKeySet> t) {
            super(t);
        }

        public JsonWebKeySet deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            jsonParser.nextValue();
            List jwks = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<JsonWebKey>>(){});
            return new JsonWebKeySet(jwks);
        }
    }
}

