/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.config.manipulation;

import io.confluent.connect.avro.AvroConverter;
import io.confluent.connect.json.JsonSchemaConverter;
import io.confluent.connect.protobuf.ProtobufConverter;
import io.confluent.connect.security.ConnectSecurityExtensionConfig;
import io.confluent.connect.security.config.manipulation.ConfigManipulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigValueInfo;
import org.apache.kafka.connect.storage.Converter;

public class RbacBasicCredentialsManipulator
implements ConfigManipulator {
    public static final String RBAC_GROUP = "RBAC";
    public static final String RBAC_USERNAME_CONFIG = "principal.service.name";
    public static final String RBAC_PASSWORD_CONFIG = "principal.service.password";
    public static final ConfigInfo RBAC_USERNAME_CONFIG_INFO = new ConfigInfo(new ConfigKeyInfo("principal.service.name", ConfigDef.Type.PASSWORD.name(), false, "[hidden]", ConfigDef.Importance.HIGH.name(), "The username of the principal for this connector", "RBAC", 0, ConfigDef.Width.NONE.name(), "Connector Username", Collections.emptyList()), new ConfigValueInfo("principal.service.name", "[hidden]", Collections.emptyList(), Collections.emptyList(), true));
    public static final ConfigInfo RBAC_PASSWORD_CONFIG_INFO = new ConfigInfo(new ConfigKeyInfo("principal.service.password", ConfigDef.Type.PASSWORD.name(), false, "[hidden]", ConfigDef.Importance.HIGH.name(), "The password of the principal for this connector", "RBAC", 0, ConfigDef.Width.NONE.name(), "Connector Password", Collections.emptyList()), new ConfigValueInfo("principal.service.password", "[hidden]", Collections.emptyList(), Collections.emptyList(), true));
    public static final Set<String> CONNECTOR_CLIENT_SASL_JAAS_CONFIGS = Stream.of("admin.override.", "consumer.override.", "producer.override.").map(prefix -> prefix + "sasl.jaas.config").collect(Collectors.toSet());
    private final ConnectSecurityExtensionConfig config;
    private final String metadataServerUrls;
    private final Map<String, String> srKeyConverterWorkerConfigs;
    private final Map<String, String> srValueConverterWorkerConfigs;

    public RbacBasicCredentialsManipulator(ConnectSecurityExtensionConfig config) {
        this.config = config;
        this.metadataServerUrls = config.metadataServerUrls();
        this.srKeyConverterWorkerConfigs = this.srConverterWorkerConfigs("key.converter");
        this.srValueConverterWorkerConfigs = this.srConverterWorkerConfigs("value.converter");
    }

    @Override
    public ConfigInfos transformConfigValidateResponse(ConfigInfos configInfos) {
        ConfigInfos result = RbacBasicCredentialsManipulator.mutableConfigInfosCopy(configInfos);
        result.groups().add(RBAC_GROUP);
        result.values().add(RBAC_USERNAME_CONFIG_INFO);
        result.values().add(RBAC_PASSWORD_CONFIG_INFO);
        return result;
    }

    @Override
    public Map<String, String> transformIncomingConnectorConfig(Map<String, String> connectorConfig) {
        String rbacUsername = connectorConfig.get(RBAC_USERNAME_CONFIG);
        String rbacPassword = connectorConfig.get(RBAC_PASSWORD_CONFIG);
        if (rbacUsername == null || rbacPassword == null) {
            return connectorConfig;
        }
        HashMap<String, String> result = new HashMap<String, String>(connectorConfig);
        this.addSaslJaasConfigs(rbacUsername, rbacPassword, result);
        RbacBasicCredentialsManipulator.maybeAddSrConverterCredentials("key.converter", rbacUsername, rbacPassword, result, this.srKeyConverterWorkerConfigs);
        RbacBasicCredentialsManipulator.maybeAddSrConverterCredentials("value.converter", rbacUsername, rbacPassword, result, this.srValueConverterWorkerConfigs);
        return result;
    }

    @Override
    public Map<String, String> transformOutgoingConnectorConfig(Map<String, String> connectorConfig) {
        if (!connectorConfig.containsKey(RBAC_USERNAME_CONFIG) || !connectorConfig.containsKey(RBAC_PASSWORD_CONFIG)) {
            return connectorConfig;
        }
        HashMap<String, String> newConfig = new HashMap<String, String>(connectorConfig);
        RbacBasicCredentialsManipulator.maybeStripSrConverterSecurityConfigs(newConfig);
        RbacBasicCredentialsManipulator.stripSaslJaasConfigs(newConfig);
        return newConfig;
    }

    private Map<String, String> srConverterWorkerConfigs(String converterType) {
        String configuredConverter = this.config.getString(converterType);
        if (RbacBasicCredentialsManipulator.isSrConverter(configuredConverter)) {
            HashMap<String, String> result = new HashMap<String, String>();
            this.config.originalsWithPrefix(converterType + ".", false).forEach((key, value) -> result.put((String)key, value.toString()));
            result.put(converterType, configuredConverter);
            RbacBasicCredentialsManipulator.stripSrConverterSecurityConfigs(result, converterType);
            return result;
        }
        return null;
    }

    static boolean isSrConverter(String converter) {
        return Stream.of(AvroConverter.class, JsonSchemaConverter.class, ProtobufConverter.class).anyMatch(converterClass -> RbacBasicCredentialsManipulator.isConverterClass(converter, converterClass));
    }

    private static boolean isConverterClass(String converter, Class<? extends Converter> converterClass) {
        String simpleClassName = converterClass.getSimpleName();
        return converterClass.getName().equals(converter) || simpleClassName.equals(converter) || simpleClassName.equals(converter + "Converter");
    }

    private void addSaslJaasConfigs(String username, String password, Map<String, String> connectorConfig) {
        String rbacSaslJaasConfig = this.rbacSaslJaasConfig(username, password);
        CONNECTOR_CLIENT_SASL_JAAS_CONFIGS.forEach(config -> connectorConfig.put((String)config, rbacSaslJaasConfig));
    }

    private static void maybeAddSrConverterCredentials(String converterType, String username, String password, Map<String, String> connectorConfig, Map<String, String> workerLevelSrConverterConfigs) {
        String converterClass = connectorConfig.get(converterType);
        if (RbacBasicCredentialsManipulator.isSrConverter(converterClass)) {
            RbacBasicCredentialsManipulator.stripSrConverterSecurityConfigs(connectorConfig, converterType);
        } else if (converterClass == null && workerLevelSrConverterConfigs != null) {
            connectorConfig.putAll(workerLevelSrConverterConfigs);
        } else {
            return;
        }
        connectorConfig.put(converterType + ".basic.auth.credentials.source", "USER_INFO");
        connectorConfig.put(converterType + ".basic.auth.user.info", username + ":" + password);
    }

    private static void maybeStripSrConverterSecurityConfigs(Map<String, String> connectorConfig) {
        Stream.of("key.converter", "value.converter").forEach(converterType -> {
            if (RbacBasicCredentialsManipulator.isSrConverter((String)connectorConfig.get(converterType))) {
                RbacBasicCredentialsManipulator.stripSrConverterSecurityConfigs(connectorConfig, converterType);
            }
        });
    }

    private static void stripSrConverterSecurityConfigs(Map<String, String> connectorConfig, String converterType) {
        Stream.of("basic.auth.credentials.source", "bearer.auth.credentials.source", "basic.auth.user.info").map(securityConfig -> converterType + "." + securityConfig).forEach(connectorConfig::remove);
    }

    private static void stripSaslJaasConfigs(Map<String, String> connectorConfig) {
        CONNECTOR_CLIENT_SASL_JAAS_CONFIGS.forEach(connectorConfig::remove);
    }

    private String rbacSaslJaasConfig(String username, String password) {
        return String.format("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required username=\"%s\" password=\"%s\" metadataServerUrls=\"%s\";", username, password, this.metadataServerUrls);
    }

    private static ConfigInfos mutableConfigInfosCopy(ConfigInfos configInfos) {
        return new ConfigInfos(configInfos.name(), configInfos.errorCount(), new ArrayList(configInfos.groups()), new ArrayList(configInfos.values()));
    }
}

