/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.permissions;

import io.confluent.common.security.util.StreamUtils;
import io.confluent.connect.security.permissions.entities.Permissions;
import io.confluent.connect.security.permissions.entities.PermittedOperations;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class PermissionsBuilder {
    private final LinkedHashMap<ResourceType, LinkedHashMap<String, List<Operation>>> permissionsRequests = new LinkedHashMap();
    private Scope scope = null;
    private KafkaPrincipal principal = null;
    private RestAuthorizer authorizer = null;

    public PermissionsBuilder withScope(Scope scope) {
        Objects.requireNonNull(scope, "Scope cannot be null");
        if (this.scope != null) {
            throw new IllegalStateException("A scope has already been specified");
        }
        this.scope = scope;
        return this;
    }

    public PermissionsBuilder withPrincipal(KafkaPrincipal principal) {
        Objects.requireNonNull(principal, "Principal cannot be null");
        if (this.principal != null) {
            throw new IllegalStateException("A principal has already been specified");
        }
        this.principal = principal;
        return this;
    }

    public PermissionsBuilder withAuthorizer(RestAuthorizer authorizer) {
        Objects.requireNonNull(authorizer, "Authorizer cannot be null");
        if (this.authorizer != null) {
            throw new IllegalStateException("An authorizer has already been specified");
        }
        this.authorizer = authorizer;
        return this;
    }

    public PermissionsBuilder withOperations(ResourceType resourceType, String resource, Collection<Operation> operations) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(resource, "Resource cannot be null");
        Objects.requireNonNull(operations, "List of operations cannot be null");
        operations.forEach(request -> Objects.requireNonNull(request, "Operations cannot be null"));
        this.permissionsRequests.computeIfAbsent(resourceType, k -> new LinkedHashMap()).computeIfAbsent(resource, k -> new ArrayList()).addAll(operations);
        return this;
    }

    public PermissionsBuilder withOperation(ResourceType resourceType, String resource, Operation operation) {
        return this.withOperations(resourceType, resource, Collections.singleton(operation));
    }

    public Permissions build() {
        if (this.scope == null) {
            throw new IllegalStateException("A scope must be provided before building permissions");
        }
        if (this.principal == null) {
            throw new IllegalStateException("A principal must be provided before building permissions");
        }
        if (this.authorizer == null) {
            throw new IllegalStateException("An authorizer must be provided before building permissions");
        }
        List actions = this.permissionsRequests.entrySet().stream().flatMap(resourceTypeEntry -> {
            ResourceType resourceType = (ResourceType)resourceTypeEntry.getKey();
            return ((LinkedHashMap)resourceTypeEntry.getValue()).entrySet().stream().flatMap(resourceEntry -> {
                String resourceName = (String)resourceEntry.getKey();
                return ((List)resourceEntry.getValue()).stream().map(operation -> new Action(this.scope, resourceType, resourceName, operation));
            });
        }).collect(Collectors.toList());
        if (actions.isEmpty()) {
            return new Permissions(Collections.emptyMap(), this.scope);
        }
        List authorizations = this.authorizer.authorize(this.principal, null, actions);
        Map<ResourceType, Map<String, PermittedOperations>> permissions = StreamUtils.zip((List)authorizations, actions).filter(entry -> AuthorizeResult.ALLOWED.equals(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.groupingBy(Action::resourceType, Collectors.groupingBy(Action::resourceName, Collectors.collectingAndThen(Collectors.mapping(action -> action.operation().toString(), Collectors.toSet()), PermittedOperations::new))));
        return new Permissions(permissions, this.scope);
    }
}

