/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.permissions;

import io.confluent.common.security.util.AuthorizerUtils;
import io.confluent.connect.security.permissions.PermissionsBuilder;
import io.confluent.connect.security.permissions.entities.Permissions;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.roledefinitions.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.security.Principal;
import java.util.Collection;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.connect.health.ConnectClusterState;

@Path(value="/permissions")
@Produces(value={"application/json"})
public class PermissionsResource {
    private final Scope scope;
    private final RestAuthorizer restAuthorizer;
    private final ConnectClusterState clusterState;

    public PermissionsResource(Scope scope, RestAuthorizer restAuthorizer, ConnectClusterState clusterState) {
        this.scope = scope;
        this.restAuthorizer = restAuthorizer;
        this.clusterState = clusterState;
    }

    @GET
    public Permissions getPermissions(@Context ContainerRequestContext requestContext) {
        KafkaPrincipal userPrincipal = AuthorizerUtils.kafkaPrincipalFor((Principal)requestContext.getSecurityContext().getUserPrincipal());
        PermissionsBuilder permissionsBuilder = new PermissionsBuilder().withScope(this.scope).withPrincipal(userPrincipal).withAuthorizer(this.restAuthorizer);
        this.clusterState.connectors().forEach(connector -> permissionsBuilder.withOperations(ConnectActions.CONNECTOR_RESOURCE, (String)connector, (Collection<Operation>)ConnectorOperations.ALL));
        return permissionsBuilder.build();
    }
}

