/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.permissions.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.Operation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PermittedOperations {
    @JsonProperty(value="permitted_operations")
    private Collection<String> permittedOperations;

    public PermittedOperations() {
    }

    public PermittedOperations(String ... permittedOperations) {
        this(Arrays.asList(permittedOperations));
    }

    public PermittedOperations(Collection<String> permittedOperations) {
        this.setPermittedOperations(permittedOperations);
    }

    public PermittedOperations(Operation ... permittedOperations) {
        this(Stream.of(permittedOperations).map(Operation::name).collect(Collectors.toList()));
    }

    public Collection<String> getPermittedOperations() {
        return this.permittedOperations;
    }

    public void setPermittedOperations(Collection<String> permittedOperations) {
        this.permittedOperations = permittedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermittedOperations that = (PermittedOperations)o;
        return Objects.equals(this.permittedOperations, that.permittedOperations);
    }

    public int hashCode() {
        return Objects.hash(this.permittedOperations);
    }

    public String toString() {
        return "PermittedOperations{permittedOperations=" + String.valueOf(this.permittedOperations) + "}";
    }
}

