/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.FlinkV3Deployment;
import io.confluent.flink.apiserver.client.model.FlinkV3DeploymentList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class FlinkV3Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FlinkV3Api() {
        this(Configuration.getDefaultApiClient());
    }

    public FlinkV3Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createFlinkV3DeploymentCall(String environment, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlinkV3DeploymentValidateBeforeCall(String environment, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createFlinkV3Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createFlinkV3Deployment(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling createFlinkV3Deployment(Async)");
        }
        return this.createFlinkV3DeploymentCall(environment, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment createFlinkV3Deployment(String environment, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.createFlinkV3DeploymentWithHttpInfo(environment, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> createFlinkV3DeploymentWithHttpInfo(String environment, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.createFlinkV3DeploymentValidateBeforeCall(environment, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlinkV3DeploymentAsync(String environment, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.createFlinkV3DeploymentValidateBeforeCall(environment, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFlinkV3DeploymentCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFlinkV3DeploymentValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteFlinkV3Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteFlinkV3Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteFlinkV3Deployment(Async)");
        }
        return this.deleteFlinkV3DeploymentCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public FlinkV3Deployment deleteFlinkV3Deployment(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.deleteFlinkV3DeploymentWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> deleteFlinkV3DeploymentWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteFlinkV3DeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteFlinkV3DeploymentAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.deleteFlinkV3DeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV3DeploymentsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV3DeploymentsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listFlinkV3Deployments(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV3Deployments(Async)");
        }
        return this.listFlinkV3DeploymentsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV3DeploymentList listFlinkV3Deployments(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV3DeploymentList> localVarResp = this.listFlinkV3DeploymentsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3DeploymentList> listFlinkV3DeploymentsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV3DeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV3DeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV3DeploymentsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV3DeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV3DeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3DeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFlinkV3DeploymentsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/deployments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFlinkV3DeploymentsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listFlinkV3DeploymentsForAllEnvironments(Async)");
        }
        return this.listFlinkV3DeploymentsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public FlinkV3DeploymentList listFlinkV3DeploymentsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<FlinkV3DeploymentList> localVarResp = this.listFlinkV3DeploymentsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3DeploymentList> listFlinkV3DeploymentsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listFlinkV3DeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<FlinkV3DeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFlinkV3DeploymentsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<FlinkV3DeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listFlinkV3DeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3DeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV3DeploymentCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV3DeploymentValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV3Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV3Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV3Deployment(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling patchFlinkV3Deployment(Async)");
        }
        return this.patchFlinkV3DeploymentCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment patchFlinkV3Deployment(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.patchFlinkV3DeploymentWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> patchFlinkV3DeploymentWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV3DeploymentAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV3DeploymentFinalizersCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV3DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV3DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV3DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV3DeploymentFinalizers(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling patchFlinkV3DeploymentFinalizers(Async)");
        }
        return this.patchFlinkV3DeploymentFinalizersCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment patchFlinkV3DeploymentFinalizers(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.patchFlinkV3DeploymentFinalizersWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> patchFlinkV3DeploymentFinalizersWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV3DeploymentFinalizersAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlinkV3DeploymentStatusCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlinkV3DeploymentStatusValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchFlinkV3DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchFlinkV3DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchFlinkV3DeploymentStatus(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling patchFlinkV3DeploymentStatus(Async)");
        }
        return this.patchFlinkV3DeploymentStatusCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment patchFlinkV3DeploymentStatus(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.patchFlinkV3DeploymentStatusWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> patchFlinkV3DeploymentStatusWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlinkV3DeploymentStatusAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.patchFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV3DeploymentCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV3DeploymentValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV3Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV3Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV3Deployment(Async)");
        }
        return this.readFlinkV3DeploymentCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV3Deployment readFlinkV3Deployment(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.readFlinkV3DeploymentWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> readFlinkV3DeploymentWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV3DeploymentAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV3DeploymentFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV3DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV3DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV3DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV3DeploymentFinalizers(Async)");
        }
        return this.readFlinkV3DeploymentFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV3Deployment readFlinkV3DeploymentFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.readFlinkV3DeploymentFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> readFlinkV3DeploymentFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV3DeploymentFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readFlinkV3DeploymentStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readFlinkV3DeploymentStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readFlinkV3DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readFlinkV3DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readFlinkV3DeploymentStatus(Async)");
        }
        return this.readFlinkV3DeploymentStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public FlinkV3Deployment readFlinkV3DeploymentStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.readFlinkV3DeploymentStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> readFlinkV3DeploymentStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readFlinkV3DeploymentStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.readFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV3DeploymentCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV3DeploymentValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV3Deployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV3Deployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV3Deployment(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling updateFlinkV3Deployment(Async)");
        }
        return this.updateFlinkV3DeploymentCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment updateFlinkV3Deployment(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.updateFlinkV3DeploymentWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> updateFlinkV3DeploymentWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV3DeploymentAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV3DeploymentFinalizersCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV3DeploymentFinalizersValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV3DeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV3DeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV3DeploymentFinalizers(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling updateFlinkV3DeploymentFinalizers(Async)");
        }
        return this.updateFlinkV3DeploymentFinalizersCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment updateFlinkV3DeploymentFinalizers(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.updateFlinkV3DeploymentFinalizersWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> updateFlinkV3DeploymentFinalizersWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV3DeploymentFinalizersAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentFinalizersValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlinkV3DeploymentStatusCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlinkV3Deployment localVarPostBody = flinkV3Deployment;
        String localVarPath = "/apis/flink/v3/orgs/{org}/environments/{environment}/deployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlinkV3DeploymentStatusValidateBeforeCall(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateFlinkV3DeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateFlinkV3DeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateFlinkV3DeploymentStatus(Async)");
        }
        if (flinkV3Deployment == null) {
            throw new ApiException("Missing the required parameter 'flinkV3Deployment' when calling updateFlinkV3DeploymentStatus(Async)");
        }
        return this.updateFlinkV3DeploymentStatusCall(environment, name, org, flinkV3Deployment, _callback);
    }

    public FlinkV3Deployment updateFlinkV3DeploymentStatus(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        ApiResponse<FlinkV3Deployment> localVarResp = this.updateFlinkV3DeploymentStatusWithHttpInfo(environment, name, org, flinkV3Deployment);
        return localVarResp.getData();
    }

    public ApiResponse<FlinkV3Deployment> updateFlinkV3DeploymentStatusWithHttpInfo(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, flinkV3Deployment, null);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlinkV3DeploymentStatusAsync(String environment, String name, String org, FlinkV3Deployment flinkV3Deployment, ApiCallback<FlinkV3Deployment> _callback) throws ApiException {
        Call localVarCall = this.updateFlinkV3DeploymentStatusValidateBeforeCall(environment, name, org, flinkV3Deployment, _callback);
        Type localVarReturnType = new TypeToken<FlinkV3Deployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

