/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.IamV1IdentityPool;
import io.confluent.flink.apiserver.client.model.IamV1IdentityPoolList;
import io.confluent.flink.apiserver.client.model.IamV1OrgMembership;
import io.confluent.flink.apiserver.client.model.IamV1OrgMembershipList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class IamV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IamV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public IamV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIamV1IdentityPoolCall(String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIamV1IdentityPoolValidateBeforeCall(String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createIamV1IdentityPool(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling createIamV1IdentityPool(Async)");
        }
        return this.createIamV1IdentityPoolCall(org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool createIamV1IdentityPool(String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.createIamV1IdentityPoolWithHttpInfo(org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> createIamV1IdentityPoolWithHttpInfo(String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.createIamV1IdentityPoolValidateBeforeCall(org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIamV1IdentityPoolAsync(String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.createIamV1IdentityPoolValidateBeforeCall(org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIamV1OrgMembershipCall(String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1OrgMembership localVarPostBody = iamV1OrgMembership;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIamV1OrgMembershipValidateBeforeCall(String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createIamV1OrgMembership(Async)");
        }
        if (iamV1OrgMembership == null) {
            throw new ApiException("Missing the required parameter 'iamV1OrgMembership' when calling createIamV1OrgMembership(Async)");
        }
        return this.createIamV1OrgMembershipCall(org, iamV1OrgMembership, _callback);
    }

    public IamV1OrgMembership createIamV1OrgMembership(String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.createIamV1OrgMembershipWithHttpInfo(org, iamV1OrgMembership);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> createIamV1OrgMembershipWithHttpInfo(String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        Call localVarCall = this.createIamV1OrgMembershipValidateBeforeCall(org, iamV1OrgMembership, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIamV1OrgMembershipAsync(String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.createIamV1OrgMembershipValidateBeforeCall(org, iamV1OrgMembership, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIamV1IdentityPoolCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIamV1IdentityPoolValidateBeforeCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteIamV1IdentityPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteIamV1IdentityPool(Async)");
        }
        return this.deleteIamV1IdentityPoolCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public IamV1IdentityPool deleteIamV1IdentityPool(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.deleteIamV1IdentityPoolWithHttpInfo(name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> deleteIamV1IdentityPoolWithHttpInfo(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteIamV1IdentityPoolValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteIamV1IdentityPoolAsync(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.deleteIamV1IdentityPoolValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIamV1OrgMembershipCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIamV1OrgMembershipValidateBeforeCall(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteIamV1OrgMembership(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteIamV1OrgMembership(Async)");
        }
        return this.deleteIamV1OrgMembershipCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public IamV1OrgMembership deleteIamV1OrgMembership(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.deleteIamV1OrgMembershipWithHttpInfo(name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> deleteIamV1OrgMembershipWithHttpInfo(String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteIamV1OrgMembershipValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteIamV1OrgMembershipAsync(String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.deleteIamV1OrgMembershipValidateBeforeCall(name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIamV1IdentityPoolsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIamV1IdentityPoolsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listIamV1IdentityPools(Async)");
        }
        return this.listIamV1IdentityPoolsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public IamV1IdentityPoolList listIamV1IdentityPools(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<IamV1IdentityPoolList> localVarResp = this.listIamV1IdentityPoolsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPoolList> listIamV1IdentityPoolsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listIamV1IdentityPoolsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIamV1IdentityPoolsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<IamV1IdentityPoolList> _callback) throws ApiException {
        Call localVarCall = this.listIamV1IdentityPoolsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIamV1IdentityPoolsForAllOrgsCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/identitypools";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIamV1IdentityPoolsForAllOrgsValidateBeforeCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        return this.listIamV1IdentityPoolsForAllOrgsCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public IamV1IdentityPoolList listIamV1IdentityPoolsForAllOrgs(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<IamV1IdentityPoolList> localVarResp = this.listIamV1IdentityPoolsForAllOrgsWithHttpInfo(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPoolList> listIamV1IdentityPoolsForAllOrgsWithHttpInfo(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listIamV1IdentityPoolsForAllOrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIamV1IdentityPoolsForAllOrgsAsync(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<IamV1IdentityPoolList> _callback) throws ApiException {
        Call localVarCall = this.listIamV1IdentityPoolsForAllOrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIamV1OrgMembershipsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIamV1OrgMembershipsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listIamV1OrgMemberships(Async)");
        }
        return this.listIamV1OrgMembershipsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public IamV1OrgMembershipList listIamV1OrgMemberships(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<IamV1OrgMembershipList> localVarResp = this.listIamV1OrgMembershipsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembershipList> listIamV1OrgMembershipsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listIamV1OrgMembershipsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembershipList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIamV1OrgMembershipsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<IamV1OrgMembershipList> _callback) throws ApiException {
        Call localVarCall = this.listIamV1OrgMembershipsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembershipList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIamV1OrgMembershipsForAllOrgsCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgmemberships";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIamV1OrgMembershipsForAllOrgsValidateBeforeCall(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        return this.listIamV1OrgMembershipsForAllOrgsCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public IamV1OrgMembershipList listIamV1OrgMembershipsForAllOrgs(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<IamV1OrgMembershipList> localVarResp = this.listIamV1OrgMembershipsForAllOrgsWithHttpInfo(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembershipList> listIamV1OrgMembershipsForAllOrgsWithHttpInfo(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listIamV1OrgMembershipsForAllOrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembershipList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIamV1OrgMembershipsForAllOrgsAsync(String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<IamV1OrgMembershipList> _callback) throws ApiException {
        Call localVarCall = this.listIamV1OrgMembershipsForAllOrgsValidateBeforeCall(_continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembershipList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIamV1IdentityPoolCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIamV1IdentityPoolValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIamV1IdentityPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchIamV1IdentityPool(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling patchIamV1IdentityPool(Async)");
        }
        return this.patchIamV1IdentityPoolCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool patchIamV1IdentityPool(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.patchIamV1IdentityPoolWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> patchIamV1IdentityPoolWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIamV1IdentityPoolAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIamV1IdentityPoolFinalizersCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIamV1IdentityPoolFinalizersValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIamV1IdentityPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchIamV1IdentityPoolFinalizers(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling patchIamV1IdentityPoolFinalizers(Async)");
        }
        return this.patchIamV1IdentityPoolFinalizersCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool patchIamV1IdentityPoolFinalizers(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.patchIamV1IdentityPoolFinalizersWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> patchIamV1IdentityPoolFinalizersWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIamV1IdentityPoolFinalizersAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIamV1IdentityPoolStatusCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIamV1IdentityPoolStatusValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIamV1IdentityPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchIamV1IdentityPoolStatus(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling patchIamV1IdentityPoolStatus(Async)");
        }
        return this.patchIamV1IdentityPoolStatusCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool patchIamV1IdentityPoolStatus(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.patchIamV1IdentityPoolStatusWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> patchIamV1IdentityPoolStatusWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolStatusValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIamV1IdentityPoolStatusAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.patchIamV1IdentityPoolStatusValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIamV1OrgMembershipCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1OrgMembership localVarPostBody = iamV1OrgMembership;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIamV1OrgMembershipValidateBeforeCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIamV1OrgMembership(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchIamV1OrgMembership(Async)");
        }
        if (iamV1OrgMembership == null) {
            throw new ApiException("Missing the required parameter 'iamV1OrgMembership' when calling patchIamV1OrgMembership(Async)");
        }
        return this.patchIamV1OrgMembershipCall(name, org, iamV1OrgMembership, _callback);
    }

    public IamV1OrgMembership patchIamV1OrgMembership(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.patchIamV1OrgMembershipWithHttpInfo(name, org, iamV1OrgMembership);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> patchIamV1OrgMembershipWithHttpInfo(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        Call localVarCall = this.patchIamV1OrgMembershipValidateBeforeCall(name, org, iamV1OrgMembership, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIamV1OrgMembershipAsync(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.patchIamV1OrgMembershipValidateBeforeCall(name, org, iamV1OrgMembership, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIamV1OrgMembershipFinalizersCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1OrgMembership localVarPostBody = iamV1OrgMembership;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIamV1OrgMembershipFinalizersValidateBeforeCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIamV1OrgMembershipFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchIamV1OrgMembershipFinalizers(Async)");
        }
        if (iamV1OrgMembership == null) {
            throw new ApiException("Missing the required parameter 'iamV1OrgMembership' when calling patchIamV1OrgMembershipFinalizers(Async)");
        }
        return this.patchIamV1OrgMembershipFinalizersCall(name, org, iamV1OrgMembership, _callback);
    }

    public IamV1OrgMembership patchIamV1OrgMembershipFinalizers(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.patchIamV1OrgMembershipFinalizersWithHttpInfo(name, org, iamV1OrgMembership);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> patchIamV1OrgMembershipFinalizersWithHttpInfo(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        Call localVarCall = this.patchIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, iamV1OrgMembership, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIamV1OrgMembershipFinalizersAsync(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.patchIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, iamV1OrgMembership, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIamV1IdentityPoolCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIamV1IdentityPoolValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIamV1IdentityPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readIamV1IdentityPool(Async)");
        }
        return this.readIamV1IdentityPoolCall(name, org, resourceVersion, _callback);
    }

    public IamV1IdentityPool readIamV1IdentityPool(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.readIamV1IdentityPoolWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> readIamV1IdentityPoolWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIamV1IdentityPoolAsync(String name, String org, String resourceVersion, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIamV1IdentityPoolFinalizersCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIamV1IdentityPoolFinalizersValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIamV1IdentityPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readIamV1IdentityPoolFinalizers(Async)");
        }
        return this.readIamV1IdentityPoolFinalizersCall(name, org, resourceVersion, _callback);
    }

    public IamV1IdentityPool readIamV1IdentityPoolFinalizers(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.readIamV1IdentityPoolFinalizersWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> readIamV1IdentityPoolFinalizersWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIamV1IdentityPoolFinalizersAsync(String name, String org, String resourceVersion, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIamV1IdentityPoolStatusCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIamV1IdentityPoolStatusValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIamV1IdentityPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readIamV1IdentityPoolStatus(Async)");
        }
        return this.readIamV1IdentityPoolStatusCall(name, org, resourceVersion, _callback);
    }

    public IamV1IdentityPool readIamV1IdentityPoolStatus(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.readIamV1IdentityPoolStatusWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> readIamV1IdentityPoolStatusWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolStatusValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIamV1IdentityPoolStatusAsync(String name, String org, String resourceVersion, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.readIamV1IdentityPoolStatusValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIamV1OrgMembershipCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIamV1OrgMembershipValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIamV1OrgMembership(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readIamV1OrgMembership(Async)");
        }
        return this.readIamV1OrgMembershipCall(name, org, resourceVersion, _callback);
    }

    public IamV1OrgMembership readIamV1OrgMembership(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.readIamV1OrgMembershipWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> readIamV1OrgMembershipWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readIamV1OrgMembershipValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIamV1OrgMembershipAsync(String name, String org, String resourceVersion, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.readIamV1OrgMembershipValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIamV1OrgMembershipFinalizersCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIamV1OrgMembershipFinalizersValidateBeforeCall(String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIamV1OrgMembershipFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readIamV1OrgMembershipFinalizers(Async)");
        }
        return this.readIamV1OrgMembershipFinalizersCall(name, org, resourceVersion, _callback);
    }

    public IamV1OrgMembership readIamV1OrgMembershipFinalizers(String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.readIamV1OrgMembershipFinalizersWithHttpInfo(name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> readIamV1OrgMembershipFinalizersWithHttpInfo(String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIamV1OrgMembershipFinalizersAsync(String name, String org, String resourceVersion, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.readIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIamV1IdentityPoolCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIamV1IdentityPoolValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateIamV1IdentityPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateIamV1IdentityPool(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling updateIamV1IdentityPool(Async)");
        }
        return this.updateIamV1IdentityPoolCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool updateIamV1IdentityPool(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.updateIamV1IdentityPoolWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> updateIamV1IdentityPoolWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIamV1IdentityPoolAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIamV1IdentityPoolFinalizersCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIamV1IdentityPoolFinalizersValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateIamV1IdentityPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateIamV1IdentityPoolFinalizers(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling updateIamV1IdentityPoolFinalizers(Async)");
        }
        return this.updateIamV1IdentityPoolFinalizersCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool updateIamV1IdentityPoolFinalizers(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.updateIamV1IdentityPoolFinalizersWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> updateIamV1IdentityPoolFinalizersWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIamV1IdentityPoolFinalizersAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolFinalizersValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIamV1IdentityPoolStatusCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1IdentityPool localVarPostBody = iamV1IdentityPool;
        String localVarPath = "/apis/iam/v1/orgs/{org}/identitypools/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIamV1IdentityPoolStatusValidateBeforeCall(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateIamV1IdentityPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateIamV1IdentityPoolStatus(Async)");
        }
        if (iamV1IdentityPool == null) {
            throw new ApiException("Missing the required parameter 'iamV1IdentityPool' when calling updateIamV1IdentityPoolStatus(Async)");
        }
        return this.updateIamV1IdentityPoolStatusCall(name, org, iamV1IdentityPool, _callback);
    }

    public IamV1IdentityPool updateIamV1IdentityPoolStatus(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        ApiResponse<IamV1IdentityPool> localVarResp = this.updateIamV1IdentityPoolStatusWithHttpInfo(name, org, iamV1IdentityPool);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1IdentityPool> updateIamV1IdentityPoolStatusWithHttpInfo(String name, String org, IamV1IdentityPool iamV1IdentityPool) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolStatusValidateBeforeCall(name, org, iamV1IdentityPool, null);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIamV1IdentityPoolStatusAsync(String name, String org, IamV1IdentityPool iamV1IdentityPool, ApiCallback<IamV1IdentityPool> _callback) throws ApiException {
        Call localVarCall = this.updateIamV1IdentityPoolStatusValidateBeforeCall(name, org, iamV1IdentityPool, _callback);
        Type localVarReturnType = new TypeToken<IamV1IdentityPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIamV1OrgMembershipCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1OrgMembership localVarPostBody = iamV1OrgMembership;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIamV1OrgMembershipValidateBeforeCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateIamV1OrgMembership(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateIamV1OrgMembership(Async)");
        }
        if (iamV1OrgMembership == null) {
            throw new ApiException("Missing the required parameter 'iamV1OrgMembership' when calling updateIamV1OrgMembership(Async)");
        }
        return this.updateIamV1OrgMembershipCall(name, org, iamV1OrgMembership, _callback);
    }

    public IamV1OrgMembership updateIamV1OrgMembership(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.updateIamV1OrgMembershipWithHttpInfo(name, org, iamV1OrgMembership);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> updateIamV1OrgMembershipWithHttpInfo(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        Call localVarCall = this.updateIamV1OrgMembershipValidateBeforeCall(name, org, iamV1OrgMembership, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIamV1OrgMembershipAsync(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.updateIamV1OrgMembershipValidateBeforeCall(name, org, iamV1OrgMembership, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIamV1OrgMembershipFinalizersCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IamV1OrgMembership localVarPostBody = iamV1OrgMembership;
        String localVarPath = "/apis/iam/v1/orgs/{org}/orgmemberships/{name}/finalizers".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIamV1OrgMembershipFinalizersValidateBeforeCall(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateIamV1OrgMembershipFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateIamV1OrgMembershipFinalizers(Async)");
        }
        if (iamV1OrgMembership == null) {
            throw new ApiException("Missing the required parameter 'iamV1OrgMembership' when calling updateIamV1OrgMembershipFinalizers(Async)");
        }
        return this.updateIamV1OrgMembershipFinalizersCall(name, org, iamV1OrgMembership, _callback);
    }

    public IamV1OrgMembership updateIamV1OrgMembershipFinalizers(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        ApiResponse<IamV1OrgMembership> localVarResp = this.updateIamV1OrgMembershipFinalizersWithHttpInfo(name, org, iamV1OrgMembership);
        return localVarResp.getData();
    }

    public ApiResponse<IamV1OrgMembership> updateIamV1OrgMembershipFinalizersWithHttpInfo(String name, String org, IamV1OrgMembership iamV1OrgMembership) throws ApiException {
        Call localVarCall = this.updateIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, iamV1OrgMembership, null);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIamV1OrgMembershipFinalizersAsync(String name, String org, IamV1OrgMembership iamV1OrgMembership, ApiCallback<IamV1OrgMembership> _callback) throws ApiException {
        Call localVarCall = this.updateIamV1OrgMembershipFinalizersValidateBeforeCall(name, org, iamV1OrgMembership, _callback);
        Type localVarReturnType = new TypeToken<IamV1OrgMembership>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

