/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.NetworkV1LogicalClusterSNIIngress;
import io.confluent.flink.apiserver.client.model.NetworkV1LogicalClusterSNIIngressList;
import io.confluent.flink.apiserver.client.model.NetworkV1NetworkDestination;
import io.confluent.flink.apiserver.client.model.NetworkV1NetworkDestinationList;
import io.confluent.flink.apiserver.client.model.NetworkV1SNIIngress;
import io.confluent.flink.apiserver.client.model.NetworkV1SNIIngressList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NetworkV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworkV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createNetworkV1LogicalClusterSNIIngressCall(String environment, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1LogicalClusterSNIIngress localVarPostBody = networkV1LogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNetworkV1LogicalClusterSNIIngressValidateBeforeCall(String environment, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (networkV1LogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1LogicalClusterSNIIngress' when calling createNetworkV1LogicalClusterSNIIngress(Async)");
        }
        return this.createNetworkV1LogicalClusterSNIIngressCall(environment, org, networkV1LogicalClusterSNIIngress, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress createNetworkV1LogicalClusterSNIIngress(String environment, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.createNetworkV1LogicalClusterSNIIngressWithHttpInfo(environment, org, networkV1LogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> createNetworkV1LogicalClusterSNIIngressWithHttpInfo(String environment, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.createNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, org, networkV1LogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNetworkV1LogicalClusterSNIIngressAsync(String environment, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.createNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, org, networkV1LogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNetworkV1NetworkDestinationCall(String environment, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNetworkV1NetworkDestinationValidateBeforeCall(String environment, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createNetworkV1NetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createNetworkV1NetworkDestination(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling createNetworkV1NetworkDestination(Async)");
        }
        return this.createNetworkV1NetworkDestinationCall(environment, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination createNetworkV1NetworkDestination(String environment, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.createNetworkV1NetworkDestinationWithHttpInfo(environment, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> createNetworkV1NetworkDestinationWithHttpInfo(String environment, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.createNetworkV1NetworkDestinationValidateBeforeCall(environment, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNetworkV1NetworkDestinationAsync(String environment, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.createNetworkV1NetworkDestinationValidateBeforeCall(environment, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNetworkV1SNIIngressCall(String environment, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1SNIIngress localVarPostBody = networkV1SNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNetworkV1SNIIngressValidateBeforeCall(String environment, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createNetworkV1SNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createNetworkV1SNIIngress(Async)");
        }
        if (networkV1SNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1SNIIngress' when calling createNetworkV1SNIIngress(Async)");
        }
        return this.createNetworkV1SNIIngressCall(environment, org, networkV1SNIIngress, _callback);
    }

    public NetworkV1SNIIngress createNetworkV1SNIIngress(String environment, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.createNetworkV1SNIIngressWithHttpInfo(environment, org, networkV1SNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> createNetworkV1SNIIngressWithHttpInfo(String environment, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        Call localVarCall = this.createNetworkV1SNIIngressValidateBeforeCall(environment, org, networkV1SNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNetworkV1SNIIngressAsync(String environment, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.createNetworkV1SNIIngressValidateBeforeCall(environment, org, networkV1SNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNetworkV1LogicalClusterSNIIngressCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNetworkV1LogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteNetworkV1LogicalClusterSNIIngress(Async)");
        }
        return this.deleteNetworkV1LogicalClusterSNIIngressCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress deleteNetworkV1LogicalClusterSNIIngress(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.deleteNetworkV1LogicalClusterSNIIngressWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> deleteNetworkV1LogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNetworkV1LogicalClusterSNIIngressAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.deleteNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNetworkV1NetworkDestinationCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNetworkV1NetworkDestinationValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteNetworkV1NetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNetworkV1NetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteNetworkV1NetworkDestination(Async)");
        }
        return this.deleteNetworkV1NetworkDestinationCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public NetworkV1NetworkDestination deleteNetworkV1NetworkDestination(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.deleteNetworkV1NetworkDestinationWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> deleteNetworkV1NetworkDestinationWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNetworkV1NetworkDestinationAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.deleteNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteNetworkV1SNIIngressCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNetworkV1SNIIngressValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteNetworkV1SNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNetworkV1SNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteNetworkV1SNIIngress(Async)");
        }
        return this.deleteNetworkV1SNIIngressCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public NetworkV1SNIIngress deleteNetworkV1SNIIngress(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.deleteNetworkV1SNIIngressWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> deleteNetworkV1SNIIngressWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteNetworkV1SNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteNetworkV1SNIIngressAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.deleteNetworkV1SNIIngressValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1LogicalClusterSNIIngresssCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1LogicalClusterSNIIngresssValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listNetworkV1LogicalClusterSNIIngresss(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1LogicalClusterSNIIngresss(Async)");
        }
        return this.listNetworkV1LogicalClusterSNIIngresssCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1LogicalClusterSNIIngressList listNetworkV1LogicalClusterSNIIngresss(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngressList> localVarResp = this.listNetworkV1LogicalClusterSNIIngresssWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngressList> listNetworkV1LogicalClusterSNIIngresssWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1LogicalClusterSNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1LogicalClusterSNIIngresssAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1LogicalClusterSNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1LogicalClusterSNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/logicalclustersniingresses".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1LogicalClusterSNIIngresssForAllEnvironments(Async)");
        }
        return this.listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1LogicalClusterSNIIngressList listNetworkV1LogicalClusterSNIIngresssForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngressList> localVarResp = this.listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngressList> listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1LogicalClusterSNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1LogicalClusterSNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1NetworkDestinationsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1NetworkDestinationsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listNetworkV1NetworkDestinations(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1NetworkDestinations(Async)");
        }
        return this.listNetworkV1NetworkDestinationsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1NetworkDestinationList listNetworkV1NetworkDestinations(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1NetworkDestinationList> localVarResp = this.listNetworkV1NetworkDestinationsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestinationList> listNetworkV1NetworkDestinationsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1NetworkDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1NetworkDestinationsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1NetworkDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1NetworkDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1NetworkDestinationsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/networkdestinations".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1NetworkDestinationsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1NetworkDestinationsForAllEnvironments(Async)");
        }
        return this.listNetworkV1NetworkDestinationsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1NetworkDestinationList listNetworkV1NetworkDestinationsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1NetworkDestinationList> localVarResp = this.listNetworkV1NetworkDestinationsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestinationList> listNetworkV1NetworkDestinationsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1NetworkDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1NetworkDestinationsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1NetworkDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1NetworkDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1SNIIngresssCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1SNIIngresssValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listNetworkV1SNIIngresss(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1SNIIngresss(Async)");
        }
        return this.listNetworkV1SNIIngresssCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1SNIIngressList listNetworkV1SNIIngresss(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1SNIIngressList> localVarResp = this.listNetworkV1SNIIngresssWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngressList> listNetworkV1SNIIngresssWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1SNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1SNIIngresssAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1SNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1SNIIngresssValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNetworkV1SNIIngresssForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/sniingresses".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNetworkV1SNIIngresssForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listNetworkV1SNIIngresssForAllEnvironments(Async)");
        }
        return this.listNetworkV1SNIIngresssForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public NetworkV1SNIIngressList listNetworkV1SNIIngresssForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<NetworkV1SNIIngressList> localVarResp = this.listNetworkV1SNIIngresssForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngressList> listNetworkV1SNIIngresssForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listNetworkV1SNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNetworkV1SNIIngresssForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<NetworkV1SNIIngressList> _callback) throws ApiException {
        Call localVarCall = this.listNetworkV1SNIIngresssForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1LogicalClusterSNIIngressCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1LogicalClusterSNIIngress localVarPostBody = networkV1LogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1LogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (networkV1LogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1LogicalClusterSNIIngress' when calling patchNetworkV1LogicalClusterSNIIngress(Async)");
        }
        return this.patchNetworkV1LogicalClusterSNIIngressCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress patchNetworkV1LogicalClusterSNIIngress(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.patchNetworkV1LogicalClusterSNIIngressWithHttpInfo(environment, name, org, networkV1LogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> patchNetworkV1LogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1LogicalClusterSNIIngressAsync(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1LogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1LogicalClusterSNIIngress localVarPostBody = networkV1LogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (networkV1LogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1LogicalClusterSNIIngress' when calling patchNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.patchNetworkV1LogicalClusterSNIIngressFinalizersCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress patchNetworkV1LogicalClusterSNIIngressFinalizers(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.patchNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1LogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> patchNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1LogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1NetworkDestinationCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1NetworkDestinationValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1NetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1NetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1NetworkDestination(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling patchNetworkV1NetworkDestination(Async)");
        }
        return this.patchNetworkV1NetworkDestinationCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination patchNetworkV1NetworkDestination(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.patchNetworkV1NetworkDestinationWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> patchNetworkV1NetworkDestinationWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1NetworkDestinationAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1NetworkDestinationFinalizersCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1NetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling patchNetworkV1NetworkDestinationFinalizers(Async)");
        }
        return this.patchNetworkV1NetworkDestinationFinalizersCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination patchNetworkV1NetworkDestinationFinalizers(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.patchNetworkV1NetworkDestinationFinalizersWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> patchNetworkV1NetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1NetworkDestinationFinalizersAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1NetworkDestinationStatusCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1NetworkDestinationStatusValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1NetworkDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1NetworkDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1NetworkDestinationStatus(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling patchNetworkV1NetworkDestinationStatus(Async)");
        }
        return this.patchNetworkV1NetworkDestinationStatusCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination patchNetworkV1NetworkDestinationStatus(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.patchNetworkV1NetworkDestinationStatusWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> patchNetworkV1NetworkDestinationStatusWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1NetworkDestinationStatusAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1SNIIngressCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1SNIIngress localVarPostBody = networkV1SNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1SNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1SNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1SNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1SNIIngress(Async)");
        }
        if (networkV1SNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1SNIIngress' when calling patchNetworkV1SNIIngress(Async)");
        }
        return this.patchNetworkV1SNIIngressCall(environment, name, org, networkV1SNIIngress, _callback);
    }

    public NetworkV1SNIIngress patchNetworkV1SNIIngress(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.patchNetworkV1SNIIngressWithHttpInfo(environment, name, org, networkV1SNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> patchNetworkV1SNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1SNIIngressValidateBeforeCall(environment, name, org, networkV1SNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1SNIIngressAsync(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1SNIIngressValidateBeforeCall(environment, name, org, networkV1SNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchNetworkV1SNIIngressFinalizersCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1SNIIngress localVarPostBody = networkV1SNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNetworkV1SNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchNetworkV1SNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNetworkV1SNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchNetworkV1SNIIngressFinalizers(Async)");
        }
        if (networkV1SNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1SNIIngress' when calling patchNetworkV1SNIIngressFinalizers(Async)");
        }
        return this.patchNetworkV1SNIIngressFinalizersCall(environment, name, org, networkV1SNIIngress, _callback);
    }

    public NetworkV1SNIIngress patchNetworkV1SNIIngressFinalizers(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.patchNetworkV1SNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1SNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> patchNetworkV1SNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        Call localVarCall = this.patchNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1SNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchNetworkV1SNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.patchNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1SNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1LogicalClusterSNIIngressCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1LogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1LogicalClusterSNIIngress(Async)");
        }
        return this.readNetworkV1LogicalClusterSNIIngressCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress readNetworkV1LogicalClusterSNIIngress(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.readNetworkV1LogicalClusterSNIIngressWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> readNetworkV1LogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1LogicalClusterSNIIngressAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1LogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.readNetworkV1LogicalClusterSNIIngressFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress readNetworkV1LogicalClusterSNIIngressFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.readNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> readNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1LogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1NetworkDestinationCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1NetworkDestinationValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1NetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1NetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1NetworkDestination(Async)");
        }
        return this.readNetworkV1NetworkDestinationCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1NetworkDestination readNetworkV1NetworkDestination(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.readNetworkV1NetworkDestinationWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> readNetworkV1NetworkDestinationWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1NetworkDestinationAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1NetworkDestinationFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1NetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1NetworkDestinationFinalizers(Async)");
        }
        return this.readNetworkV1NetworkDestinationFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1NetworkDestination readNetworkV1NetworkDestinationFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.readNetworkV1NetworkDestinationFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> readNetworkV1NetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1NetworkDestinationFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1NetworkDestinationStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1NetworkDestinationStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1NetworkDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1NetworkDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1NetworkDestinationStatus(Async)");
        }
        return this.readNetworkV1NetworkDestinationStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1NetworkDestination readNetworkV1NetworkDestinationStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.readNetworkV1NetworkDestinationStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> readNetworkV1NetworkDestinationStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1NetworkDestinationStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1SNIIngressCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1SNIIngressValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1SNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1SNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1SNIIngress(Async)");
        }
        return this.readNetworkV1SNIIngressCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1SNIIngress readNetworkV1SNIIngress(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.readNetworkV1SNIIngressWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> readNetworkV1SNIIngressWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1SNIIngressValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1SNIIngressAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1SNIIngressValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readNetworkV1SNIIngressFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNetworkV1SNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readNetworkV1SNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNetworkV1SNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readNetworkV1SNIIngressFinalizers(Async)");
        }
        return this.readNetworkV1SNIIngressFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public NetworkV1SNIIngress readNetworkV1SNIIngressFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.readNetworkV1SNIIngressFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> readNetworkV1SNIIngressFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readNetworkV1SNIIngressFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.readNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1LogicalClusterSNIIngressCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1LogicalClusterSNIIngress localVarPostBody = networkV1LogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1LogicalClusterSNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1LogicalClusterSNIIngress(Async)");
        }
        if (networkV1LogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1LogicalClusterSNIIngress' when calling updateNetworkV1LogicalClusterSNIIngress(Async)");
        }
        return this.updateNetworkV1LogicalClusterSNIIngressCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress updateNetworkV1LogicalClusterSNIIngress(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.updateNetworkV1LogicalClusterSNIIngressWithHttpInfo(environment, name, org, networkV1LogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> updateNetworkV1LogicalClusterSNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1LogicalClusterSNIIngressAsync(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1LogicalClusterSNIIngressValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1LogicalClusterSNIIngressFinalizersCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1LogicalClusterSNIIngress localVarPostBody = networkV1LogicalClusterSNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/logicalclustersniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        if (networkV1LogicalClusterSNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1LogicalClusterSNIIngress' when calling updateNetworkV1LogicalClusterSNIIngressFinalizers(Async)");
        }
        return this.updateNetworkV1LogicalClusterSNIIngressFinalizersCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
    }

    public NetworkV1LogicalClusterSNIIngress updateNetworkV1LogicalClusterSNIIngressFinalizers(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        ApiResponse<NetworkV1LogicalClusterSNIIngress> localVarResp = this.updateNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1LogicalClusterSNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1LogicalClusterSNIIngress> updateNetworkV1LogicalClusterSNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1LogicalClusterSNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1LogicalClusterSNIIngress networkV1LogicalClusterSNIIngress, ApiCallback<NetworkV1LogicalClusterSNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1LogicalClusterSNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1LogicalClusterSNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1LogicalClusterSNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1NetworkDestinationCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1NetworkDestinationValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1NetworkDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1NetworkDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1NetworkDestination(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling updateNetworkV1NetworkDestination(Async)");
        }
        return this.updateNetworkV1NetworkDestinationCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination updateNetworkV1NetworkDestination(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.updateNetworkV1NetworkDestinationWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> updateNetworkV1NetworkDestinationWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1NetworkDestinationAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1NetworkDestinationFinalizersCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1NetworkDestinationFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1NetworkDestinationFinalizers(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling updateNetworkV1NetworkDestinationFinalizers(Async)");
        }
        return this.updateNetworkV1NetworkDestinationFinalizersCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination updateNetworkV1NetworkDestinationFinalizers(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.updateNetworkV1NetworkDestinationFinalizersWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> updateNetworkV1NetworkDestinationFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1NetworkDestinationFinalizersAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationFinalizersValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1NetworkDestinationStatusCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1NetworkDestination localVarPostBody = networkV1NetworkDestination;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/networkdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1NetworkDestinationStatusValidateBeforeCall(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1NetworkDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1NetworkDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1NetworkDestinationStatus(Async)");
        }
        if (networkV1NetworkDestination == null) {
            throw new ApiException("Missing the required parameter 'networkV1NetworkDestination' when calling updateNetworkV1NetworkDestinationStatus(Async)");
        }
        return this.updateNetworkV1NetworkDestinationStatusCall(environment, name, org, networkV1NetworkDestination, _callback);
    }

    public NetworkV1NetworkDestination updateNetworkV1NetworkDestinationStatus(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        ApiResponse<NetworkV1NetworkDestination> localVarResp = this.updateNetworkV1NetworkDestinationStatusWithHttpInfo(environment, name, org, networkV1NetworkDestination);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1NetworkDestination> updateNetworkV1NetworkDestinationStatusWithHttpInfo(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, networkV1NetworkDestination, null);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1NetworkDestinationStatusAsync(String environment, String name, String org, NetworkV1NetworkDestination networkV1NetworkDestination, ApiCallback<NetworkV1NetworkDestination> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1NetworkDestinationStatusValidateBeforeCall(environment, name, org, networkV1NetworkDestination, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1NetworkDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1SNIIngressCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1SNIIngress localVarPostBody = networkV1SNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1SNIIngressValidateBeforeCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1SNIIngress(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1SNIIngress(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1SNIIngress(Async)");
        }
        if (networkV1SNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1SNIIngress' when calling updateNetworkV1SNIIngress(Async)");
        }
        return this.updateNetworkV1SNIIngressCall(environment, name, org, networkV1SNIIngress, _callback);
    }

    public NetworkV1SNIIngress updateNetworkV1SNIIngress(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.updateNetworkV1SNIIngressWithHttpInfo(environment, name, org, networkV1SNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> updateNetworkV1SNIIngressWithHttpInfo(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1SNIIngressValidateBeforeCall(environment, name, org, networkV1SNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1SNIIngressAsync(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1SNIIngressValidateBeforeCall(environment, name, org, networkV1SNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateNetworkV1SNIIngressFinalizersCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkV1SNIIngress localVarPostBody = networkV1SNIIngress;
        String localVarPath = "/apis/network/v1/orgs/{org}/environments/{environment}/sniingresses/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateNetworkV1SNIIngressFinalizersValidateBeforeCall(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateNetworkV1SNIIngressFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateNetworkV1SNIIngressFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateNetworkV1SNIIngressFinalizers(Async)");
        }
        if (networkV1SNIIngress == null) {
            throw new ApiException("Missing the required parameter 'networkV1SNIIngress' when calling updateNetworkV1SNIIngressFinalizers(Async)");
        }
        return this.updateNetworkV1SNIIngressFinalizersCall(environment, name, org, networkV1SNIIngress, _callback);
    }

    public NetworkV1SNIIngress updateNetworkV1SNIIngressFinalizers(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        ApiResponse<NetworkV1SNIIngress> localVarResp = this.updateNetworkV1SNIIngressFinalizersWithHttpInfo(environment, name, org, networkV1SNIIngress);
        return localVarResp.getData();
    }

    public ApiResponse<NetworkV1SNIIngress> updateNetworkV1SNIIngressFinalizersWithHttpInfo(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress) throws ApiException {
        Call localVarCall = this.updateNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1SNIIngress, null);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateNetworkV1SNIIngressFinalizersAsync(String environment, String name, String org, NetworkV1SNIIngress networkV1SNIIngress, ApiCallback<NetworkV1SNIIngress> _callback) throws ApiException {
        Call localVarCall = this.updateNetworkV1SNIIngressFinalizersValidateBeforeCall(environment, name, org, networkV1SNIIngress, _callback);
        Type localVarReturnType = new TypeToken<NetworkV1SNIIngress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

