/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.SqlV2Function;
import io.confluent.flink.apiserver.client.model.SqlV2FunctionList;
import io.confluent.flink.apiserver.client.model.SqlV2Model;
import io.confluent.flink.apiserver.client.model.SqlV2ModelList;
import io.confluent.flink.apiserver.client.model.SqlV2ModelRequest;
import io.confluent.flink.apiserver.client.model.SqlV2ModelRequestList;
import io.confluent.flink.apiserver.client.model.SqlV2SQLJob;
import io.confluent.flink.apiserver.client.model.SqlV2SQLJobList;
import io.confluent.flink.apiserver.client.model.SqlV2Statement;
import io.confluent.flink.apiserver.client.model.SqlV2StatementList;
import io.confluent.flink.apiserver.client.model.SqlV2TableRequest;
import io.confluent.flink.apiserver.client.model.SqlV2TableRequestList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SqlV2Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SqlV2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public SqlV2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSqlV2FunctionCall(String environment, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2FunctionValidateBeforeCall(String environment, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2Function(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2Function(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling createSqlV2Function(Async)");
        }
        return this.createSqlV2FunctionCall(environment, org, sqlV2Function, _callback);
    }

    public SqlV2Function createSqlV2Function(String environment, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.createSqlV2FunctionWithHttpInfo(environment, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> createSqlV2FunctionWithHttpInfo(String environment, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.createSqlV2FunctionValidateBeforeCall(environment, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2FunctionAsync(String environment, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2FunctionValidateBeforeCall(environment, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV2ModelCall(String environment, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2ModelValidateBeforeCall(String environment, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2Model(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2Model(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling createSqlV2Model(Async)");
        }
        return this.createSqlV2ModelCall(environment, org, sqlV2Model, _callback);
    }

    public SqlV2Model createSqlV2Model(String environment, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.createSqlV2ModelWithHttpInfo(environment, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> createSqlV2ModelWithHttpInfo(String environment, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.createSqlV2ModelValidateBeforeCall(environment, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2ModelAsync(String environment, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2ModelValidateBeforeCall(environment, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV2ModelRequestCall(String environment, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2ModelRequestValidateBeforeCall(String environment, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2ModelRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2ModelRequest(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling createSqlV2ModelRequest(Async)");
        }
        return this.createSqlV2ModelRequestCall(environment, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest createSqlV2ModelRequest(String environment, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.createSqlV2ModelRequestWithHttpInfo(environment, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> createSqlV2ModelRequestWithHttpInfo(String environment, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.createSqlV2ModelRequestValidateBeforeCall(environment, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2ModelRequestAsync(String environment, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2ModelRequestValidateBeforeCall(environment, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV2SQLJobCall(String environment, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2SQLJobValidateBeforeCall(String environment, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2SQLJob(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling createSqlV2SQLJob(Async)");
        }
        return this.createSqlV2SQLJobCall(environment, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob createSqlV2SQLJob(String environment, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.createSqlV2SQLJobWithHttpInfo(environment, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> createSqlV2SQLJobWithHttpInfo(String environment, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.createSqlV2SQLJobValidateBeforeCall(environment, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2SQLJobAsync(String environment, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2SQLJobValidateBeforeCall(environment, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV2StatementCall(String environment, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2StatementValidateBeforeCall(String environment, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2Statement(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling createSqlV2Statement(Async)");
        }
        return this.createSqlV2StatementCall(environment, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement createSqlV2Statement(String environment, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.createSqlV2StatementWithHttpInfo(environment, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> createSqlV2StatementWithHttpInfo(String environment, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.createSqlV2StatementValidateBeforeCall(environment, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2StatementAsync(String environment, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2StatementValidateBeforeCall(environment, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV2TableRequestCall(String environment, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV2TableRequestValidateBeforeCall(String environment, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV2TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV2TableRequest(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling createSqlV2TableRequest(Async)");
        }
        return this.createSqlV2TableRequestCall(environment, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest createSqlV2TableRequest(String environment, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.createSqlV2TableRequestWithHttpInfo(environment, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> createSqlV2TableRequestWithHttpInfo(String environment, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.createSqlV2TableRequestValidateBeforeCall(environment, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV2TableRequestAsync(String environment, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.createSqlV2TableRequestValidateBeforeCall(environment, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2FunctionCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2FunctionValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2Function(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2Function(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2Function(Async)");
        }
        return this.deleteSqlV2FunctionCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2Function deleteSqlV2Function(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.deleteSqlV2FunctionWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> deleteSqlV2FunctionWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2FunctionValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2FunctionAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2FunctionValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2ModelCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2ModelValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2Model(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2Model(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2Model(Async)");
        }
        return this.deleteSqlV2ModelCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2Model deleteSqlV2Model(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.deleteSqlV2ModelWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> deleteSqlV2ModelWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2ModelValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2ModelAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2ModelValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2ModelRequestCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2ModelRequestValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2ModelRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2ModelRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2ModelRequest(Async)");
        }
        return this.deleteSqlV2ModelRequestCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2ModelRequest deleteSqlV2ModelRequest(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.deleteSqlV2ModelRequestWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> deleteSqlV2ModelRequestWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2ModelRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2ModelRequestAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2ModelRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2SQLJobCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2SQLJobValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2SQLJob(Async)");
        }
        return this.deleteSqlV2SQLJobCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2SQLJob deleteSqlV2SQLJob(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.deleteSqlV2SQLJobWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> deleteSqlV2SQLJobWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2SQLJobAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2StatementCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2StatementValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2Statement(Async)");
        }
        return this.deleteSqlV2StatementCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2Statement deleteSqlV2Statement(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.deleteSqlV2StatementWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> deleteSqlV2StatementWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2StatementAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV2TableRequestCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV2TableRequestValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV2TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV2TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV2TableRequest(Async)");
        }
        return this.deleteSqlV2TableRequestCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV2TableRequest deleteSqlV2TableRequest(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.deleteSqlV2TableRequestWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> deleteSqlV2TableRequestWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV2TableRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV2TableRequestAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV2TableRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2FunctionsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2FunctionsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2Functions(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2Functions(Async)");
        }
        return this.listSqlV2FunctionsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2FunctionList listSqlV2Functions(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2FunctionList> localVarResp = this.listSqlV2FunctionsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2FunctionList> listSqlV2FunctionsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2FunctionsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2FunctionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2FunctionsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2FunctionList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2FunctionsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2FunctionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2FunctionsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/functions".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2FunctionsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2FunctionsForAllEnvironments(Async)");
        }
        return this.listSqlV2FunctionsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2FunctionList listSqlV2FunctionsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2FunctionList> localVarResp = this.listSqlV2FunctionsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2FunctionList> listSqlV2FunctionsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2FunctionsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2FunctionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2FunctionsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2FunctionList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2FunctionsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2FunctionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2ModelRequestsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2ModelRequestsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2ModelRequests(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2ModelRequests(Async)");
        }
        return this.listSqlV2ModelRequestsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2ModelRequestList listSqlV2ModelRequests(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2ModelRequestList> localVarResp = this.listSqlV2ModelRequestsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequestList> listSqlV2ModelRequestsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2ModelRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2ModelRequestsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2ModelRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2ModelRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2ModelRequestsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/modelrequests".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2ModelRequestsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2ModelRequestsForAllEnvironments(Async)");
        }
        return this.listSqlV2ModelRequestsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2ModelRequestList listSqlV2ModelRequestsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2ModelRequestList> localVarResp = this.listSqlV2ModelRequestsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequestList> listSqlV2ModelRequestsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2ModelRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2ModelRequestsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2ModelRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2ModelRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2ModelsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2ModelsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2Models(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2Models(Async)");
        }
        return this.listSqlV2ModelsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2ModelList listSqlV2Models(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2ModelList> localVarResp = this.listSqlV2ModelsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelList> listSqlV2ModelsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2ModelsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2ModelsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2ModelList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2ModelsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2ModelsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/models".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2ModelsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2ModelsForAllEnvironments(Async)");
        }
        return this.listSqlV2ModelsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2ModelList listSqlV2ModelsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2ModelList> localVarResp = this.listSqlV2ModelsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelList> listSqlV2ModelsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2ModelsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2ModelsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2ModelList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2ModelsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2SQLJobsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2SQLJobsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2SQLJobs(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2SQLJobs(Async)");
        }
        return this.listSqlV2SQLJobsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2SQLJobList listSqlV2SQLJobs(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2SQLJobList> localVarResp = this.listSqlV2SQLJobsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJobList> listSqlV2SQLJobsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2SQLJobsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2SQLJobsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/sqljobs".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2SQLJobsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2SQLJobsForAllEnvironments(Async)");
        }
        return this.listSqlV2SQLJobsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2SQLJobList listSqlV2SQLJobsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2SQLJobList> localVarResp = this.listSqlV2SQLJobsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJobList> listSqlV2SQLJobsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2SQLJobsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2StatementsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2StatementsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2Statements(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2Statements(Async)");
        }
        return this.listSqlV2StatementsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2StatementList listSqlV2Statements(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2StatementList> localVarResp = this.listSqlV2StatementsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2StatementList> listSqlV2StatementsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2StatementsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2StatementsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/statements".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2StatementsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2StatementsForAllEnvironments(Async)");
        }
        return this.listSqlV2StatementsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2StatementList listSqlV2StatementsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2StatementList> localVarResp = this.listSqlV2StatementsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2StatementList> listSqlV2StatementsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2StatementsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2TableRequestsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2TableRequestsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV2TableRequests(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2TableRequests(Async)");
        }
        return this.listSqlV2TableRequestsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2TableRequestList listSqlV2TableRequests(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2TableRequestList> localVarResp = this.listSqlV2TableRequestsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequestList> listSqlV2TableRequestsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2TableRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2TableRequestsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2TableRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2TableRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV2TableRequestsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/tablerequests".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV2TableRequestsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV2TableRequestsForAllEnvironments(Async)");
        }
        return this.listSqlV2TableRequestsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV2TableRequestList listSqlV2TableRequestsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV2TableRequestList> localVarResp = this.listSqlV2TableRequestsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequestList> listSqlV2TableRequestsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV2TableRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV2TableRequestsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV2TableRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV2TableRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2FunctionCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2FunctionValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2Function(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2Function(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2Function(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling patchSqlV2Function(Async)");
        }
        return this.patchSqlV2FunctionCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function patchSqlV2Function(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.patchSqlV2FunctionWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> patchSqlV2FunctionWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2FunctionAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2FunctionFinalizersCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2FunctionFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2FunctionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2FunctionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2FunctionFinalizers(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling patchSqlV2FunctionFinalizers(Async)");
        }
        return this.patchSqlV2FunctionFinalizersCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function patchSqlV2FunctionFinalizers(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.patchSqlV2FunctionFinalizersWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> patchSqlV2FunctionFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2FunctionFinalizersAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2FunctionStatusCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2FunctionStatusValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2FunctionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2FunctionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2FunctionStatus(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling patchSqlV2FunctionStatus(Async)");
        }
        return this.patchSqlV2FunctionStatusCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function patchSqlV2FunctionStatus(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.patchSqlV2FunctionStatusWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> patchSqlV2FunctionStatusWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionStatusValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2FunctionStatusAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2FunctionStatusValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2Model(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2Model(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2Model(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling patchSqlV2Model(Async)");
        }
        return this.patchSqlV2ModelCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model patchSqlV2Model(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.patchSqlV2ModelWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> patchSqlV2ModelWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelFinalizersCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2ModelFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2ModelFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2ModelFinalizers(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling patchSqlV2ModelFinalizers(Async)");
        }
        return this.patchSqlV2ModelFinalizersCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model patchSqlV2ModelFinalizers(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.patchSqlV2ModelFinalizersWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> patchSqlV2ModelFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelFinalizersAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelRequestCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelRequestValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2ModelRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2ModelRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2ModelRequest(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling patchSqlV2ModelRequest(Async)");
        }
        return this.patchSqlV2ModelRequestCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest patchSqlV2ModelRequest(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.patchSqlV2ModelRequestWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> patchSqlV2ModelRequestWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelRequestAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelRequestFinalizersCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2ModelRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2ModelRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2ModelRequestFinalizers(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling patchSqlV2ModelRequestFinalizers(Async)");
        }
        return this.patchSqlV2ModelRequestFinalizersCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest patchSqlV2ModelRequestFinalizers(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.patchSqlV2ModelRequestFinalizersWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> patchSqlV2ModelRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelRequestFinalizersAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelRequestStatusCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2ModelRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2ModelRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2ModelRequestStatus(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling patchSqlV2ModelRequestStatus(Async)");
        }
        return this.patchSqlV2ModelRequestStatusCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest patchSqlV2ModelRequestStatus(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.patchSqlV2ModelRequestStatusWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> patchSqlV2ModelRequestStatusWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelRequestStatusAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2ModelStatusCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2ModelStatusValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2ModelStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2ModelStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2ModelStatus(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling patchSqlV2ModelStatus(Async)");
        }
        return this.patchSqlV2ModelStatusCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model patchSqlV2ModelStatus(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.patchSqlV2ModelStatusWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> patchSqlV2ModelStatusWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelStatusValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2ModelStatusAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2ModelStatusValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2SQLJobCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2SQLJobValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2SQLJob(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling patchSqlV2SQLJob(Async)");
        }
        return this.patchSqlV2SQLJobCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob patchSqlV2SQLJob(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.patchSqlV2SQLJobWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> patchSqlV2SQLJobWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2SQLJobAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2SQLJobFinalizersCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2SQLJobFinalizers(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling patchSqlV2SQLJobFinalizers(Async)");
        }
        return this.patchSqlV2SQLJobFinalizersCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob patchSqlV2SQLJobFinalizers(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.patchSqlV2SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> patchSqlV2SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2SQLJobFinalizersAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2SQLJobStatusCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2SQLJobStatus(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling patchSqlV2SQLJobStatus(Async)");
        }
        return this.patchSqlV2SQLJobStatusCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob patchSqlV2SQLJobStatus(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.patchSqlV2SQLJobStatusWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> patchSqlV2SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2SQLJobStatusAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2StatementCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2StatementValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2Statement(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling patchSqlV2Statement(Async)");
        }
        return this.patchSqlV2StatementCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement patchSqlV2Statement(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.patchSqlV2StatementWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> patchSqlV2StatementWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2StatementAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2StatementFinalizersCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2StatementFinalizers(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling patchSqlV2StatementFinalizers(Async)");
        }
        return this.patchSqlV2StatementFinalizersCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement patchSqlV2StatementFinalizers(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.patchSqlV2StatementFinalizersWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> patchSqlV2StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2StatementFinalizersAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2StatementStatusCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2StatementStatus(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling patchSqlV2StatementStatus(Async)");
        }
        return this.patchSqlV2StatementStatusCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement patchSqlV2StatementStatus(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.patchSqlV2StatementStatusWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> patchSqlV2StatementStatusWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementStatusValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2StatementStatusAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2StatementStatusValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2TableRequestCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2TableRequestValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2TableRequest(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling patchSqlV2TableRequest(Async)");
        }
        return this.patchSqlV2TableRequestCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest patchSqlV2TableRequest(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.patchSqlV2TableRequestWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> patchSqlV2TableRequestWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2TableRequestAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2TableRequestFinalizersCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2TableRequestFinalizers(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling patchSqlV2TableRequestFinalizers(Async)");
        }
        return this.patchSqlV2TableRequestFinalizersCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest patchSqlV2TableRequestFinalizers(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.patchSqlV2TableRequestFinalizersWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> patchSqlV2TableRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2TableRequestFinalizersAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV2TableRequestStatusCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV2TableRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV2TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV2TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV2TableRequestStatus(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling patchSqlV2TableRequestStatus(Async)");
        }
        return this.patchSqlV2TableRequestStatusCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest patchSqlV2TableRequestStatus(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.patchSqlV2TableRequestStatusWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> patchSqlV2TableRequestStatusWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV2TableRequestStatusAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2FunctionCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2FunctionValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2Function(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2Function(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2Function(Async)");
        }
        return this.readSqlV2FunctionCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Function readSqlV2Function(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.readSqlV2FunctionWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> readSqlV2FunctionWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2FunctionAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2FunctionFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2FunctionFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2FunctionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2FunctionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2FunctionFinalizers(Async)");
        }
        return this.readSqlV2FunctionFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Function readSqlV2FunctionFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.readSqlV2FunctionFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> readSqlV2FunctionFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2FunctionFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2FunctionStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2FunctionStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2FunctionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2FunctionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2FunctionStatus(Async)");
        }
        return this.readSqlV2FunctionStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Function readSqlV2FunctionStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.readSqlV2FunctionStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> readSqlV2FunctionStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2FunctionStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2FunctionStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2Model(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2Model(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2Model(Async)");
        }
        return this.readSqlV2ModelCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Model readSqlV2Model(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.readSqlV2ModelWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> readSqlV2ModelWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2ModelFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2ModelFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2ModelFinalizers(Async)");
        }
        return this.readSqlV2ModelFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Model readSqlV2ModelFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.readSqlV2ModelFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> readSqlV2ModelFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelRequestCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelRequestValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2ModelRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2ModelRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2ModelRequest(Async)");
        }
        return this.readSqlV2ModelRequestCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2ModelRequest readSqlV2ModelRequest(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.readSqlV2ModelRequestWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> readSqlV2ModelRequestWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelRequestAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelRequestFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelRequestFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2ModelRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2ModelRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2ModelRequestFinalizers(Async)");
        }
        return this.readSqlV2ModelRequestFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2ModelRequest readSqlV2ModelRequestFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.readSqlV2ModelRequestFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> readSqlV2ModelRequestFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelRequestFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelRequestStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelRequestStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2ModelRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2ModelRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2ModelRequestStatus(Async)");
        }
        return this.readSqlV2ModelRequestStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2ModelRequest readSqlV2ModelRequestStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.readSqlV2ModelRequestStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> readSqlV2ModelRequestStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelRequestStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2ModelStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2ModelStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2ModelStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2ModelStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2ModelStatus(Async)");
        }
        return this.readSqlV2ModelStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Model readSqlV2ModelStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.readSqlV2ModelStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> readSqlV2ModelStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2ModelStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2ModelStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2ModelStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2SQLJobCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2SQLJobValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2SQLJob(Async)");
        }
        return this.readSqlV2SQLJobCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2SQLJob readSqlV2SQLJob(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.readSqlV2SQLJobWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> readSqlV2SQLJobWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2SQLJobAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2SQLJobFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2SQLJobFinalizers(Async)");
        }
        return this.readSqlV2SQLJobFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2SQLJob readSqlV2SQLJobFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.readSqlV2SQLJobFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> readSqlV2SQLJobFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2SQLJobFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2SQLJobStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2SQLJobStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2SQLJobStatus(Async)");
        }
        return this.readSqlV2SQLJobStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2SQLJob readSqlV2SQLJobStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.readSqlV2SQLJobStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> readSqlV2SQLJobStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2SQLJobStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2StatementCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2StatementValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2Statement(Async)");
        }
        return this.readSqlV2StatementCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Statement readSqlV2Statement(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.readSqlV2StatementWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> readSqlV2StatementWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2StatementValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2StatementAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2StatementValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2StatementFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2StatementFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2StatementFinalizers(Async)");
        }
        return this.readSqlV2StatementFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Statement readSqlV2StatementFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.readSqlV2StatementFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> readSqlV2StatementFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2StatementFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2StatementStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2StatementStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2StatementStatus(Async)");
        }
        return this.readSqlV2StatementStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2Statement readSqlV2StatementStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.readSqlV2StatementStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> readSqlV2StatementStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2StatementStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2TableRequestCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2TableRequestValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2TableRequest(Async)");
        }
        return this.readSqlV2TableRequestCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2TableRequest readSqlV2TableRequest(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.readSqlV2TableRequestWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> readSqlV2TableRequestWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2TableRequestAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2TableRequestFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2TableRequestFinalizers(Async)");
        }
        return this.readSqlV2TableRequestFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2TableRequest readSqlV2TableRequestFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.readSqlV2TableRequestFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> readSqlV2TableRequestFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2TableRequestFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV2TableRequestStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV2TableRequestStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV2TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV2TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV2TableRequestStatus(Async)");
        }
        return this.readSqlV2TableRequestStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV2TableRequest readSqlV2TableRequestStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.readSqlV2TableRequestStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> readSqlV2TableRequestStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV2TableRequestStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2FunctionCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2FunctionValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2Function(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2Function(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2Function(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling updateSqlV2Function(Async)");
        }
        return this.updateSqlV2FunctionCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function updateSqlV2Function(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.updateSqlV2FunctionWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> updateSqlV2FunctionWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2FunctionAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2FunctionFinalizersCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2FunctionFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2FunctionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2FunctionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2FunctionFinalizers(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling updateSqlV2FunctionFinalizers(Async)");
        }
        return this.updateSqlV2FunctionFinalizersCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function updateSqlV2FunctionFinalizers(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.updateSqlV2FunctionFinalizersWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> updateSqlV2FunctionFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2FunctionFinalizersAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionFinalizersValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2FunctionStatusCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Function localVarPostBody = sqlV2Function;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/functions/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2FunctionStatusValidateBeforeCall(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2FunctionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2FunctionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2FunctionStatus(Async)");
        }
        if (sqlV2Function == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Function' when calling updateSqlV2FunctionStatus(Async)");
        }
        return this.updateSqlV2FunctionStatusCall(environment, name, org, sqlV2Function, _callback);
    }

    public SqlV2Function updateSqlV2FunctionStatus(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        ApiResponse<SqlV2Function> localVarResp = this.updateSqlV2FunctionStatusWithHttpInfo(environment, name, org, sqlV2Function);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Function> updateSqlV2FunctionStatusWithHttpInfo(String environment, String name, String org, SqlV2Function sqlV2Function) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionStatusValidateBeforeCall(environment, name, org, sqlV2Function, null);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2FunctionStatusAsync(String environment, String name, String org, SqlV2Function sqlV2Function, ApiCallback<SqlV2Function> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2FunctionStatusValidateBeforeCall(environment, name, org, sqlV2Function, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Function>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2Model(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2Model(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2Model(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling updateSqlV2Model(Async)");
        }
        return this.updateSqlV2ModelCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model updateSqlV2Model(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.updateSqlV2ModelWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> updateSqlV2ModelWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelFinalizersCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2ModelFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2ModelFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2ModelFinalizers(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling updateSqlV2ModelFinalizers(Async)");
        }
        return this.updateSqlV2ModelFinalizersCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model updateSqlV2ModelFinalizers(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.updateSqlV2ModelFinalizersWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> updateSqlV2ModelFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelFinalizersAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelFinalizersValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelRequestCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelRequestValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2ModelRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2ModelRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2ModelRequest(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling updateSqlV2ModelRequest(Async)");
        }
        return this.updateSqlV2ModelRequestCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest updateSqlV2ModelRequest(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.updateSqlV2ModelRequestWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> updateSqlV2ModelRequestWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelRequestAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelRequestFinalizersCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2ModelRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2ModelRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2ModelRequestFinalizers(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling updateSqlV2ModelRequestFinalizers(Async)");
        }
        return this.updateSqlV2ModelRequestFinalizersCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest updateSqlV2ModelRequestFinalizers(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.updateSqlV2ModelRequestFinalizersWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> updateSqlV2ModelRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelRequestFinalizersAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelRequestStatusCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2ModelRequest localVarPostBody = sqlV2ModelRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/modelrequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2ModelRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2ModelRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2ModelRequestStatus(Async)");
        }
        if (sqlV2ModelRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2ModelRequest' when calling updateSqlV2ModelRequestStatus(Async)");
        }
        return this.updateSqlV2ModelRequestStatusCall(environment, name, org, sqlV2ModelRequest, _callback);
    }

    public SqlV2ModelRequest updateSqlV2ModelRequestStatus(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        ApiResponse<SqlV2ModelRequest> localVarResp = this.updateSqlV2ModelRequestStatusWithHttpInfo(environment, name, org, sqlV2ModelRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2ModelRequest> updateSqlV2ModelRequestStatusWithHttpInfo(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, sqlV2ModelRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelRequestStatusAsync(String environment, String name, String org, SqlV2ModelRequest sqlV2ModelRequest, ApiCallback<SqlV2ModelRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelRequestStatusValidateBeforeCall(environment, name, org, sqlV2ModelRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2ModelRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2ModelStatusCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Model localVarPostBody = sqlV2Model;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/models/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2ModelStatusValidateBeforeCall(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2ModelStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2ModelStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2ModelStatus(Async)");
        }
        if (sqlV2Model == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Model' when calling updateSqlV2ModelStatus(Async)");
        }
        return this.updateSqlV2ModelStatusCall(environment, name, org, sqlV2Model, _callback);
    }

    public SqlV2Model updateSqlV2ModelStatus(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        ApiResponse<SqlV2Model> localVarResp = this.updateSqlV2ModelStatusWithHttpInfo(environment, name, org, sqlV2Model);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Model> updateSqlV2ModelStatusWithHttpInfo(String environment, String name, String org, SqlV2Model sqlV2Model) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelStatusValidateBeforeCall(environment, name, org, sqlV2Model, null);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2ModelStatusAsync(String environment, String name, String org, SqlV2Model sqlV2Model, ApiCallback<SqlV2Model> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2ModelStatusValidateBeforeCall(environment, name, org, sqlV2Model, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Model>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2SQLJobCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2SQLJobValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2SQLJob(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling updateSqlV2SQLJob(Async)");
        }
        return this.updateSqlV2SQLJobCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob updateSqlV2SQLJob(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.updateSqlV2SQLJobWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> updateSqlV2SQLJobWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2SQLJobAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2SQLJobFinalizersCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2SQLJobFinalizers(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling updateSqlV2SQLJobFinalizers(Async)");
        }
        return this.updateSqlV2SQLJobFinalizersCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob updateSqlV2SQLJobFinalizers(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.updateSqlV2SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> updateSqlV2SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2SQLJobFinalizersAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2SQLJobStatusCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2SQLJob localVarPostBody = sqlV2SQLJob;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2SQLJobStatus(Async)");
        }
        if (sqlV2SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV2SQLJob' when calling updateSqlV2SQLJobStatus(Async)");
        }
        return this.updateSqlV2SQLJobStatusCall(environment, name, org, sqlV2SQLJob, _callback);
    }

    public SqlV2SQLJob updateSqlV2SQLJobStatus(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        ApiResponse<SqlV2SQLJob> localVarResp = this.updateSqlV2SQLJobStatusWithHttpInfo(environment, name, org, sqlV2SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2SQLJob> updateSqlV2SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, sqlV2SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2SQLJobStatusAsync(String environment, String name, String org, SqlV2SQLJob sqlV2SQLJob, ApiCallback<SqlV2SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2SQLJobStatusValidateBeforeCall(environment, name, org, sqlV2SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV2SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2StatementCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2StatementValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2Statement(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling updateSqlV2Statement(Async)");
        }
        return this.updateSqlV2StatementCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement updateSqlV2Statement(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.updateSqlV2StatementWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> updateSqlV2StatementWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2StatementAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2StatementFinalizersCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2StatementFinalizers(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling updateSqlV2StatementFinalizers(Async)");
        }
        return this.updateSqlV2StatementFinalizersCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement updateSqlV2StatementFinalizers(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.updateSqlV2StatementFinalizersWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> updateSqlV2StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2StatementFinalizersAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementFinalizersValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2StatementStatusCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2Statement localVarPostBody = sqlV2Statement;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2StatementStatus(Async)");
        }
        if (sqlV2Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV2Statement' when calling updateSqlV2StatementStatus(Async)");
        }
        return this.updateSqlV2StatementStatusCall(environment, name, org, sqlV2Statement, _callback);
    }

    public SqlV2Statement updateSqlV2StatementStatus(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        ApiResponse<SqlV2Statement> localVarResp = this.updateSqlV2StatementStatusWithHttpInfo(environment, name, org, sqlV2Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2Statement> updateSqlV2StatementStatusWithHttpInfo(String environment, String name, String org, SqlV2Statement sqlV2Statement) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementStatusValidateBeforeCall(environment, name, org, sqlV2Statement, null);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2StatementStatusAsync(String environment, String name, String org, SqlV2Statement sqlV2Statement, ApiCallback<SqlV2Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2StatementStatusValidateBeforeCall(environment, name, org, sqlV2Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV2Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2TableRequestCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2TableRequestValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2TableRequest(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling updateSqlV2TableRequest(Async)");
        }
        return this.updateSqlV2TableRequestCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest updateSqlV2TableRequest(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.updateSqlV2TableRequestWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> updateSqlV2TableRequestWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2TableRequestAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2TableRequestFinalizersCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2TableRequestFinalizers(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling updateSqlV2TableRequestFinalizers(Async)");
        }
        return this.updateSqlV2TableRequestFinalizersCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest updateSqlV2TableRequestFinalizers(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.updateSqlV2TableRequestFinalizersWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> updateSqlV2TableRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2TableRequestFinalizersAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV2TableRequestStatusCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV2TableRequest localVarPostBody = sqlV2TableRequest;
        String localVarPath = "/apis/sql/v2/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV2TableRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV2TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV2TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV2TableRequestStatus(Async)");
        }
        if (sqlV2TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV2TableRequest' when calling updateSqlV2TableRequestStatus(Async)");
        }
        return this.updateSqlV2TableRequestStatusCall(environment, name, org, sqlV2TableRequest, _callback);
    }

    public SqlV2TableRequest updateSqlV2TableRequestStatus(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        ApiResponse<SqlV2TableRequest> localVarResp = this.updateSqlV2TableRequestStatusWithHttpInfo(environment, name, org, sqlV2TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV2TableRequest> updateSqlV2TableRequestStatusWithHttpInfo(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, sqlV2TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV2TableRequestStatusAsync(String environment, String name, String org, SqlV2TableRequest sqlV2TableRequest, ApiCallback<SqlV2TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV2TableRequestStatusValidateBeforeCall(environment, name, org, sqlV2TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV2TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

