/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.SqlV3Connection;
import io.confluent.flink.apiserver.client.model.SqlV3ConnectionList;
import io.confluent.flink.apiserver.client.model.SqlV3SQLJob;
import io.confluent.flink.apiserver.client.model.SqlV3SQLJobList;
import io.confluent.flink.apiserver.client.model.SqlV3Statement;
import io.confluent.flink.apiserver.client.model.SqlV3StatementList;
import io.confluent.flink.apiserver.client.model.SqlV3TimeOrderedStatement;
import io.confluent.flink.apiserver.client.model.SqlV3TimeOrderedStatementList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SqlV3Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SqlV3Api() {
        this(Configuration.getDefaultApiClient());
    }

    public SqlV3Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSqlV3ConnectionCall(String environment, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV3ConnectionValidateBeforeCall(String environment, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV3Connection(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV3Connection(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling createSqlV3Connection(Async)");
        }
        return this.createSqlV3ConnectionCall(environment, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection createSqlV3Connection(String environment, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.createSqlV3ConnectionWithHttpInfo(environment, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> createSqlV3ConnectionWithHttpInfo(String environment, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.createSqlV3ConnectionValidateBeforeCall(environment, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV3ConnectionAsync(String environment, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.createSqlV3ConnectionValidateBeforeCall(environment, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV3SQLJobCall(String environment, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV3SQLJobValidateBeforeCall(String environment, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV3SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV3SQLJob(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling createSqlV3SQLJob(Async)");
        }
        return this.createSqlV3SQLJobCall(environment, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob createSqlV3SQLJob(String environment, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.createSqlV3SQLJobWithHttpInfo(environment, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> createSqlV3SQLJobWithHttpInfo(String environment, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.createSqlV3SQLJobValidateBeforeCall(environment, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV3SQLJobAsync(String environment, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.createSqlV3SQLJobValidateBeforeCall(environment, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV3StatementCall(String environment, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV3StatementValidateBeforeCall(String environment, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV3Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV3Statement(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling createSqlV3Statement(Async)");
        }
        return this.createSqlV3StatementCall(environment, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement createSqlV3Statement(String environment, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.createSqlV3StatementWithHttpInfo(environment, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> createSqlV3StatementWithHttpInfo(String environment, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.createSqlV3StatementValidateBeforeCall(environment, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV3StatementAsync(String environment, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.createSqlV3StatementValidateBeforeCall(environment, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV3TimeOrderedStatementCall(String environment, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV3TimeOrderedStatementValidateBeforeCall(String environment, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV3TimeOrderedStatement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV3TimeOrderedStatement(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling createSqlV3TimeOrderedStatement(Async)");
        }
        return this.createSqlV3TimeOrderedStatementCall(environment, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement createSqlV3TimeOrderedStatement(String environment, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.createSqlV3TimeOrderedStatementWithHttpInfo(environment, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> createSqlV3TimeOrderedStatementWithHttpInfo(String environment, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.createSqlV3TimeOrderedStatementValidateBeforeCall(environment, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV3TimeOrderedStatementAsync(String environment, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.createSqlV3TimeOrderedStatementValidateBeforeCall(environment, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV3ConnectionCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV3ConnectionValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV3Connection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV3Connection(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV3Connection(Async)");
        }
        return this.deleteSqlV3ConnectionCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV3Connection deleteSqlV3Connection(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.deleteSqlV3ConnectionWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> deleteSqlV3ConnectionWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV3ConnectionValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV3ConnectionAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV3ConnectionValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV3SQLJobCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV3SQLJobValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV3SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV3SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV3SQLJob(Async)");
        }
        return this.deleteSqlV3SQLJobCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV3SQLJob deleteSqlV3SQLJob(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.deleteSqlV3SQLJobWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> deleteSqlV3SQLJobWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV3SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV3SQLJobAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV3SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV3StatementCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV3StatementValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV3Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV3Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV3Statement(Async)");
        }
        return this.deleteSqlV3StatementCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV3Statement deleteSqlV3Statement(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.deleteSqlV3StatementWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> deleteSqlV3StatementWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV3StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV3StatementAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV3StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV3TimeOrderedStatementCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV3TimeOrderedStatementValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV3TimeOrderedStatement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV3TimeOrderedStatement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV3TimeOrderedStatement(Async)");
        }
        return this.deleteSqlV3TimeOrderedStatementCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV3TimeOrderedStatement deleteSqlV3TimeOrderedStatement(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.deleteSqlV3TimeOrderedStatementWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> deleteSqlV3TimeOrderedStatementWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV3TimeOrderedStatementAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3ConnectionsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3ConnectionsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV3Connections(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3Connections(Async)");
        }
        return this.listSqlV3ConnectionsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3ConnectionList listSqlV3Connections(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3ConnectionList> localVarResp = this.listSqlV3ConnectionsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3ConnectionList> listSqlV3ConnectionsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3ConnectionsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3ConnectionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3ConnectionsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3ConnectionList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3ConnectionsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3ConnectionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3ConnectionsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/connections".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3ConnectionsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3ConnectionsForAllEnvironments(Async)");
        }
        return this.listSqlV3ConnectionsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3ConnectionList listSqlV3ConnectionsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3ConnectionList> localVarResp = this.listSqlV3ConnectionsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3ConnectionList> listSqlV3ConnectionsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3ConnectionsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3ConnectionList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3ConnectionsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3ConnectionList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3ConnectionsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3ConnectionList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3SQLJobsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3SQLJobsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV3SQLJobs(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3SQLJobs(Async)");
        }
        return this.listSqlV3SQLJobsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3SQLJobList listSqlV3SQLJobs(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3SQLJobList> localVarResp = this.listSqlV3SQLJobsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJobList> listSqlV3SQLJobsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3SQLJobsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3SQLJobsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/sqljobs".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3SQLJobsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3SQLJobsForAllEnvironments(Async)");
        }
        return this.listSqlV3SQLJobsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3SQLJobList listSqlV3SQLJobsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3SQLJobList> localVarResp = this.listSqlV3SQLJobsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJobList> listSqlV3SQLJobsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3SQLJobsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3StatementsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3StatementsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV3Statements(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3Statements(Async)");
        }
        return this.listSqlV3StatementsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3StatementList listSqlV3Statements(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3StatementList> localVarResp = this.listSqlV3StatementsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3StatementList> listSqlV3StatementsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3StatementsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3StatementsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/statements".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3StatementsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3StatementsForAllEnvironments(Async)");
        }
        return this.listSqlV3StatementsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3StatementList listSqlV3StatementsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3StatementList> localVarResp = this.listSqlV3StatementsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3StatementList> listSqlV3StatementsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3StatementsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3TimeOrderedStatementsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3TimeOrderedStatementsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV3TimeOrderedStatements(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3TimeOrderedStatements(Async)");
        }
        return this.listSqlV3TimeOrderedStatementsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3TimeOrderedStatementList listSqlV3TimeOrderedStatements(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatementList> localVarResp = this.listSqlV3TimeOrderedStatementsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatementList> listSqlV3TimeOrderedStatementsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3TimeOrderedStatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3TimeOrderedStatementsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3TimeOrderedStatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3TimeOrderedStatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV3TimeOrderedStatementsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/timeorderedstatements".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV3TimeOrderedStatementsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV3TimeOrderedStatementsForAllEnvironments(Async)");
        }
        return this.listSqlV3TimeOrderedStatementsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV3TimeOrderedStatementList listSqlV3TimeOrderedStatementsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatementList> localVarResp = this.listSqlV3TimeOrderedStatementsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatementList> listSqlV3TimeOrderedStatementsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV3TimeOrderedStatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV3TimeOrderedStatementsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV3TimeOrderedStatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV3TimeOrderedStatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3ConnectionCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3ConnectionValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3Connection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3Connection(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3Connection(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling patchSqlV3Connection(Async)");
        }
        return this.patchSqlV3ConnectionCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection patchSqlV3Connection(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.patchSqlV3ConnectionWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> patchSqlV3ConnectionWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3ConnectionAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3ConnectionFinalizersCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3ConnectionFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3ConnectionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3ConnectionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3ConnectionFinalizers(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling patchSqlV3ConnectionFinalizers(Async)");
        }
        return this.patchSqlV3ConnectionFinalizersCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection patchSqlV3ConnectionFinalizers(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.patchSqlV3ConnectionFinalizersWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> patchSqlV3ConnectionFinalizersWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3ConnectionFinalizersAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3ConnectionStatusCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3ConnectionStatusValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3ConnectionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3ConnectionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3ConnectionStatus(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling patchSqlV3ConnectionStatus(Async)");
        }
        return this.patchSqlV3ConnectionStatusCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection patchSqlV3ConnectionStatus(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.patchSqlV3ConnectionStatusWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> patchSqlV3ConnectionStatusWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3ConnectionStatusAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3SQLJobCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3SQLJobValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3SQLJob(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling patchSqlV3SQLJob(Async)");
        }
        return this.patchSqlV3SQLJobCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob patchSqlV3SQLJob(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.patchSqlV3SQLJobWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> patchSqlV3SQLJobWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3SQLJobAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3SQLJobFinalizersCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3SQLJobFinalizers(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling patchSqlV3SQLJobFinalizers(Async)");
        }
        return this.patchSqlV3SQLJobFinalizersCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob patchSqlV3SQLJobFinalizers(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.patchSqlV3SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> patchSqlV3SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3SQLJobFinalizersAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3SQLJobStatusCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3SQLJobStatus(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling patchSqlV3SQLJobStatus(Async)");
        }
        return this.patchSqlV3SQLJobStatusCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob patchSqlV3SQLJobStatus(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.patchSqlV3SQLJobStatusWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> patchSqlV3SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3SQLJobStatusAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3StatementCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3StatementValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3Statement(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling patchSqlV3Statement(Async)");
        }
        return this.patchSqlV3StatementCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement patchSqlV3Statement(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.patchSqlV3StatementWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> patchSqlV3StatementWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3StatementAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3StatementFinalizersCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3StatementFinalizers(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling patchSqlV3StatementFinalizers(Async)");
        }
        return this.patchSqlV3StatementFinalizersCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement patchSqlV3StatementFinalizers(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.patchSqlV3StatementFinalizersWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> patchSqlV3StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3StatementFinalizersAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3StatementStatusCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3StatementStatus(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling patchSqlV3StatementStatus(Async)");
        }
        return this.patchSqlV3StatementStatusCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement patchSqlV3StatementStatus(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.patchSqlV3StatementStatusWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> patchSqlV3StatementStatusWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementStatusValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3StatementStatusAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3StatementStatusValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3TimeOrderedStatementCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3TimeOrderedStatementValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3TimeOrderedStatement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3TimeOrderedStatement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3TimeOrderedStatement(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling patchSqlV3TimeOrderedStatement(Async)");
        }
        return this.patchSqlV3TimeOrderedStatementCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement patchSqlV3TimeOrderedStatement(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.patchSqlV3TimeOrderedStatementWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> patchSqlV3TimeOrderedStatementWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3TimeOrderedStatementAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3TimeOrderedStatementFinalizersCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling patchSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        return this.patchSqlV3TimeOrderedStatementFinalizersCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement patchSqlV3TimeOrderedStatementFinalizers(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.patchSqlV3TimeOrderedStatementFinalizersWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> patchSqlV3TimeOrderedStatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3TimeOrderedStatementFinalizersAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV3TimeOrderedStatementStatusCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV3TimeOrderedStatementStatusValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling patchSqlV3TimeOrderedStatementStatus(Async)");
        }
        return this.patchSqlV3TimeOrderedStatementStatusCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement patchSqlV3TimeOrderedStatementStatus(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.patchSqlV3TimeOrderedStatementStatusWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> patchSqlV3TimeOrderedStatementStatusWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV3TimeOrderedStatementStatusAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3ConnectionCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3ConnectionValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3Connection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3Connection(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3Connection(Async)");
        }
        return this.readSqlV3ConnectionCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Connection readSqlV3Connection(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.readSqlV3ConnectionWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> readSqlV3ConnectionWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3ConnectionAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3ConnectionFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3ConnectionFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3ConnectionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3ConnectionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3ConnectionFinalizers(Async)");
        }
        return this.readSqlV3ConnectionFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Connection readSqlV3ConnectionFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.readSqlV3ConnectionFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> readSqlV3ConnectionFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3ConnectionFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3ConnectionStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3ConnectionStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3ConnectionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3ConnectionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3ConnectionStatus(Async)");
        }
        return this.readSqlV3ConnectionStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Connection readSqlV3ConnectionStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.readSqlV3ConnectionStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> readSqlV3ConnectionStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3ConnectionStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3SQLJobCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3SQLJobValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3SQLJob(Async)");
        }
        return this.readSqlV3SQLJobCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3SQLJob readSqlV3SQLJob(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.readSqlV3SQLJobWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> readSqlV3SQLJobWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3SQLJobAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3SQLJobFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3SQLJobFinalizers(Async)");
        }
        return this.readSqlV3SQLJobFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3SQLJob readSqlV3SQLJobFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.readSqlV3SQLJobFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> readSqlV3SQLJobFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3SQLJobFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3SQLJobStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3SQLJobStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3SQLJobStatus(Async)");
        }
        return this.readSqlV3SQLJobStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3SQLJob readSqlV3SQLJobStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.readSqlV3SQLJobStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> readSqlV3SQLJobStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3SQLJobStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3StatementCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3StatementValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3Statement(Async)");
        }
        return this.readSqlV3StatementCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Statement readSqlV3Statement(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.readSqlV3StatementWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> readSqlV3StatementWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3StatementValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3StatementAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3StatementValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3StatementFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3StatementFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3StatementFinalizers(Async)");
        }
        return this.readSqlV3StatementFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Statement readSqlV3StatementFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.readSqlV3StatementFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> readSqlV3StatementFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3StatementFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3StatementStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3StatementStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3StatementStatus(Async)");
        }
        return this.readSqlV3StatementStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3Statement readSqlV3StatementStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.readSqlV3StatementStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> readSqlV3StatementStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3StatementStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3TimeOrderedStatementCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3TimeOrderedStatementValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3TimeOrderedStatement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3TimeOrderedStatement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3TimeOrderedStatement(Async)");
        }
        return this.readSqlV3TimeOrderedStatementCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3TimeOrderedStatement readSqlV3TimeOrderedStatement(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.readSqlV3TimeOrderedStatementWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> readSqlV3TimeOrderedStatementWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3TimeOrderedStatementAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3TimeOrderedStatementFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        return this.readSqlV3TimeOrderedStatementFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3TimeOrderedStatement readSqlV3TimeOrderedStatementFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.readSqlV3TimeOrderedStatementFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> readSqlV3TimeOrderedStatementFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3TimeOrderedStatementFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV3TimeOrderedStatementStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV3TimeOrderedStatementStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV3TimeOrderedStatementStatus(Async)");
        }
        return this.readSqlV3TimeOrderedStatementStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV3TimeOrderedStatement readSqlV3TimeOrderedStatementStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.readSqlV3TimeOrderedStatementStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> readSqlV3TimeOrderedStatementStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV3TimeOrderedStatementStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3ConnectionCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3ConnectionValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3Connection(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3Connection(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3Connection(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling updateSqlV3Connection(Async)");
        }
        return this.updateSqlV3ConnectionCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection updateSqlV3Connection(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.updateSqlV3ConnectionWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> updateSqlV3ConnectionWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3ConnectionAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3ConnectionFinalizersCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3ConnectionFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3ConnectionFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3ConnectionFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3ConnectionFinalizers(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling updateSqlV3ConnectionFinalizers(Async)");
        }
        return this.updateSqlV3ConnectionFinalizersCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection updateSqlV3ConnectionFinalizers(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.updateSqlV3ConnectionFinalizersWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> updateSqlV3ConnectionFinalizersWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3ConnectionFinalizersAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionFinalizersValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3ConnectionStatusCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Connection localVarPostBody = sqlV3Connection;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/connections/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3ConnectionStatusValidateBeforeCall(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3ConnectionStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3ConnectionStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3ConnectionStatus(Async)");
        }
        if (sqlV3Connection == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Connection' when calling updateSqlV3ConnectionStatus(Async)");
        }
        return this.updateSqlV3ConnectionStatusCall(environment, name, org, sqlV3Connection, _callback);
    }

    public SqlV3Connection updateSqlV3ConnectionStatus(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        ApiResponse<SqlV3Connection> localVarResp = this.updateSqlV3ConnectionStatusWithHttpInfo(environment, name, org, sqlV3Connection);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Connection> updateSqlV3ConnectionStatusWithHttpInfo(String environment, String name, String org, SqlV3Connection sqlV3Connection) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, sqlV3Connection, null);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3ConnectionStatusAsync(String environment, String name, String org, SqlV3Connection sqlV3Connection, ApiCallback<SqlV3Connection> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3ConnectionStatusValidateBeforeCall(environment, name, org, sqlV3Connection, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Connection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3SQLJobCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3SQLJobValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3SQLJob(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling updateSqlV3SQLJob(Async)");
        }
        return this.updateSqlV3SQLJobCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob updateSqlV3SQLJob(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.updateSqlV3SQLJobWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> updateSqlV3SQLJobWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3SQLJobAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3SQLJobFinalizersCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3SQLJobFinalizers(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling updateSqlV3SQLJobFinalizers(Async)");
        }
        return this.updateSqlV3SQLJobFinalizersCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob updateSqlV3SQLJobFinalizers(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.updateSqlV3SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> updateSqlV3SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3SQLJobFinalizersAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3SQLJobStatusCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3SQLJob localVarPostBody = sqlV3SQLJob;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3SQLJobStatus(Async)");
        }
        if (sqlV3SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV3SQLJob' when calling updateSqlV3SQLJobStatus(Async)");
        }
        return this.updateSqlV3SQLJobStatusCall(environment, name, org, sqlV3SQLJob, _callback);
    }

    public SqlV3SQLJob updateSqlV3SQLJobStatus(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        ApiResponse<SqlV3SQLJob> localVarResp = this.updateSqlV3SQLJobStatusWithHttpInfo(environment, name, org, sqlV3SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3SQLJob> updateSqlV3SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, sqlV3SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3SQLJobStatusAsync(String environment, String name, String org, SqlV3SQLJob sqlV3SQLJob, ApiCallback<SqlV3SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3SQLJobStatusValidateBeforeCall(environment, name, org, sqlV3SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV3SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3StatementCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3StatementValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3Statement(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling updateSqlV3Statement(Async)");
        }
        return this.updateSqlV3StatementCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement updateSqlV3Statement(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.updateSqlV3StatementWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> updateSqlV3StatementWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3StatementAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3StatementFinalizersCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3StatementFinalizers(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling updateSqlV3StatementFinalizers(Async)");
        }
        return this.updateSqlV3StatementFinalizersCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement updateSqlV3StatementFinalizers(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.updateSqlV3StatementFinalizersWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> updateSqlV3StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3StatementFinalizersAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementFinalizersValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3StatementStatusCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3Statement localVarPostBody = sqlV3Statement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3StatementStatus(Async)");
        }
        if (sqlV3Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3Statement' when calling updateSqlV3StatementStatus(Async)");
        }
        return this.updateSqlV3StatementStatusCall(environment, name, org, sqlV3Statement, _callback);
    }

    public SqlV3Statement updateSqlV3StatementStatus(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        ApiResponse<SqlV3Statement> localVarResp = this.updateSqlV3StatementStatusWithHttpInfo(environment, name, org, sqlV3Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3Statement> updateSqlV3StatementStatusWithHttpInfo(String environment, String name, String org, SqlV3Statement sqlV3Statement) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementStatusValidateBeforeCall(environment, name, org, sqlV3Statement, null);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3StatementStatusAsync(String environment, String name, String org, SqlV3Statement sqlV3Statement, ApiCallback<SqlV3Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3StatementStatusValidateBeforeCall(environment, name, org, sqlV3Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3TimeOrderedStatementCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3TimeOrderedStatementValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3TimeOrderedStatement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3TimeOrderedStatement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3TimeOrderedStatement(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling updateSqlV3TimeOrderedStatement(Async)");
        }
        return this.updateSqlV3TimeOrderedStatementCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement updateSqlV3TimeOrderedStatement(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.updateSqlV3TimeOrderedStatementWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> updateSqlV3TimeOrderedStatementWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3TimeOrderedStatementAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3TimeOrderedStatementFinalizersCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling updateSqlV3TimeOrderedStatementFinalizers(Async)");
        }
        return this.updateSqlV3TimeOrderedStatementFinalizersCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement updateSqlV3TimeOrderedStatementFinalizers(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.updateSqlV3TimeOrderedStatementFinalizersWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> updateSqlV3TimeOrderedStatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3TimeOrderedStatementFinalizersAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementFinalizersValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV3TimeOrderedStatementStatusCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV3TimeOrderedStatement localVarPostBody = sqlV3TimeOrderedStatement;
        String localVarPath = "/apis/sql/v3/orgs/{org}/environments/{environment}/timeorderedstatements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV3TimeOrderedStatementStatusValidateBeforeCall(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV3TimeOrderedStatementStatus(Async)");
        }
        if (sqlV3TimeOrderedStatement == null) {
            throw new ApiException("Missing the required parameter 'sqlV3TimeOrderedStatement' when calling updateSqlV3TimeOrderedStatementStatus(Async)");
        }
        return this.updateSqlV3TimeOrderedStatementStatusCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
    }

    public SqlV3TimeOrderedStatement updateSqlV3TimeOrderedStatementStatus(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        ApiResponse<SqlV3TimeOrderedStatement> localVarResp = this.updateSqlV3TimeOrderedStatementStatusWithHttpInfo(environment, name, org, sqlV3TimeOrderedStatement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV3TimeOrderedStatement> updateSqlV3TimeOrderedStatementStatusWithHttpInfo(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, null);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV3TimeOrderedStatementStatusAsync(String environment, String name, String org, SqlV3TimeOrderedStatement sqlV3TimeOrderedStatement, ApiCallback<SqlV3TimeOrderedStatement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV3TimeOrderedStatementStatusValidateBeforeCall(environment, name, org, sqlV3TimeOrderedStatement, _callback);
        Type localVarReturnType = new TypeToken<SqlV3TimeOrderedStatement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

