/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ComputeV1PlacementStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CLOUD = "cloud";
    @SerializedName(value="cloud")
    private String cloud = "";
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region = "";
    public static final String SERIALIZED_NAME_WORKLOAD_CLASS = "workloadClass";
    @SerializedName(value="workloadClass")
    private WorkloadClassEnum workloadClass;
    public static final String SERIALIZED_NAME_ZONES = "zones";
    @SerializedName(value="zones")
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ComputeV1PlacementStrategy cloud(String cloud) {
        this.cloud = cloud;
        return this;
    }

    @Nonnull
    public String getCloud() {
        return this.cloud;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public ComputeV1PlacementStrategy nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public ComputeV1PlacementStrategy putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @Nullable
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public ComputeV1PlacementStrategy region(String region) {
        this.region = region;
        return this;
    }

    @Nonnull
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ComputeV1PlacementStrategy workloadClass(WorkloadClassEnum workloadClass) {
        this.workloadClass = workloadClass;
        return this;
    }

    @Nonnull
    public WorkloadClassEnum getWorkloadClass() {
        return this.workloadClass;
    }

    public void setWorkloadClass(WorkloadClassEnum workloadClass) {
        this.workloadClass = workloadClass;
    }

    public ComputeV1PlacementStrategy zones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ComputeV1PlacementStrategy addZonesItem(String zonesItem) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(zonesItem);
        return this;
    }

    @Nullable
    public List<String> getZones() {
        return this.zones;
    }

    public void setZones(List<String> zones) {
        this.zones = zones;
    }

    public ComputeV1PlacementStrategy putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeV1PlacementStrategy computeV1PlacementStrategy = (ComputeV1PlacementStrategy)o;
        return Objects.equals(this.cloud, computeV1PlacementStrategy.cloud) && Objects.equals(this.nodeSelector, computeV1PlacementStrategy.nodeSelector) && Objects.equals(this.region, computeV1PlacementStrategy.region) && Objects.equals((Object)this.workloadClass, (Object)computeV1PlacementStrategy.workloadClass) && Objects.equals(this.zones, computeV1PlacementStrategy.zones) && Objects.equals(this.additionalProperties, computeV1PlacementStrategy.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cloud, this.nodeSelector, this.region, this.workloadClass, this.zones, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComputeV1PlacementStrategy {\n");
        sb.append("    cloud: ").append(this.toIndentedString(this.cloud)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    workloadClass: ").append(this.toIndentedString((Object)this.workloadClass)).append("\n");
        sb.append("    zones: ").append(this.toIndentedString(this.zones)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ComputeV1PlacementStrategy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CLOUD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cloud` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLOUD).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REGION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `region` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_WORKLOAD_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `workloadClass` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORKLOAD_CLASS).toString()));
        }
        WorkloadClassEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WORKLOAD_CLASS));
        if (jsonObj.get(SERIALIZED_NAME_ZONES) != null && !jsonObj.get(SERIALIZED_NAME_ZONES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ZONES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `zones` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ZONES).toString()));
        }
    }

    public static ComputeV1PlacementStrategy fromJson(String jsonString) throws IOException {
        return (ComputeV1PlacementStrategy)JSON.getGson().fromJson(jsonString, ComputeV1PlacementStrategy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLOUD);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_REGION);
        openapiFields.add(SERIALIZED_NAME_WORKLOAD_CLASS);
        openapiFields.add(SERIALIZED_NAME_ZONES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CLOUD);
        openapiRequiredFields.add(SERIALIZED_NAME_REGION);
        openapiRequiredFields.add(SERIALIZED_NAME_WORKLOAD_CLASS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ComputeV1PlacementStrategy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ComputeV1PlacementStrategy.class));
            return new TypeAdapter<ComputeV1PlacementStrategy>(){

                public void write(JsonWriter out, ComputeV1PlacementStrategy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ComputeV1PlacementStrategy read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ComputeV1PlacementStrategy.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ComputeV1PlacementStrategy instance = (ComputeV1PlacementStrategy)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WorkloadClassEnum {
        TRUSTED("Trusted"),
        UNTRUSTED("Untrusted");

        private String value;

        private WorkloadClassEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WorkloadClassEnum fromValue(String value) {
            for (WorkloadClassEnum b : WorkloadClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            WorkloadClassEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<WorkloadClassEnum> {
            public void write(JsonWriter jsonWriter, WorkloadClassEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WorkloadClassEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WorkloadClassEnum.fromValue(value);
            }
        }
    }
}

