/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RequestDeterminationBasedOnContextOnly;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.RequestFeatureFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K2RequestDeterminationBasedOnRequestDetails
implements RequestFeatureFilter {
    private static final Logger logger = LoggerFactory.getLogger(K2RequestDeterminationBasedOnRequestDetails.class);
    private static final boolean FALSE_TO_ALLOW_RPC_PROCESSING_FOR_INTERNAL_PRINCIPALS = false;
    private final K2RequestDeterminationBasedOnContextOnly principalDetermination = new K2RequestDeterminationBasedOnContextOnly();
    private final Function<Uuid, Optional<String>> topicIdToNameMapper;
    private final Function<String, Optional<TopicType>> topicNameToTypeMapper;
    private final boolean clusterLinkK1ToK2MigrationEnabled;

    public K2RequestDeterminationBasedOnRequestDetails(Function<Uuid, Optional<String>> topicIdToNameMapper, Function<String, Optional<TopicType>> topicNameToTypeMapper, boolean clusterLinkK1ToK2MigrationEnabled) {
        this.topicIdToNameMapper = Objects.requireNonNull(topicIdToNameMapper);
        this.topicNameToTypeMapper = Objects.requireNonNull(topicNameToTypeMapper);
        this.clusterLinkK1ToK2MigrationEnabled = clusterLinkK1ToK2MigrationEnabled;
    }

    public boolean appliesTo(AbstractRequest request, RequestContext context, Optional<Supplier<Set<String>>> sessionTopicNames) {
        boolean isK2RequestBasedOffContext = this.isK2BasedOnRequestContextOnly(request, context, sessionTopicNames);
        if (isK2RequestBasedOffContext) {
            return true;
        }
        ApiKeys apiKey = request.apiKey();
        switch (apiKey) {
            case PRODUCE: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                boolean k2ProduceRequest = this.appliesToExistingTopicNames(request, K2RequestDeterminationBasedOnRequestDetails.filterPresent(((ProduceRequest)request).data().topicData().stream().map(produceData -> {
                    String name = produceData.name();
                    if (name != null && !name.isEmpty()) {
                        return Optional.of(name);
                    }
                    return this.topicIdToNameMapper.apply(produceData.topicId());
                })), apiKey.name);
                if (!k2ProduceRequest) {
                    return false;
                }
                K2RequestDeterminationBasedOnRequestDetails.maybeThrowForUnsupportedProduceVersion(request);
                return true;
            }
            case FETCH: {
                if (!sessionTopicNames.isPresent()) {
                    throw new IllegalArgumentException("Must set session topic names for " + request.getClass().getSimpleName());
                }
                boolean k2FetchRequest = this.appliesToExistingTopicNames(request, sessionTopicNames.get().get().stream(), apiKey.name);
                if (!k2FetchRequest) {
                    return false;
                }
                K2RequestDeterminationBasedOnRequestDetails.maybeThrowForUnsupportedFetchVersion(request);
                return true;
            }
            case LIST_OFFSETS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((ListOffsetsRequest)request).data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name), apiKey.name);
            }
            case METADATA: {
                return true;
            }
            case CREATE_TOPICS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                if (this.clusterLinkK1ToK2MigrationEnabled) {
                    return K2RequestDeterminationBasedOnRequestDetails.isK2CreateTopicsRequest((CreateTopicsRequest)request, apiKey.name);
                }
                return K2RequestDeterminationBasedOnRequestDetails.appliesToTopicNames(request, ((CreateTopicsRequest)request).data().topics().stream().map(CreateTopicsRequestData.CreatableTopic::name), apiKey.name);
            }
            case DELETE_TOPICS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Stream<Optional<String>> topics = ((DeleteTopicsRequest)request).topics().stream().map(deleteTopicState -> {
                    if (deleteTopicState.name() != null) {
                        return Optional.of(deleteTopicState.name());
                    }
                    return this.topicIdToNameMapper.apply(deleteTopicState.topicId());
                });
                return this.appliesToExistingTopicNames(request, K2RequestDeterminationBasedOnRequestDetails.filterPresent(topics), apiKey.name);
            }
            case DELETE_RECORDS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((DeleteRecordsRequest)request).data().topics().stream().map(DeleteRecordsRequestData.DeleteRecordsTopic::name), apiKey.name);
            }
            case ALTER_CONFIGS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Set alterTopicConfigTopicNames = ((AlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) == ConfigResource.Type.TOPIC).map(AlterConfigsRequestData.AlterConfigsResource::resourceName).collect(Collectors.toSet());
                if (alterTopicConfigTopicNames.isEmpty()) {
                    return false;
                }
                boolean hasK2Topics = this.appliesToExistingTopicNames(request, alterTopicConfigTopicNames.stream(), apiKey.name);
                if (!hasK2Topics) {
                    return false;
                }
                Set nonTopicResourceDescriptions = ((AlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) != ConfigResource.Type.TOPIC).map(nonTopicResource -> ConfigResource.Type.forId((byte)nonTopicResource.resourceType()).name().toLowerCase(Locale.ROOT) + ":" + nonTopicResource.resourceName()).collect(Collectors.toSet());
                if (!nonTopicResourceDescriptions.isEmpty()) {
                    throw new InvalidRequestException("Existence of both topic and non-topic entities in the same " + request.apiKey().name + " request is not supported: topics=" + String.valueOf(alterTopicConfigTopicNames) + "; non-topics=" + String.valueOf(nonTopicResourceDescriptions));
                }
                return true;
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Set incrementalAlterTopicConfigTopicNames = ((IncrementalAlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) == ConfigResource.Type.TOPIC).map(IncrementalAlterConfigsRequestData.AlterConfigsResource::resourceName).collect(Collectors.toSet());
                if (incrementalAlterTopicConfigTopicNames.isEmpty()) {
                    return false;
                }
                boolean hasK2Topics = this.appliesToExistingTopicNames(request, incrementalAlterTopicConfigTopicNames.stream(), apiKey.name);
                if (!hasK2Topics) {
                    return false;
                }
                Set nonTopicResourceDescriptions = ((IncrementalAlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) != ConfigResource.Type.TOPIC).map(nonTopicResource -> ConfigResource.Type.forId((byte)nonTopicResource.resourceType()).name().toLowerCase(Locale.ROOT) + ":" + nonTopicResource.resourceName()).collect(Collectors.toSet());
                if (!nonTopicResourceDescriptions.isEmpty()) {
                    throw new InvalidRequestException("Existence of both topic and non-topic entities in the same " + request.apiKey().name + " request is not supported: topics=" + String.valueOf(incrementalAlterTopicConfigTopicNames) + "; non-topics=" + String.valueOf(nonTopicResourceDescriptions));
                }
                return true;
            }
            case INIT_PRODUCER_ID: {
                return false;
            }
            case END_TXN: {
                return ((EndTxnRequest)request).data().producerId() == 0L;
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((OffsetsForLeaderEpochRequest)request).data().topics().stream().map(OffsetForLeaderEpochRequestData.OffsetForLeaderTopic::topic), apiKey.name);
            }
            case ADD_PARTITIONS_TO_TXN: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((AddPartitionsToTxnRequest)request).data().transactions().stream().map(x -> x.topics().stream().map(AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case ADD_OFFSETS_TO_TXN: {
                return ((AddOffsetsToTxnRequest)request).data().producerId() == 0L;
            }
            case WRITE_TXN_MARKERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((WriteTxnMarkersRequest)request).data().markers().stream().map(x -> x.topics().stream().map(WriteTxnMarkersRequestData.WritableTxnMarkerTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((AlterReplicaLogDirsRequest)request).data().dirs().stream().map(x -> x.topics().stream().map(AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case DESCRIBE_LOG_DIRS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                DescribeLogDirsRequest describeLogDirsRequest = (DescribeLogDirsRequest)request;
                if (describeLogDirsRequest.isAllTopicPartitions()) {
                    return false;
                }
                return this.appliesToExistingTopicNames(request, describeLogDirsRequest.data().topics().stream().map(DescribeLogDirsRequestData.DescribableLogDirTopic::topic), apiKey.name);
            }
            case CREATE_PARTITIONS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((CreatePartitionsRequest)request).data().topics().stream().map(CreatePartitionsRequestData.CreatePartitionsTopic::name), apiKey.name);
            }
            case ELECT_LEADERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ElectLeadersRequest)request).data().topicPartitions().iterator(), 16), false).map(ElectLeadersRequestData.TopicPartitions::topic), apiKey.name);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((AlterPartitionReassignmentsRequest)request).data().topics().stream().map(AlterPartitionReassignmentsRequestData.ReassignableTopic::name), apiKey.name);
            }
            case DESCRIBE_PRODUCERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, ((DescribeProducersRequest)request).data().topics().stream().map(DescribeProducersRequestData.TopicRequest::name), apiKey.name);
            }
        }
        logger.warn("Request class not covered in " + this.getClass().getSimpleName() + ": " + String.valueOf(request.getClass()));
        return false;
    }

    private static void maybeThrowForUnsupportedFetchVersion(AbstractRequest request) {
        if (request.version() < 3) {
            throw new UnsupportedVersionException("Fetch version must be at least 3: " + request.version());
        }
    }

    private static void maybeThrowForUnsupportedProduceVersion(AbstractRequest request) {
        if (request.version() < 3) {
            throw new UnsupportedVersionException("Produce version must be at least 3: " + request.version());
        }
    }

    private boolean isK2BasedOnRequestContextOnly(AbstractRequest request, RequestContext context, Optional<Supplier<Set<String>>> sessionTopicNames) {
        boolean appliesToPrincipal = this.principalDetermination.appliesTo(request, context, sessionTopicNames);
        if (appliesToPrincipal) {
            if (request instanceof FetchRequest) {
                K2RequestDeterminationBasedOnRequestDetails.maybeThrowForUnsupportedFetchVersion(request);
            }
            if (request instanceof ProduceRequest) {
                K2RequestDeterminationBasedOnRequestDetails.maybeThrowForUnsupportedProduceVersion(request);
            }
            if (this.clusterLinkK1ToK2MigrationEnabled) {
                return request instanceof InitProducerIdRequest || request instanceof EndTxnRequest || request instanceof AddOffsetsToTxnRequest;
            }
            return !(request instanceof IncrementalAlterConfigsRequest) && !(request instanceof AlterConfigsRequest);
        }
        return false;
    }

    private static void confirmNoTopicNameOverrides(AbstractRequest request, Optional<Supplier<Set<String>>> sessionTopicNames) {
        if (sessionTopicNames.isPresent()) {
            throw new IllegalArgumentException("Cannot set session topic names for " + request.getClass().getSimpleName());
        }
    }

    private static Boolean isK1InternalTopic(String name) {
        return name.startsWith("_");
    }

    private static Stream<String> filterPresent(Stream<Optional<String>> optionalStream) {
        return optionalStream.filter(Optional::isPresent).map(Optional::get);
    }

    private boolean appliesToExistingTopicNames(AbstractRequest request, Stream<String> topicNames, String requestDescription) {
        Map<String, Optional<TopicType>> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, this.topicNameToTypeMapper));
        Map<String, Boolean> topicToK2Applicability = topicDeterminations.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            TopicType type = (TopicType)((Optional)entry.getValue()).get();
            return type == TopicType.FREIGHT || type == TopicType.VIRTUAL;
        }));
        if (topicToK2Applicability.isEmpty()) {
            return K2RequestDeterminationBasedOnRequestDetails.appliesToTopicNames(request, topicDeterminations.keySet().stream(), requestDescription);
        }
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicToK2Applicability, requestDescription);
        K2RequestDeterminationBasedOnRequestDetails.maybeTraceLog(request, requestDescription, topicToK2Applicability, isK2Request);
        return isK2Request;
    }

    private static boolean appliesToTopicNames(AbstractRequest request, Stream<String> topicNames, String requestDescription) {
        Map<String, Boolean> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, name -> K2RequestDeterminationBasedOnRequestDetails.isK1InternalTopic(name) == false));
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicDeterminations, requestDescription);
        if (logger.isTraceEnabled()) {
            logger.trace(requestDescription + " request determined to " + (isK2Request ? "be " : "not be ") + "a K2 request: topicDeterminations=" + Utils.mkString(topicDeterminations, (String)"(", (String)")", (String)"=", (String)",") + "; request=" + String.valueOf(request));
        }
        return isK2Request;
    }

    private static boolean isK2CreateTopicsRequest(CreateTopicsRequest request, String requestDescription) {
        Stream creatableTopicStream = request.data().topics().stream();
        Map<String, Boolean> topicDeterminations = creatableTopicStream.distinct().collect(Collectors.toMap(creatableTopic -> creatableTopic.name(), creatableTopic -> K2RequestDeterminationBasedOnRequestDetails.isK1InternalTopic(creatableTopic.name()) == false && creatableTopic.mirrorTopic() == null));
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicDeterminations, requestDescription);
        K2RequestDeterminationBasedOnRequestDetails.maybeTraceLog((AbstractRequest)request, requestDescription, topicDeterminations, isK2Request);
        return isK2Request;
    }

    private static void maybeTraceLog(AbstractRequest request, String requestDescription, Map<String, Boolean> topicNameToIsK2, boolean isK2Request) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} request determined to {} a K2 request: topicDeterminations={}; request={}", new Object[]{requestDescription, isK2Request ? "be" : "not be", Utils.mkString(topicNameToIsK2, (String)"(", (String)")", (String)"=", (String)","), request});
        }
    }

    private static boolean validate(Map<String, Boolean> topicNamesToDeterminations, String requestDescription) {
        HashSet<Boolean> uniqueTopicDeterminations = new HashSet<Boolean>(topicNamesToDeterminations.values());
        if (uniqueTopicDeterminations.size() > 1) {
            throw new InvalidRequestException("Existence of both K2 and Non-K2 topics in the same " + requestDescription + " request is not supported: " + Utils.mkString(topicNamesToDeterminations, (String)"", (String)"", (String)"=", (String)","));
        }
        return uniqueTopicDeterminations.isEmpty() || (Boolean)uniqueTopicDeterminations.iterator().next() != false;
    }
}

