/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import io.confluent.resourcemanager.api.client.Client;
import io.confluent.resourcemanager.api.client.CreateRequest;
import io.confluent.resourcemanager.api.client.DeleteRequest;
import io.confluent.resourcemanager.api.client.GetRequest;
import io.confluent.resourcemanager.api.client.JsonPatchRequest;
import io.confluent.resourcemanager.api.client.ListRequest;
import io.confluent.resourcemanager.api.client.RateLimit;
import io.confluent.resourcemanager.api.client.UpdateRequest;
import io.confluent.resourcemanager.api.client.Watcher;
import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.internal.discovery.DiscoveryClient;
import io.confluent.resourcemanager.internal.restmapper.RESTMapper;
import io.confluent.resourcemanager.internal.restmapper.RESTMapping;
import io.confluent.srj.spire.SpireX509Client;
import io.confluent.srj.spire.exceptions.SpiffeX509SourceProviderException;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientImpl
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(ClientImpl.class);
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper().findAndRegisterModules().registerModule((Module)new Jdk8Module()).registerModule((Module)new ProtobufModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String DEFAULT_USER_AGENT = ClientImpl.buildUserAgent();
    static final String USER_AGENT_HEADER = "User-Agent";
    private static final int DEFAULT_MAX_INBOUND_MESSAGE_SIZE = 0xA00000;
    private static final String DEFAULT_TLS_PROTOCOL = "TLSv1.3";
    private static final RateLimit DEFAULT_RATE_LIMIT = new RateLimit();
    private static final boolean DEFAULT_IS_WATCH_V1_REQUEST = false;
    private final String httpHost;
    private final OkHttpClient httpClient;
    private final ManagedChannel channel;
    private final RESTMapper restMapper;
    private String grpcHost;
    private List<ThrowingRunnable> onClientCloseHooks;
    private SpireX509Client spireX509Client;
    private String spireAgentUrl;
    private String authorizedSpiffeIds;
    private String userAgent;
    private RateLimit rateLimit;
    private String tlsProtocol;
    private boolean isWatchV1Request;

    public static ClientImpl spire(String spireAgentUrl, String authorizedSpiffeIds, String httpHost, String grpcHost) throws KeyManagementException, SSLException, NoSuchAlgorithmException, SpiffeX509SourceProviderException {
        return ClientImpl.spire(spireAgentUrl, authorizedSpiffeIds, httpHost, grpcHost, DEFAULT_TLS_PROTOCOL, DEFAULT_RATE_LIMIT, false);
    }

    public static ClientImpl spire(String spireAgentUrl, String authorizedSpiffeIds, String httpHost, String grpcHost, String tlsProtocol) throws SpiffeX509SourceProviderException, KeyManagementException, SSLException, NoSuchAlgorithmException {
        return ClientImpl.spire(spireAgentUrl, authorizedSpiffeIds, httpHost, grpcHost, tlsProtocol, DEFAULT_RATE_LIMIT, false);
    }

    public static ClientImpl spire(String spireAgentUrl, String authorizedSpiffeIds, String httpHost, String grpcHost, String tlsProtocol, RateLimit rateLimit, boolean isWatchV1Request) throws SpiffeX509SourceProviderException, KeyManagementException, SSLException, NoSuchAlgorithmException {
        SpireX509Client x509Client = new SpireX509Client.SpireX509ClientBuilder().setSpireAgentURL(spireAgentUrl).setAuthorizedSpiffeIds(authorizedSpiffeIds, ',').build();
        OkHttpClient httpClient = new OkHttpClient.Builder().sslSocketFactory(x509Client.getHttpSSLContextForMtls(tlsProtocol).getSocketFactory(), (X509TrustManager)x509Client.getTrustManager()).hostnameVerifier((hostname, session) -> true).build();
        ManagedChannel managedChannel = null;
        if (grpcHost != null) {
            NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)grpcHost).sslContext(x509Client.getGrpcClientSslContextForMtls());
            if (rateLimit != null && !rateLimit.getClientRateLimitingDisabled()) {
                channelBuilder = RateLimit.updateRateLimitedSpireGrpcClient(channelBuilder, rateLimit);
            }
            managedChannel = channelBuilder.build();
        }
        return new ClientImpl(httpHost, httpClient, managedChannel, rateLimit, isWatchV1Request);
    }

    public ClientImpl(String httpHost, String grpcHost) {
        this(httpHost, grpcHost, DEFAULT_RATE_LIMIT);
    }

    public ClientImpl(String httpHost, String grpcHost, RateLimit rateLimit) {
        this(httpHost, rateLimit != null && !rateLimit.getClientRateLimitingDisabled() ? RateLimit.updateRateLimitedHttpClientBuilder(new OkHttpClient.Builder(), rateLimit).build() : new OkHttpClient.Builder().build(), grpcHost == null ? null : (rateLimit != null && !rateLimit.getClientRateLimitingDisabled() ? RateLimit.updateRateLimitedGrpcClient(ClientImpl.setDefaultChannelOptions(ManagedChannelBuilder.forTarget((String)grpcHost)).usePlaintext(), rateLimit).build() : ClientImpl.setDefaultChannelOptions(ManagedChannelBuilder.forTarget((String)grpcHost)).usePlaintext().build()));
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel) {
        this(httpHost, httpClient, channel, DEFAULT_RATE_LIMIT, false);
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RateLimit rateLimit, boolean isWatchV1Request) {
        this(httpHost, httpClient, channel, new RESTMapper(new DiscoveryClient(httpHost, httpClient)), rateLimit, isWatchV1Request);
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RESTMapper restMapper) {
        this(httpHost, httpClient, channel, restMapper, DEFAULT_RATE_LIMIT, false);
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RESTMapper restMapper, RateLimit rateLimit, boolean isWatchV1Request) {
        this(httpHost, httpClient, channel, restMapper, DEFAULT_USER_AGENT, rateLimit, isWatchV1Request);
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RESTMapper restMapper, String userAgent) {
        this(httpHost, httpClient, channel, restMapper, userAgent, DEFAULT_RATE_LIMIT, false);
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RESTMapper restMapper, String userAgent, RateLimit rateLimit, boolean isWatchV1Request) {
        this.httpHost = Objects.requireNonNull(httpHost);
        this.channel = channel;
        this.restMapper = restMapper;
        OkHttpClient.Builder httpClientBuilder = httpClient.newBuilder().addInterceptor((Interceptor)new UserAgentInterceptor(userAgent));
        if (rateLimit != null && !rateLimit.getClientRateLimitingDisabled()) {
            httpClientBuilder = RateLimit.updateRateLimitedHttpClientBuilder(httpClientBuilder, rateLimit);
        }
        this.httpClient = httpClientBuilder.build();
        this.isWatchV1Request = isWatchV1Request;
    }

    public static ManagedChannelBuilder<?> setDefaultChannelOptions(ManagedChannelBuilder<?> builder) {
        return builder.userAgent(DEFAULT_USER_AGENT).defaultLoadBalancingPolicy("round_robin").keepAliveTime(1L, TimeUnit.MINUTES).keepAliveTimeout(30L, TimeUnit.SECONDS).keepAliveWithoutCalls(true).maxInboundMessageSize(0xA00000);
    }

    private static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String hostname = System.getenv("HOSTNAME");
            return hostname != null ? hostname : "unknown";
        }
    }

    private static String buildUserAgent() {
        String client = "java-client";
        String version = ClientImpl.class.getPackage().getImplementationVersion() != null ? ClientImpl.class.getPackage().getImplementationVersion() : "unknown";
        String operatingSystem = System.getProperty("os.name", "unknown");
        String arch = System.getProperty("os.arch", "unknown");
        String commit = System.getProperty("commit.hash", "unknown");
        String hostname = ClientImpl.resolveHostname();
        String user = System.getProperty("user.name", "unknown");
        return String.format("%s/%s (%s/%s) cc/%s hostname/%s user/%s", client, version, operatingSystem, arch, commit, hostname, user);
    }

    @Override
    public <T extends HasMetadata> GetRequest<T> get(ObjectIdentifier<T> objectIdentifier) {
        RESTMapping mapping = this.getMapping(objectIdentifier);
        return new GetRequest(this.httpHost, this.httpClient, mapping.groupVersionResource(), objectIdentifier.getLocation(), mapping.scoping(), objectIdentifier.getScope(), objectIdentifier.getName(), objectIdentifier.getKind(), objectIdentifier.getJavaType());
    }

    private RESTMapping getMapping(HasMetadata obj) {
        return this.getMapping(new GroupVersionKind(obj.getGroup(), obj.getVersion(), obj.getKind()));
    }

    private RESTMapping getMapping(ObjectIdentifier<?> id) {
        return this.getMapping(new GroupVersionKind(id.getGroup(), id.getVersion(), id.getKind()));
    }

    private RESTMapping getMapping(GroupVersionKind gvk) {
        return this.restMapper.getMapping(gvk).orElseGet(() -> {
            this.restMapper.refresh();
            return this.restMapper.getMapping(gvk).orElseThrow(() -> new RuntimeException(String.format("No mapping found for %s", gvk)));
        });
    }

    @Override
    public <T extends HasMetadata> CreateRequest<T> create(T obj) {
        RESTMapping mapping = this.getMapping(obj);
        logger.debug("create request: {}", new ObjectIdentifier<T>(obj));
        if (obj instanceof Adapter) {
            Adapter adapter = (Adapter)obj;
            return new CreateRequest<Adapter>(this.httpHost, this.httpClient, adapter, mapping.groupVersionResource(), mapping.scoping());
        }
        return new CreateRequest<T>(this.httpHost, this.httpClient, obj, mapping.groupVersionResource(), mapping.scoping());
    }

    @Override
    public <T extends HasMetadata> DeleteRequest<T> delete(ObjectIdentifier<T> objectIdentifier) {
        RESTMapping mapping = this.getMapping(objectIdentifier);
        logger.debug("delete request for {}, mapping {}", objectIdentifier, (Object)mapping);
        return new DeleteRequest(this.httpHost, this.httpClient, mapping.groupVersionResource(), objectIdentifier.getLocation(), mapping.scoping(), objectIdentifier.getScope(), objectIdentifier.getName(), objectIdentifier.getKind(), objectIdentifier.getJavaType());
    }

    @Override
    public <T extends HasMetadata> UpdateRequest<T> update(T obj) {
        RESTMapping mapping = this.getMapping(obj);
        logger.debug("update request: {}", new ObjectIdentifier<T>(obj));
        if (obj instanceof Adapter) {
            Adapter adapter = (Adapter)obj;
            return new UpdateRequest<Adapter>(this.httpHost, this.httpClient, adapter, mapping.groupVersionResource(), mapping.scoping());
        }
        return new UpdateRequest<T>(this.httpHost, this.httpClient, obj, mapping.groupVersionResource(), mapping.scoping());
    }

    @Override
    public <T extends HasMetadata> JsonPatchRequest<T> patch(ObjectIdentifier<T> objectIdentifier, byte[] patch) {
        RESTMapping mapping = this.getMapping(objectIdentifier);
        logger.debug("patch request: {}", objectIdentifier);
        return new JsonPatchRequest(this.httpHost, this.httpClient, mapping.groupVersionResource(), objectIdentifier.getLocation(), mapping.scoping(), objectIdentifier.getScope(), objectIdentifier.getName(), objectIdentifier.getKind(), objectIdentifier.getJavaType(), patch);
    }

    @Override
    public <T extends HasMetadata> ListRequest<T> list(Class<T> objClass) {
        RESTMapping mapping = this.getMapping(new GroupVersionKind(HasMetadata.getGroup(objClass), HasMetadata.getVersion(objClass), HasMetadata.getKind(objClass)));
        logger.debug("list request: {}", (Object)mapping);
        TypeFactory typeFactory = OBJECT_MAPPER.getTypeFactory();
        return new ListRequest(this.httpHost, this.httpClient, typeFactory.constructType(objClass), mapping.groupVersionResource(), mapping.scoping(), mapping.groupVersionKind().kind(), typeFactory);
    }

    @Override
    public <T extends HasMetadata> Watcher<T> watch(Class<T> objClass) {
        return new Watcher((Channel)this.channel, OBJECT_MAPPER.getTypeFactory().constructType(objClass), new GroupVersionKind(HasMetadata.getGroup(objClass), HasMetadata.getVersion(objClass), HasMetadata.getKind(objClass)), this.isWatchV1Request);
    }

    @Override
    public <U, V extends Adapter<U>> Watcher<V> watch(V adapter) {
        return new Watcher((Channel)this.channel, adapter.getJavaType(), new GroupVersionKind(adapter.getGroup(), adapter.getVersion(), adapter.getKind()), this.isWatchV1Request);
    }

    @Override
    public <U, V extends Adapter<U>> ListRequest<V> list(V adapter) {
        RESTMapping mapping = this.getMapping(adapter);
        return new ListRequest(this.httpHost, this.httpClient, adapter.getJavaType(), mapping.groupVersionResource(), mapping.scoping(), adapter.getKind(), OBJECT_MAPPER.getTypeFactory());
    }

    @Override
    public synchronized void close() throws IOException {
        this.onClientCloseHooks.forEach(ThrowingRunnable::run);
    }

    public static ClientImplBuilder builder() {
        return new CustomClientImplBuilder();
    }

    @Generated
    private static String $default$userAgent() {
        return DEFAULT_USER_AGENT;
    }

    @Generated
    private static RateLimit $default$rateLimit() {
        return DEFAULT_RATE_LIMIT;
    }

    @Generated
    private static String $default$tlsProtocol() {
        return DEFAULT_TLS_PROTOCOL;
    }

    @Generated
    private static boolean $default$isWatchV1Request() {
        return false;
    }

    @Generated
    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel, RESTMapper restMapper, String grpcHost, List<ThrowingRunnable> onClientCloseHooks, SpireX509Client spireX509Client, String spireAgentUrl, String authorizedSpiffeIds, String userAgent, RateLimit rateLimit, String tlsProtocol, boolean isWatchV1Request) {
        this.httpHost = httpHost;
        this.httpClient = httpClient;
        this.channel = channel;
        this.restMapper = restMapper;
        this.grpcHost = grpcHost;
        this.onClientCloseHooks = onClientCloseHooks;
        this.spireX509Client = spireX509Client;
        this.spireAgentUrl = spireAgentUrl;
        this.authorizedSpiffeIds = authorizedSpiffeIds;
        this.userAgent = userAgent;
        this.rateLimit = rateLimit;
        this.tlsProtocol = tlsProtocol;
        this.isWatchV1Request = isWatchV1Request;
    }

    private record UserAgentInterceptor(String userAgent) implements Interceptor
    {
        @Nonnull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header(ClientImpl.USER_AGENT_HEADER, this.userAgent).build();
            return chain.proceed(requestWithUserAgent);
        }
    }

    private static class CustomClientImplBuilder
    extends ClientImplBuilder {
        private CustomClientImplBuilder() {
        }

        @Override
        public ClientImpl build() {
            Objects.requireNonNull(this.httpHost, "httpHost must not be null");
            ClientImpl defaultClientImplBuild = super.build();
            if (this.spireAgentUrl != null && this.spireX509Client != null) {
                throw new IllegalArgumentException("spireAgentUrl and spireX509Client cannot be set at the same time");
            }
            if (this.onClientCloseHooks == null) {
                this.onClientCloseHooks = new ArrayList<ThrowingRunnable>();
            }
            if (this.spireAgentUrl != null && this.authorizedSpiffeIds != null || this.spireX509Client != null) {
                this.spireClientHelper(this.spireAgentUrl, this.authorizedSpiffeIds, this.spireX509Client, defaultClientImplBuild);
            } else {
                this.clientHelper(defaultClientImplBuild);
            }
            if (this.restMapper == null) {
                this.restMapper = new RESTMapper(new DiscoveryClient(this.httpHost, this.httpClient));
            }
            return new ClientImpl(this.httpHost, this.httpClient, this.channel, this.restMapper, defaultClientImplBuild.userAgent, defaultClientImplBuild.rateLimit, defaultClientImplBuild.isWatchV1Request);
        }

        private void spireClientHelper(String spireAgentUrl, String authorizedSpiffeIds, SpireX509Client spireX509Client, ClientImpl builtBySuper) {
            try {
                SpireX509Client x509Client = spireX509Client;
                if (spireX509Client == null) {
                    x509Client = new SpireX509Client.SpireX509ClientBuilder().setSpireAgentURL(spireAgentUrl).setAuthorizedSpiffeIds(authorizedSpiffeIds, ',').build();
                    this.onClientCloseHooks.add(() -> ((SpireX509Client)x509Client).close());
                }
                if (this.httpClient == null) {
                    OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().sslSocketFactory(x509Client.getHttpSSLContextForMtls(builtBySuper.tlsProtocol).getSocketFactory(), (X509TrustManager)x509Client.getTrustManager()).hostnameVerifier((hostname, session) -> true);
                    this.httpClient = httpClientBuilder.build();
                    this.onClientCloseHooks.add(() -> this.httpClient.connectionPool().evictAll());
                }
                if (this.channel == null && this.grpcHost != null) {
                    NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forTarget((String)this.grpcHost).sslContext(x509Client.getGrpcClientSslContextForMtls());
                    if (!builtBySuper.rateLimit.getClientRateLimitingDisabled()) {
                        nettyChannelBuilder = RateLimit.updateRateLimitedSpireGrpcClient(nettyChannelBuilder, builtBySuper.rateLimit);
                    }
                    ManagedChannelBuilder<?> channelBuilder = ClientImpl.setDefaultChannelOptions(nettyChannelBuilder);
                    this.channel = channelBuilder.build();
                    this.onClientCloseHooks.add(() -> this.channel.shutdownNow());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create SPIRE-enabled client", e);
            }
        }

        private void clientHelper(ClientImpl builtBySuper) {
            if (this.httpClient == null) {
                this.httpClient = new OkHttpClient.Builder().build();
                this.onClientCloseHooks.add(() -> this.httpClient.connectionPool().evictAll());
            }
            if (this.channel == null && this.grpcHost != null) {
                ManagedChannelBuilder<?> channelBuilder = ClientImpl.setDefaultChannelOptions(ManagedChannelBuilder.forTarget((String)this.grpcHost)).usePlaintext();
                if (builtBySuper.rateLimit != null && !builtBySuper.rateLimit.getClientRateLimitingDisabled()) {
                    channelBuilder = RateLimit.updateRateLimitedGrpcClient(channelBuilder, builtBySuper.rateLimit);
                }
                this.channel = channelBuilder.build();
            }
        }
    }

    @Generated
    public static class ClientImplBuilder {
        @Generated
        private String httpHost;
        @Generated
        private OkHttpClient httpClient;
        @Generated
        private ManagedChannel channel;
        @Generated
        private RESTMapper restMapper;
        @Generated
        private String grpcHost;
        @Generated
        private List<ThrowingRunnable> onClientCloseHooks;
        @Generated
        private SpireX509Client spireX509Client;
        @Generated
        private String spireAgentUrl;
        @Generated
        private String authorizedSpiffeIds;
        @Generated
        private boolean userAgent$set;
        @Generated
        private String userAgent$value;
        @Generated
        private boolean rateLimit$set;
        @Generated
        private RateLimit rateLimit$value;
        @Generated
        private boolean tlsProtocol$set;
        @Generated
        private String tlsProtocol$value;
        @Generated
        private boolean isWatchV1Request$set;
        @Generated
        private boolean isWatchV1Request$value;

        @Generated
        ClientImplBuilder() {
        }

        @Generated
        public ClientImplBuilder httpHost(String httpHost) {
            this.httpHost = httpHost;
            return this;
        }

        @Generated
        public ClientImplBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public ClientImplBuilder channel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        @Generated
        public ClientImplBuilder restMapper(RESTMapper restMapper) {
            this.restMapper = restMapper;
            return this;
        }

        @Generated
        public ClientImplBuilder grpcHost(String grpcHost) {
            this.grpcHost = grpcHost;
            return this;
        }

        @Generated
        public ClientImplBuilder onClientCloseHooks(List<ThrowingRunnable> onClientCloseHooks) {
            this.onClientCloseHooks = onClientCloseHooks;
            return this;
        }

        @Generated
        public ClientImplBuilder spireX509Client(SpireX509Client spireX509Client) {
            this.spireX509Client = spireX509Client;
            return this;
        }

        @Generated
        public ClientImplBuilder spireAgentUrl(String spireAgentUrl) {
            this.spireAgentUrl = spireAgentUrl;
            return this;
        }

        @Generated
        public ClientImplBuilder authorizedSpiffeIds(String authorizedSpiffeIds) {
            this.authorizedSpiffeIds = authorizedSpiffeIds;
            return this;
        }

        @Generated
        public ClientImplBuilder userAgent(String userAgent) {
            this.userAgent$value = userAgent;
            this.userAgent$set = true;
            return this;
        }

        @Generated
        public ClientImplBuilder rateLimit(RateLimit rateLimit) {
            this.rateLimit$value = rateLimit;
            this.rateLimit$set = true;
            return this;
        }

        @Generated
        public ClientImplBuilder tlsProtocol(String tlsProtocol) {
            this.tlsProtocol$value = tlsProtocol;
            this.tlsProtocol$set = true;
            return this;
        }

        @Generated
        public ClientImplBuilder isWatchV1Request(boolean isWatchV1Request) {
            this.isWatchV1Request$value = isWatchV1Request;
            this.isWatchV1Request$set = true;
            return this;
        }

        @Generated
        public ClientImpl build() {
            String userAgent$value = this.userAgent$value;
            if (!this.userAgent$set) {
                userAgent$value = ClientImpl.$default$userAgent();
            }
            RateLimit rateLimit$value = this.rateLimit$value;
            if (!this.rateLimit$set) {
                rateLimit$value = ClientImpl.$default$rateLimit();
            }
            String tlsProtocol$value = this.tlsProtocol$value;
            if (!this.tlsProtocol$set) {
                tlsProtocol$value = ClientImpl.$default$tlsProtocol();
            }
            boolean isWatchV1Request$value = this.isWatchV1Request$value;
            if (!this.isWatchV1Request$set) {
                isWatchV1Request$value = ClientImpl.$default$isWatchV1Request();
            }
            return new ClientImpl(this.httpHost, this.httpClient, this.channel, this.restMapper, this.grpcHost, this.onClientCloseHooks, this.spireX509Client, this.spireAgentUrl, this.authorizedSpiffeIds, userAgent$value, rateLimit$value, tlsProtocol$value, isWatchV1Request$value);
        }

        @Generated
        public String toString() {
            return "ClientImpl.ClientImplBuilder(httpHost=" + this.httpHost + ", httpClient=" + String.valueOf(this.httpClient) + ", channel=" + String.valueOf(this.channel) + ", restMapper=" + String.valueOf(this.restMapper) + ", grpcHost=" + this.grpcHost + ", onClientCloseHooks=" + String.valueOf(this.onClientCloseHooks) + ", spireX509Client=" + String.valueOf(this.spireX509Client) + ", spireAgentUrl=" + this.spireAgentUrl + ", authorizedSpiffeIds=" + this.authorizedSpiffeIds + ", userAgent$value=" + this.userAgent$value + ", rateLimit$value=" + String.valueOf(this.rateLimit$value) + ", tlsProtocol$value=" + this.tlsProtocol$value + ", isWatchV1Request$value=" + this.isWatchV1Request$value + ")";
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable
    extends Runnable {
        @Override
        default public void run() {
            try {
                this.runThrows();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void runThrows() throws Exception;
    }
}

