/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.client.Subresource;
import io.confluent.resourcemanager.api.model.GroupVersionResource;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;

public final class GetRequest<T extends HasMetadata>
extends Request<Optional<T>> {
    GetRequest(String baseUrl, OkHttpClient httpClient, GroupVersionResource gvr, Location location, Scoping scoping, List<ScopeAttribute> scope, String objectName, String kind, JavaType javaType) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructParametricType(Optional.class, new JavaType[]{javaType}), gvr, location, scoping, scope);
        this.objectName = objectName;
        this.kind = kind;
    }

    public GetRequest<T> resourceVersion(String resourceVersion) {
        this.urlBuilder.setQueryParameter("resourceVersion", Objects.requireNonNull(resourceVersion));
        return this;
    }

    public GetRequest<T> stronglyConsistent(Boolean stronglyConsistent) {
        if (stronglyConsistent == null) {
            this.urlBuilder.removeAllQueryParameters("stronglyConsistent");
        } else {
            this.urlBuilder.setQueryParameter("stronglyConsistent", String.valueOf(stronglyConsistent));
        }
        return this;
    }

    @Override
    public CompletableFuture<Optional<T>> execute() {
        return this.exec(b -> b);
    }

    @Override
    public GetRequest<T> subresource(String subresource) {
        super.subresource(subresource);
        return this;
    }

    @Override
    public GetRequest<T> subresource(Subresource subresource) {
        super.subresource(subresource);
        return this;
    }
}

