/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.MediaTypes;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.client.Subresource;
import io.confluent.resourcemanager.api.model.GroupVersionResource;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class JsonPatchRequest<T extends HasMetadata>
extends Request<Optional<T>> {
    private final byte[] patch;

    JsonPatchRequest(String baseUrl, OkHttpClient httpClient, GroupVersionResource gvr, Location location, Scoping scoping, List<ScopeAttribute> scope, String objectName, String kind, JavaType javaType, byte[] patch) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructParametricType(Optional.class, new JavaType[]{javaType}), gvr, location, scoping, scope);
        this.objectName = objectName;
        this.kind = kind;
        this.patch = patch;
    }

    public JsonPatchRequest<T> resourceVersion(String resourceVersion) {
        this.urlBuilder.setQueryParameter("resourceVersion", Objects.requireNonNull(resourceVersion));
        return this;
    }

    @Override
    public CompletableFuture<Optional<T>> execute() {
        return this.exec(b -> b.patch(RequestBody.create((byte[])this.patch, (MediaType)MediaTypes.MEDIA_TYPE_JSON_PATCH)));
    }

    @Override
    public JsonPatchRequest<T> subresource(String subresource) {
        super.subresource(subresource);
        return this;
    }

    @Override
    public JsonPatchRequest<T> subresource(Subresource subresource) {
        super.subresource(subresource);
        return this;
    }
}

