/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.flink.watch.v1alpha1.WatchGrpc;
import io.confluent.flink.watch.v1alpha1.WatchRequest;
import io.confluent.flink.watch.v1alpha1.WatchResponse;
import io.confluent.resourcemanager.api.client.ApiException;
import io.confluent.resourcemanager.api.client.WatchEvent;
import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.ListMeta;
import io.confluent.resourcemanager.api.model.Status;
import io.confluent.resourcemanager.api.model.StatusCause;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.StatusDetails;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import resourcemanager.watch.v1.TypeMeta;
import resourcemanager.watch.v1.WatchGrpc;
import resourcemanager.watch.v1.WatchRequest;

public final class Watcher<T extends HasMetadata> {
    private static final Logger logger = LoggerFactory.getLogger(Watcher.class);
    private final Metadata.Key<String> WATCH_CLIENT_NAME_KEY = Metadata.Key.of((String)"client-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final StatusException CLIENT_CANCELLED_WATCH = new StatusException(io.grpc.Status.CANCELLED.withDescription("client cancelled the watch"));
    private final Metadata metadata = new Metadata();
    private final WatchRequest.WatchRequestBuilder watchRequestBuilder;
    private final WatchClient<T> watchClient;
    private final WatchStreamObserver<T> watchStreamObserver;

    public Watcher(Channel channel, JavaType javaType, GroupVersionKind gvk, boolean isWatchV1Request) {
        this.watchRequestBuilder = WatchRequest.builder().gvk(gvk);
        this.watchClient = isWatchV1Request ? new WatchClientV1(channel, javaType, gvk) : new WatchClientV1Alpha(channel, javaType, gvk);
        this.watchStreamObserver = new WatchStreamObserver();
    }

    public Watcher<T> clientName(String clientName) {
        this.metadata.put(this.WATCH_CLIENT_NAME_KEY, (Object)Objects.requireNonNull(clientName));
        return this;
    }

    public Watcher<T> subscriptionId(String subscriptionId) {
        this.watchRequestBuilder.subscriptionId(Objects.requireNonNull(subscriptionId));
        return this;
    }

    public Watcher<T> continueToken(String continueToken) {
        this.watchRequestBuilder.continueToken(Objects.requireNonNull(continueToken));
        return this;
    }

    public Watcher<T> includeSnapshot(boolean includeSnapshot) {
        this.watchRequestBuilder.includeSnapshot(includeSnapshot);
        return this;
    }

    public Watcher<T> useAsyncSnapshot(boolean useAsyncSnapshot) {
        this.watchRequestBuilder.useAsyncSnapshot(useAsyncSnapshot);
        return this;
    }

    public Watcher<T> labelSelector(String labelSelector) {
        this.watchRequestBuilder.labelSelectors(Stream.concat(Optional.ofNullable(this.watchRequestBuilder.labelSelectors).orElseGet(ArrayList::new).stream(), Stream.of(Objects.requireNonNull(labelSelector))).toList());
        return this;
    }

    public Watcher<T> fieldSelector(String fieldSelector) {
        this.watchRequestBuilder.fieldSelectors(Stream.concat(Optional.ofNullable(this.watchRequestBuilder.fieldSelectors).orElseGet(ArrayList::new).stream(), Stream.of(Objects.requireNonNull(fieldSelector))).toList());
        return this;
    }

    public Watcher<T> location(Location location) {
        this.watchRequestBuilder.location(Objects.requireNonNull(location).toString());
        return this;
    }

    public Watcher<T> allLocations(boolean allLocations) {
        this.watchRequestBuilder.allLocations(allLocations);
        return this;
    }

    public Watcher<T> onNext(Consumer<WatchEvent<T>> onNextCallback) {
        this.watchStreamObserver.onNextCallback = Objects.requireNonNull(onNextCallback);
        return this;
    }

    public Watcher<T> onError(Consumer<Throwable> onErrorCallback) {
        this.watchStreamObserver.onErrorCallback = Objects.requireNonNull(onErrorCallback);
        return this;
    }

    public Watcher<T> onCompleted(Runnable onCompletedCallback) {
        this.watchStreamObserver.onCompletedCallback = Objects.requireNonNull(onCompletedCallback);
        return this;
    }

    public Subscription subscribe() {
        if (this.watchStreamObserver.onNextCallback == null || this.watchStreamObserver.onErrorCallback == null) {
            throw new IllegalStateException("Please provide at least an onNext and an onError callback");
        }
        String subscriptionId = this.watchRequestBuilder.subscriptionId;
        if (subscriptionId == null || subscriptionId.isEmpty()) {
            subscriptionId = UUID.randomUUID().toString();
            this.watchRequestBuilder.subscriptionId(subscriptionId);
        }
        this.watchStreamObserver.setSubscriptionId(subscriptionId);
        Context.CancellableContext withCancellation = Context.current().withCancellation();
        withCancellation.run(() -> this.watchClient.watch(this.watchRequestBuilder.build(), this.watchStreamObserver, this.metadata));
        return () -> {
            try (Context.CancellableContext cancellableContext = withCancellation;){
                withCancellation.cancel((Throwable)CLIENT_CANCELLED_WATCH);
            }
        };
    }

    private static class WatchRequest {
        private final GroupVersionKind gvk;
        private final String subscriptionId;
        private final String continueToken;
        private final boolean includeSnapshot;
        private final boolean useAsyncSnapshot;
        private final List<String> labelSelectors;
        private final List<String> fieldSelectors;
        private final String location;
        private final boolean allLocations;

        public List<String> getLabelSelectors() {
            return Optional.ofNullable(this.labelSelectors).orElse(Collections.emptyList());
        }

        public List<String> getFieldSelectors() {
            return Optional.ofNullable(this.fieldSelectors).orElse(Collections.emptyList());
        }

        public String getSubscriptionId() {
            return Optional.ofNullable(this.subscriptionId).orElse("");
        }

        public String getContinueToken() {
            return Optional.ofNullable(this.continueToken).orElse("");
        }

        public String getLocation() {
            return Optional.ofNullable(this.location).orElse("");
        }

        @Generated
        WatchRequest(GroupVersionKind gvk, String subscriptionId, String continueToken, boolean includeSnapshot, boolean useAsyncSnapshot, List<String> labelSelectors, List<String> fieldSelectors, String location, boolean allLocations) {
            this.gvk = gvk;
            this.subscriptionId = subscriptionId;
            this.continueToken = continueToken;
            this.includeSnapshot = includeSnapshot;
            this.useAsyncSnapshot = useAsyncSnapshot;
            this.labelSelectors = labelSelectors;
            this.fieldSelectors = fieldSelectors;
            this.location = location;
            this.allLocations = allLocations;
        }

        @Generated
        public static WatchRequestBuilder builder() {
            return new WatchRequestBuilder();
        }

        @Generated
        public GroupVersionKind getGvk() {
            return this.gvk;
        }

        @Generated
        public boolean isIncludeSnapshot() {
            return this.includeSnapshot;
        }

        @Generated
        public boolean isUseAsyncSnapshot() {
            return this.useAsyncSnapshot;
        }

        @Generated
        public boolean isAllLocations() {
            return this.allLocations;
        }

        @Generated
        public static class WatchRequestBuilder {
            @Generated
            private GroupVersionKind gvk;
            @Generated
            private String subscriptionId;
            @Generated
            private String continueToken;
            @Generated
            private boolean includeSnapshot;
            @Generated
            private boolean useAsyncSnapshot;
            @Generated
            private List<String> labelSelectors;
            @Generated
            private List<String> fieldSelectors;
            @Generated
            private String location;
            @Generated
            private boolean allLocations;

            @Generated
            WatchRequestBuilder() {
            }

            @Generated
            public WatchRequestBuilder gvk(GroupVersionKind gvk) {
                this.gvk = gvk;
                return this;
            }

            @Generated
            public WatchRequestBuilder subscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            @Generated
            public WatchRequestBuilder continueToken(String continueToken) {
                this.continueToken = continueToken;
                return this;
            }

            @Generated
            public WatchRequestBuilder includeSnapshot(boolean includeSnapshot) {
                this.includeSnapshot = includeSnapshot;
                return this;
            }

            @Generated
            public WatchRequestBuilder useAsyncSnapshot(boolean useAsyncSnapshot) {
                this.useAsyncSnapshot = useAsyncSnapshot;
                return this;
            }

            @Generated
            public WatchRequestBuilder labelSelectors(List<String> labelSelectors) {
                this.labelSelectors = labelSelectors;
                return this;
            }

            @Generated
            public WatchRequestBuilder fieldSelectors(List<String> fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            @Generated
            public WatchRequestBuilder location(String location) {
                this.location = location;
                return this;
            }

            @Generated
            public WatchRequestBuilder allLocations(boolean allLocations) {
                this.allLocations = allLocations;
                return this;
            }

            @Generated
            public WatchRequest build() {
                return new WatchRequest(this.gvk, this.subscriptionId, this.continueToken, this.includeSnapshot, this.useAsyncSnapshot, this.labelSelectors, this.fieldSelectors, this.location, this.allLocations);
            }

            @Generated
            public String toString() {
                return "Watcher.WatchRequest.WatchRequestBuilder(gvk=" + String.valueOf(this.gvk) + ", subscriptionId=" + this.subscriptionId + ", continueToken=" + this.continueToken + ", includeSnapshot=" + this.includeSnapshot + ", useAsyncSnapshot=" + this.useAsyncSnapshot + ", labelSelectors=" + String.valueOf(this.labelSelectors) + ", fieldSelectors=" + String.valueOf(this.fieldSelectors) + ", location=" + this.location + ", allLocations=" + this.allLocations + ")";
            }
        }
    }

    private static class WatchClientV1<T extends HasMetadata>
    implements WatchClient<T> {
        private final WatchGrpc.WatchStub watchStub;
        private final JavaType javaType;
        private final GroupVersionKind gvk;

        WatchClientV1(Channel channel, JavaType javaType, GroupVersionKind gvk) {
            this.javaType = javaType;
            this.gvk = gvk;
            this.watchStub = WatchGrpc.newStub(channel);
        }

        @Override
        public void watch(WatchRequest request, StreamObserver<WatchEvent<T>> responseObserver, Metadata metadata) {
            String apiVersion = String.format("%s/%s", request.getGvk().group(), request.getGvk().version());
            TypeMeta objectType = TypeMeta.newBuilder().setApiVersion(apiVersion).setKind(request.getGvk().kind()).build();
            WatchRequest.Builder v1RequestBuilder = resourcemanager.watch.v1.WatchRequest.newBuilder().setObjectType(objectType).setSubscriptionId(request.getSubscriptionId()).setContinueToken(request.getContinueToken()).setIncludeSnapshot(request.isIncludeSnapshot()).setUseAsyncSnapshot(request.isUseAsyncSnapshot()).setLocation(request.getLocation()).setAllLocations(request.isAllLocations());
            request.getLabelSelectors().forEach(v1RequestBuilder::addLabelSelector);
            request.getFieldSelectors().forEach(v1RequestBuilder::addFieldSelector);
            ((WatchGrpc.WatchStub)((WatchGrpc.WatchStub)this.watchStub.withWaitForReady()).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).watch(v1RequestBuilder.build(), new FlatMappedStreamObserver<WatchEvent<T>, resourcemanager.watch.v1.WatchResponse>(responseObserver, res -> res.getEventsList().stream().map(event -> {
                try {
                    WatchEvent watchEvent = WatchEvent.fromV1Event(event, this.javaType);
                    Object object = watchEvent.object();
                    if (object instanceof Adapter) {
                        Adapter adapter = (Adapter)object;
                        adapter.setGroupVersionKind(this.gvk);
                    }
                    logger.trace("received watch event: type {}, subscriptionId: {}", (Object)watchEvent.eventType(), (Object)request.getSubscriptionId());
                    return watchEvent;
                }
                catch (IOException e) {
                    throw new StatusRuntimeException(io.grpc.Status.fromThrowable((Throwable)e));
                }
            })));
        }
    }

    private static interface WatchClient<T extends HasMetadata> {
        public void watch(WatchRequest var1, StreamObserver<WatchEvent<T>> var2, Metadata var3);
    }

    private static class WatchClientV1Alpha<T extends HasMetadata>
    implements WatchClient<T> {
        private final WatchGrpc.WatchStub watchStub;
        private final JavaType javaType;
        private final GroupVersionKind gvk;

        WatchClientV1Alpha(Channel channel, JavaType javaType, GroupVersionKind gvk) {
            this.javaType = javaType;
            this.gvk = gvk;
            this.watchStub = io.confluent.flink.watch.v1alpha1.WatchGrpc.newStub(channel);
        }

        @Override
        public void watch(WatchRequest request, StreamObserver<WatchEvent<T>> responseObserver, Metadata metadata) {
            String apiVersion = String.format("%s/%s", request.getGvk().group(), request.getGvk().version());
            io.confluent.flink.watch.v1alpha1.TypeMeta objectType = io.confluent.flink.watch.v1alpha1.TypeMeta.newBuilder().setApiVersion(apiVersion).setKind(request.getGvk().kind()).build();
            WatchRequest.Builder v1alphaRequestBuilder = io.confluent.flink.watch.v1alpha1.WatchRequest.newBuilder().setObjectType(objectType).setSubscriptionId(request.getSubscriptionId()).setContinueToken(request.getContinueToken()).setIncludeSnapshot(request.isIncludeSnapshot()).setUseAsyncSnapshot(request.isUseAsyncSnapshot()).setLocation(request.getLocation()).setAllLocations(request.isAllLocations());
            request.getLabelSelectors().forEach(v1alphaRequestBuilder::addLabelSelector);
            request.getFieldSelectors().forEach(v1alphaRequestBuilder::addFieldSelector);
            ((WatchGrpc.WatchStub)((WatchGrpc.WatchStub)this.watchStub.withWaitForReady()).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).watch(v1alphaRequestBuilder.build(), new FlatMappedStreamObserver<WatchEvent<T>, WatchResponse>(responseObserver, res -> res.getEventsList().stream().map(event -> {
                try {
                    WatchEvent watchEvent = WatchEvent.fromV1AlphaEvent(event, this.javaType);
                    Object object = watchEvent.object();
                    if (object instanceof Adapter) {
                        Adapter adapter = (Adapter)object;
                        adapter.setGroupVersionKind(this.gvk);
                    }
                    logger.trace("received watch event: type {}, subscriptionId: {}", (Object)watchEvent.eventType(), (Object)request.getSubscriptionId());
                    return watchEvent;
                }
                catch (IOException e) {
                    throw new StatusRuntimeException(io.grpc.Status.fromThrowable((Throwable)e));
                }
            })));
        }
    }

    private static class WatchStreamObserver<T extends HasMetadata>
    implements StreamObserver<WatchEvent<T>> {
        private static final Logger logger = LoggerFactory.getLogger(WatchStreamObserver.class);
        private Consumer<WatchEvent<T>> onNextCallback;
        private Consumer<Throwable> onErrorCallback;
        private Runnable onCompletedCallback;
        private String subscriptionId;

        WatchStreamObserver() {
        }

        void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public void onNext(WatchEvent<T> watchEvent) {
            this.onNextCallback.accept(watchEvent);
        }

        public void onError(Throwable throwable) {
            if (this.hasClientCancelled(throwable)) {
                logger.debug("client cancelled: subscriptionId: {}", (Object)this.subscriptionId);
                this.onCompleted();
                return;
            }
            com.google.rpc.Status status = StatusProto.fromThrowable((Throwable)throwable);
            if (status == null) {
                logger.trace("watch error without status: {}, subscriptionId: {}", (Object)throwable, (Object)this.subscriptionId);
                this.onErrorCallback.accept(throwable);
                return;
            }
            for (Any detail : status.getDetailsList()) {
                try {
                    io.confluent.resourcemanager.protobuf.apis.meta.v1.Status rmProtoStatus = (io.confluent.resourcemanager.protobuf.apis.meta.v1.Status)detail.unpack(io.confluent.resourcemanager.protobuf.apis.meta.v1.Status.class);
                    if (rmProtoStatus == null) continue;
                    Status mappedStatus = WatchStreamObserver.mapProtoStatus(rmProtoStatus);
                    logger.trace("watch error: {}, subscriptionId: {}", (Object)mappedStatus, (Object)this.subscriptionId);
                    this.onErrorCallback.accept(new ApiException(mappedStatus));
                    return;
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                }
            }
            logger.trace("watch error without API status: {}, subscriptionId: {}", (Object)throwable, (Object)this.subscriptionId);
            this.onErrorCallback.accept(throwable);
        }

        private static Status mapProtoStatus(io.confluent.resourcemanager.protobuf.apis.meta.v1.Status rmProtoStatus) {
            ListMeta mappedMeta = new ListMeta(rmProtoStatus.getMetadata().getContinue(), rmProtoStatus.getMetadata().getRemainingItemCount());
            io.confluent.resourcemanager.api.model.StatusDetails details = null;
            if (rmProtoStatus.hasDetails()) {
                StatusDetails protoDetails = rmProtoStatus.getDetails();
                details = new io.confluent.resourcemanager.api.model.StatusDetails(protoDetails.getName(), protoDetails.getGroup(), protoDetails.getKind(), protoDetails.getUid().isEmpty() ? null : UUID.fromString(protoDetails.getUid()), protoDetails.getCausesList().stream().map(protoCause -> new StatusCause(StatusCause.CauseType.fromString(protoCause.getReason()), protoCause.getMessage(), protoCause.getField())).collect(Collectors.toList()), protoDetails.getRetryAfterSeconds());
            }
            return new Status(mappedMeta, rmProtoStatus.getStatus(), rmProtoStatus.getMessage(), Status.Reason.fromString(rmProtoStatus.getReason()), details, rmProtoStatus.getCode());
        }

        private boolean hasClientCancelled(Throwable throwable) {
            io.grpc.Status status = io.grpc.Status.fromThrowable((Throwable)throwable);
            Status.Code clientCancelledCode = CLIENT_CANCELLED_WATCH.getStatus().getCode();
            String clientCancelledDesc = CLIENT_CANCELLED_WATCH.getStatus().getDescription();
            return status.getCode() == clientCancelledCode && status.getDescription() != null && status.getDescription().equals(clientCancelledDesc);
        }

        public void onCompleted() {
            if (this.onCompletedCallback == null) {
                return;
            }
            this.onCompletedCallback.run();
        }
    }

    public static interface Subscription
    extends AutoCloseable {
        @Override
        public void close();
    }

    private static class FlatMappedStreamObserver<T, R>
    implements StreamObserver<R> {
        private final StreamObserver<T> wrappedObserver;
        private final Function<R, Stream<T>> mapper;
        private static final Logger logger = LoggerFactory.getLogger(FlatMappedStreamObserver.class);

        FlatMappedStreamObserver(StreamObserver<T> wrappedObserver, Function<R, Stream<T>> mapper) {
            this.wrappedObserver = wrappedObserver;
            this.mapper = mapper;
        }

        public void onNext(R value) {
            this.mapper.apply(value).forEach(arg_0 -> this.wrappedObserver.onNext(arg_0));
        }

        public void onError(Throwable t) {
            this.wrappedObserver.onError(t);
        }

        public void onCompleted() {
            this.wrappedObserver.onCompleted();
        }
    }
}

