/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model.identifier;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.List;
import lombok.Generated;

public class ObjectIdentifier<T extends HasMetadata> {
    private final String group;
    private final String version;
    private final String kind;
    private final Location location;
    private final List<ScopeAttribute> scope;
    private final String name;
    private final JavaType javaType;

    public ObjectIdentifier(Location location, List<ScopeAttribute> scope, String name, Class<?> clazz) {
        this(location, scope, name, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructType(clazz), new GroupVersionKind(HasMetadata.getGroup(clazz), HasMetadata.getVersion(clazz), HasMetadata.getKind(clazz)));
    }

    public ObjectIdentifier(T obj) {
        this(Location.from(obj.getMetadata().getLocation()), obj.getMetadata().getScopeList(), obj.getMetadata().getName(), ClientImpl.OBJECT_MAPPER.getTypeFactory().constructType(obj.getClass()), new GroupVersionKind(obj.getGroup(), obj.getVersion(), obj.getKind()));
    }

    public ObjectIdentifier(Location location, List<ScopeAttribute> scope, String name, JavaType javaType, GroupVersionKind gvk) {
        this.location = location;
        this.scope = scope;
        this.name = name;
        this.javaType = javaType;
        this.group = gvk.group();
        this.version = gvk.version();
        this.kind = gvk.kind();
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getKind() {
        return this.kind;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public List<ScopeAttribute> getScope() {
        return this.scope;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public JavaType getJavaType() {
        return this.javaType;
    }

    @Generated
    public String toString() {
        return "ObjectIdentifier(group=" + this.getGroup() + ", version=" + this.getVersion() + ", kind=" + this.getKind() + ", location=" + String.valueOf(this.getLocation()) + ", scope=" + String.valueOf(this.getScope()) + ", name=" + this.getName() + ", javaType=" + String.valueOf(this.getJavaType()) + ")";
    }
}

