/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.http;

import io.confluent.kafka.security.auth.plain.DynamicPlainClientCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler;
import io.confluent.security.auth.client.provider.BasicAuthCredentialProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.LoginManager;

public class FileBasedDynamicBasicAuthCredentialProvider
implements BasicAuthCredentialProvider {
    public static final String DYNAMIC_FILE = "DYNAMIC_FILE";
    private static final String PLAIN_MECHANISM = "PLAIN";
    private LoginManager loginManager;

    public void configure(Map<String, ?> configs) {
        String credentialFile = (String)configs.get("confluent.metadata.basic.auth.credentials.path");
        if (credentialFile == null) {
            throw new ConfigException("confluent.metadata.basic.auth.credentials.path not configured for " + this.getClass().getName());
        }
        HashMap loginConfigs = new HashMap(configs);
        String saslJaasConfig = String.format("%s required credentials_path=\"%s\";", DynamicPlainLoginModule.class.getName(), credentialFile);
        loginConfigs.put("sasl.jaas.config", new Password(saslJaasConfig));
        loginConfigs.put("sasl.login.callback.handler.class", FileBasedDynamicPlainLoginCallbackHandler.class);
        loginConfigs.put("sasl.client.callback.handler.class", DynamicPlainClientCallbackHandler.class);
        try {
            JaasContext jaasContext = JaasContext.loadClientContext(loginConfigs);
            this.loginManager = LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)PLAIN_MECHANISM, DefaultLogin.class, loginConfigs);
        }
        catch (Throwable t) {
            throw new ConfigException("Failed to configure login manager for " + this.getClass().getName(), (Object)t);
        }
    }

    @Override
    public String providerName() {
        return DYNAMIC_FILE;
    }

    @Override
    public String getUserInfo() {
        if (this.loginManager == null) {
            throw new IllegalStateException("Basic auth provider has not been configured");
        }
        Set<DynamicPlainCredential> credentials = this.loginManager.subject().getPrivateCredentials(DynamicPlainCredential.class);
        if (credentials.isEmpty()) {
            throw new AuthenticationException("No dynamic SASL/PLAIN credentials available");
        }
        DynamicPlainCredential credential = credentials.iterator().next();
        return String.format("%s:%s", credential.username(), new String(credential.password()));
    }
}

